/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.lib.SCSResponseCode;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StitchingComputationService
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(StitchingComputationService.class);

    public StitchingComputationService(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull JFedPreferences jFedPreferences) {
        this(logger2, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    public StitchingComputationService(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_SCS, 1), jFedPreferences);
    }

    public static String getApiName() {
        return "Stitching Computation Service";
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            Map codeStruct = (Map)geniDetails.getResultCode();
            int code = (Integer)codeStruct.get("geni_code");
            try {
                return SCSResponseCode.getByCode(code).isBusy();
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code to determine if it is busy", e);
                return false;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public String getName() {
        return StitchingComputationService.getApiName();
    }

    @ApiMethod(order=1, hint="GetVersion call: Get static version and configuration information about this SCS. There is no documentation about this call, but it does exist.")
    public SCSReply<Map> getVersion(SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(Collections.emptyMap(), con, "getVersion", "GetVersion", new ArrayList<Object>(), AbstractApi::apiSpecifiesMapStringToObject);
    }

    @ApiMethod(order=2, hint="ComputePath call: Compute a Network Stitching Path. See https://wiki.maxgigapop.net/twiki/bin/view/GENI/NetworkStitchingAPI")
    public SCSReply<ComputePathResult> computePath(SfaConnection con, @ApiMethodParameter(name="sliceUrn", hint="The slice on which everything needs to be created", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull String sliceUrn, @ApiMethodParameter(name="requestRspec", hint="request rspec with or without stitching extensions", parameterType=ApiMethodParameterType.RSPEC_STRING) @Nonnull String requestRspec, @ApiMethodParameter(name="requestOptions", required=false, hint="optional options") @Nullable Map<String, Object> requestOptions) throws JFedException {
        Map<String, Object> methodParams = StitchingComputationService.makeMethodParameters("sliceUrn", sliceUrn, "requestRspec", requestRspec, "requestOptions", requestOptions);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("slice_urn", sliceUrn);
        args.put("request_rspec", requestRspec);
        if (requestOptions != null) {
            args.put("request_options", requestOptions);
        } else {
            args.put("request_options", Collections.emptyMap());
        }
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "computePath", "ComputePath", StitchingComputationService.singletonList(args), StitchingComputationService::processComputePathResultReply);
    }

    @Nonnull
    private static ComputePathResult processComputePathResultReply(@Nullable Object resultValueObject) throws BadReplyGeniException {
        Map<String, Object> workFlowData;
        String rspec;
        Map<String, Object> resultMap = StitchingComputationService.apiSpecifiesMapStringToObject(resultValueObject);
        try {
            rspec = StitchingComputationService.apiSpecifiesNonNullString(resultMap.get("service_rspec"));
        }
        catch (BadReplyGeniException e) {
            LOG.warn("SCS ComputePath service_rspec could not be extracted from reply", e);
            throw new BadReplyGeniException("SCS ComputePath service_rspec could not be extracted from reply", (Exception)e);
        }
        try {
            workFlowData = StitchingComputationService.apiSpecifiesMapStringToObject(resultMap.get("workflow_data"));
        }
        catch (BadReplyGeniException e) {
            LOG.warn("SCS WorkFlow could not be extracted from reply", e);
            throw new BadReplyGeniException("SCS WorkFlow could not be extracted from reply", (Exception)e);
        }
        return new ComputePathResult(workFlowData, rspec);
    }

    @Nonnull
    private static List<Object> singletonList(Object value) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(value);
        return args;
    }

    @ApiMethod(order=2, hint="ComputePath call with extra options: Compute a Network Stitching Path. See https://wiki.maxgigapop.net/twiki/bin/view/GENI/NetworkStitchingAPI")
    public SCSReply<ComputePathResult> computePathWithOptions(SfaConnection con, @ApiMethodParameter(name="sliceUrn", hint="The slice on which everything needs to be created", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull String sliceUrn, @ApiMethodParameter(name="requestRspec", hint="request rspec with or without stitching extensions", parameterType=ApiMethodParameterType.RSPEC_STRING) @Nonnull String requestRspec, @ApiMethodParameter(name="requestOptions", required=false, hint="optional options") @Nullable Map<String, Object> requestOptions, @ApiMethodParameter(name="geniHoldPath", required=false, guiDefault="false", hint="optional, default=false. SCS to hold the path exclusively for a preconfigured holding period to avoid contention") @Nullable Boolean geniHoldPath, @ApiMethodParameter(name="geniStartTime", required=false, hint="optional, default=now, projected starting time for the stitching path(s)") @Nullable Date geniStartTime, @ApiMethodParameter(name="geniEndTime", required=false, hint="optional, default=infinite, projected expiration time for the stitching path(s)") @Nullable Date geniEndTime, @ApiMethodParameter(name="geniRoutingProfile", required=false, guiDefault="{ 'hop_inclusion_list': [] , 'hop_exclusion_list': [] }", hint="optional,  a struct of {path_id: routing_profile} map. The path_id corresponding to a stitching path id in request_rspec. routing_profile is a struct of two optional items {'hop_inclusion_list': array of urn strings} and {'hop_exclusion_list': array of urn strings}.") @Nullable Map geniRoutingProfile, @ApiMethodParameter(name="geniWorkflowData", required=false, guiDefault="true", hint="optional, default=true, SCS to return workflow data in support of user / agent / tool workflow logic.") @Nullable Boolean geniWorkflowData) throws JFedException {
        if (requestOptions == null) {
            requestOptions = new HashMap<String, Object>();
        }
        StitchingComputationService.addOptionToRequest(geniHoldPath, "geni_hold_path", requestOptions);
        StitchingComputationService.addOptionToRequest(geniStartTime != null ? RFC3339Util.dateToRFC3339String(geniStartTime, true) : null, "geni_start_time", requestOptions);
        StitchingComputationService.addOptionToRequest(geniEndTime != null ? RFC3339Util.dateToRFC3339String(geniEndTime, true) : null, "geni_end_time", requestOptions);
        StitchingComputationService.addOptionToRequest(geniRoutingProfile, "geni_routing_profile", requestOptions);
        StitchingComputationService.addOptionToRequest(geniWorkflowData, "geni_workflow_data", requestOptions);
        return this.computePath(con, sliceUrn, requestRspec, requestOptions);
    }

    private static void addOptionToRequest(Object fieldValue, String fieldName, Map<String, Object> requestOptions) {
        if (fieldValue != null) {
            if (requestOptions.containsKey(fieldName)) {
                throw new IllegalArgumentException(fieldName + " was already declared in requestOptions.");
            }
            requestOptions.put(fieldName, fieldValue);
        }
    }

    protected <T> SCSReply<T> executeAndLogXmlRpcCommandGeni(@Nonnull Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter, null);
    }

    protected <T> SCSReply<T> executeAndLogXmlRpcCommandGeni(@Nonnull Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter, @Nullable T defaultValue) throws JFedException {
        SCSReply<T> r;
        XMLRPCCallDetailsWithCodeValueError res = this.executeXmlRpcCommandGeni(con, methodGeniName, args, methodParams);
        Object resultValueObject = res.getResultValueObject();
        if (resultValueObject != null && !Objects.equals(resultValueObject, 0)) {
            try {
                r = new SCSReply<T>(res, replyConverter.convertXMLRPCCall(resultValueObject));
            }
            catch (AssertionError | Exception t) {
                this.handleErrorProcessingArguments(res, methodJavaName, methodGeniName, con, (Throwable)t);
                r = null;
            }
        } else {
            r = null;
        }
        if (r == null) {
            r = new SCSReply<T>(res, defaultValue);
        }
        this.log(res, r, methodJavaName, methodGeniName, con, methodParams);
        return r;
    }

    protected void handleErrorProcessingArguments(XMLRPCCallDetailsWithCodeValueError res, String methodJavaName, String methodGeniName, SfaConnection con, Throwable t) throws JFedException {
        if (StitchingComputationService.isCallSuccess(res)) {
            this.log(res, null, methodJavaName, methodGeniName, con, null);
            throw new JFedException("Error parsing " + methodGeniName + " reply: " + (t == null ? "null" : t.getMessage()), t, res);
        }
        LOG.error("Error parsing {} reply: {}", methodGeniName, t.getMessage(), t);
    }

    private static boolean isCallSuccess(XMLRPCCallDetailsWithCodeValueError res) {
        Object resultCode = res.getResultCode();
        if (!(resultCode instanceof Integer)) {
            return false;
        }
        try {
            GeniAMResponseCode genicode = GeniAMResponseCode.getByCode((Integer)resultCode);
            return genicode.isSuccess();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static class SCSReply<T>
    implements SfaApiCallReply<T> {
        private final XMLRPCCallDetailsWithCodeValueError xmlRpcCallDetailsWithCodeValueError;
        @Nonnull
        private final SCSResponseCode genicode;
        private final T val;
        private final String output;
        private final Map rawResult;

        public SCSReply(XMLRPCCallDetailsWithCodeValueError res, T val) {
            SCSResponseCode genicode;
            this.xmlRpcCallDetailsWithCodeValueError = res;
            this.rawResult = res.getResult();
            Map code = (Map)res.getResultCode();
            int intCode = (Integer)code.get("geni_code");
            try {
                genicode = SCSResponseCode.getByCode(intCode);
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code", e);
                genicode = SCSResponseCode.SERVER_REPLY_ERROR;
            }
            this.genicode = genicode;
            this.val = val;
            this.output = res.getResultOutput();
        }

        public int getCode() {
            return this.genicode.getCode();
        }

        @Override
        @Nonnull
        public SCSResponseCode getGeniResponseCode() {
            return this.genicode;
        }

        @Override
        @Nullable
        public T getValue() {
            return this.val;
        }

        @Override
        @Nullable
        public String getOutput() {
            return this.output;
        }

        @Override
        @Nullable
        public Map getRawResult() {
            return this.rawResult;
        }

        @Override
        @Nullable
        public XMLRPCCallDetailsWithCodeValueError getXMLRPCCallDetailsWithCodeValueError() {
            return this.xmlRpcCallDetailsWithCodeValueError;
        }

        @Override
        @Nullable
        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xmlRpcCallDetailsWithCodeValueError;
        }

        @Override
        @Nullable
        public Object getRawValue() {
            if (this.rawResult == null) {
                return null;
            }
            return this.rawResult.get("value");
        }
    }

    public static class ComputePathResult {
        @Nonnull
        private final String serviceRspec;
        @Nonnull
        private final Map workflowData;

        public ComputePathResult(@Nonnull Map workflowData, @Nonnull String serviceRspec) {
            this.workflowData = workflowData;
            this.serviceRspec = serviceRspec;
        }

        @Nonnull
        public String getServiceRspec() {
            return this.serviceRspec;
        }

        @Nonnull
        public Map getWorkflowData() {
            return this.workflowData;
        }

        public String toString() {
            return "ComputePathResult{serviceRspec='" + this.serviceRspec + "', workflowData=" + this.workflowData + "}";
        }
    }
}

