/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_scripts;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.dropwizard.jackson.Jackson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetProjectsForUsers {
    private static final Logger LOG = LoggerFactory.getLogger(GetProjectsForUsers.class);
    @Nonnull
    private final be.iminds.ilabt.jfed.log.Logger logger;
    @Nonnull
    private final UserAndSliceApiWrapper samaWrapper;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    private final FederationMemberAuthorityApi2 ma;
    @Nonnull
    private final FederationSliceAuthorityApi2 sa;
    @Nonnull
    private final GeniUserProvider geniUserProvider;

    @Inject
    public GetProjectsForUsers(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull JFedConnectionProvider connectionProvider) {
        this.logger = logger2;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        if (!geniUserProvider.isUserLoggedIn()) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a logged in user");
        }
        Server userServer = geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        if (userServer.getServices() == null) {
            throw new IllegalArgumentException("Cannot initialize AutomaticUserAndSliceApiWrapper: userAuth.getServices() = null (userAuth.urn=" + userServer.getDefaultComponentManagerUrn() + ")");
        }
        if (!ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_SA, 2) || !ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_MA, 2)) {
            throw new IllegalArgumentException("user authority should have a \"Common Federation API\" v2 service");
        }
        this.sa = new FederationSliceAuthorityApi2(logger2, jFedPreferences);
        this.ma = new FederationMemberAuthorityApi2(logger2, jFedPreferences);
        this.samaWrapper = automaticUserAndSliceApiWrapperFactory.create();
    }

    private SfaConnection getSAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2));
    }

    private SfaConnection getMAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2));
    }

    @ApiMethod(order=1, hint="List the projects a given user belongs to")
    public Map<GeniUrn, String> getProjectsForUser(@ApiMethodParameter(name="userName", hint="username or urn", parameterType=ApiMethodParameterType.STRING) @Nonnull String userName) throws JFedException {
        GeniUrn user;
        this.samaWrapper.getLocalUserCredentials(this.logger);
        LOG.info("Got credential for user");
        if (userName.startsWith("urn:publicid:IDN+")) {
            try {
                user = new GeniUrn(userName);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Invalid user URN: '" + userName + "'", e);
            }
        } else {
            user = GeniUrn.createGeniUrnFromEncodedParts(this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedTopLevelAuthority_withoutSubAuth(), "user", userName);
        }
        List<AnyCredential> userCredentials = this.samaWrapper.getLocalUserCredentials(this.logger);
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi2.UrnRoleTuple>> reply = this.sa.lookupForMember(this.getSAConnection(), "PROJECT", user, userCredentials, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error when querying user projects: " + reply.getGeniResponseCode());
        }
        List<FederationSliceAuthorityApi2.UrnRoleTuple> roleTuples = reply.getValue();
        if (roleTuples == null) {
            throw new JFedException("No value in reply from SA");
        }
        HashMap<GeniUrn, String> projectToPriv = new HashMap<GeniUrn, String>();
        for (FederationSliceAuthorityApi2.UrnRoleTuple roleTuple : roleTuples) {
            projectToPriv.put(roleTuple.getUrn(), roleTuple.getRole());
        }
        LOG.info("Got projects for user: {}", (Object)projectToPriv);
        return projectToPriv;
    }

    @ApiMethod(order=1, hint="List the projects a given user belongs to")
    public Map<GeniUrn, Map<GeniUrn, String>> getProjectsForUsers(@ApiMethodParameter(name="userNames", hint="list of usernames or urns", parameterType=ApiMethodParameterType.LIST_OF_USER_URN_STRING) @Nonnull List<String> userNames) throws JFedException {
        HashMap<GeniUrn, Map<GeniUrn, String>> res = new HashMap<GeniUrn, Map<GeniUrn, String>>();
        for (String userName : userNames) {
            GeniUrn user;
            if (userName.startsWith("urn:publicid:IDN+")) {
                try {
                    user = new GeniUrn(userName);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new JFedException("Invalid user URN: '" + userName + "'", e);
                }
            } else {
                user = GeniUrn.createGeniUrnFromEncodedParts(this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedTopLevelAuthority_withoutSubAuth(), "user", userName);
            }
            res.put(user, this.getProjectsForUser(userName));
        }
        return res;
    }

    public String getProjectsForUsersAsJson(@ApiMethodParameter(name="userNames", hint="list of usernames or urns", parameterType=ApiMethodParameterType.LIST_OF_USER_URN_STRING) @Nonnull List<String> userNames) throws JFedException {
        Map<GeniUrn, Map<GeniUrn, String>> r = this.getProjectsForUsers(userNames);
        try {
            return Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(r);
        }
        catch (JsonProcessingException e) {
            throw new JFedException("Error converting result to JSON", e);
        }
    }

    public String getProjectsForUserAsJson(@ApiMethodParameter(name="userName", hint="username or urn", parameterType=ApiMethodParameterType.STRING) @Nonnull String userName) throws JFedException {
        Map<GeniUrn, String> r = this.getProjectsForUser(userName);
        try {
            return Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(r);
        }
        catch (JsonProcessingException e) {
            throw new JFedException("Error converting result to JSON", e);
        }
    }
}

