/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public abstract class ApiWrapper {
    private static final org.slf4j.Logger parentLOG = LoggerFactory.getLogger(ApiWrapper.class);
    @Nonnull
    protected final Logger logger;
    @Nonnull
    protected final GeniUserProvider geniUserProvider;
    @Nonnull
    protected final JFedConnectionProvider connectionProvider;
    @Nonnull
    protected final JFedPreferences jFedPreferences;
    protected List<AnyCredential> speaksForCredentials;
    @Nullable
    protected GeniUrn speaksForUserUrn;

    protected ApiWrapper(@Nonnull Logger logger2, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences) {
        this.logger = logger2;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        this.jFedPreferences = jFedPreferences;
    }

    public List<AnyCredential> filterCredentials(@Nonnull List<AnyCredential> origCredentials) {
        List<AnyCredential> res = origCredentials.stream().filter(cred -> cred instanceof SfaCredential || cred instanceof AbacCredential && cred.isSpeaksFor()).collect(Collectors.toList());
        if (res.isEmpty() && !origCredentials.isEmpty()) {
            parentLOG.warn("Unknown what is a good credential to use. Will just use first one received (type=" + origCredentials.get(0).getClass().getName() + ").");
            res.add(origCredentials.get(0));
        }
        parentLOG.debug("ApiWrapper.filterCredentials started with  " + origCredentials.size() + " credentials and ended with " + res.size());
        return res;
    }

    public void setSpeaksFor(@Nullable List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        this.speaksForCredentials = speaksForCredentials == null ? Collections.emptyList() : speaksForCredentials;
        this.speaksForUserUrn = speakingForUrn;
    }

    public boolean isSpeaksFor() {
        return this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty();
    }

    public List<AnyCredential> getSpeaksForCredentials() {
        return this.speaksForCredentials;
    }

    @Nullable
    public GeniUrn getSpeaksForUserUrn() {
        return this.speaksForUserUrn;
    }

    @Nonnull
    public List<AnyCredential> addSpeaksForCredentials(@Nonnull List<AnyCredential> origCredentials) {
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>(origCredentials);
        if (this.speaksForCredentials != null) {
            List speaksForCredsToAdd = this.speaksForCredentials.stream().filter(speaksForCredential -> res.stream().noneMatch(existingCred -> ApiWrapper.identicalCredentialXmls(speaksForCredential, existingCred))).collect(Collectors.toList());
            res.addAll(speaksForCredsToAdd);
        }
        parentLOG.debug("AggregateManagerWrapper.addSpeaksForCredentials started with  {} credentials and ended with {}", (Object)origCredentials.size(), (Object)res.size());
        return res;
    }

    private static boolean identicalCredentialXmls(@Nonnull AnyCredential a1, @Nonnull AnyCredential a2) {
        return Objects.equals(a1.getCredentialXml(), a2.getCredentialXml());
    }

    @Nonnull
    public List<AnyCredential> finalizeSliceCredentials(@Nonnull List<AnyCredential> origCredentials) {
        List<AnyCredential> res = this.filterCredentials(origCredentials);
        res = this.addSpeaksForCredentials(res);
        parentLOG.debug("AggregateManagerWrapper.finalizeSliceCredentials started with {} credentials and ended with {}", (Object)origCredentials.size(), (Object)res.size());
        return Collections.unmodifiableList(res);
    }
}

