/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserAndSliceApiWrapper
extends ApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(UserAndSliceApiWrapper.class);
    public static final int CREDENTIAL_EXPIRATION_MARGIN_IN_MS = 120000;
    @Nullable
    protected Map<String, ?> extraOptionsForCallsWithCredential;

    public UserAndSliceApiWrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences) {
        super(logger2, geniUserProvider, connectionProvider, jFedPreferences);
    }

    @Nonnull
    protected SfaConnection getConnection(@Nonnull ApiInfo.Api api) throws JFedException {
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        Server userAuthServer = user.getUserAuthorityServer();
        assert (userAuthServer != null);
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(user, userAuthServer, api);
    }

    protected GeniUser getLoggedInUser() {
        return this.geniUserProvider.getLoggedInGeniUser();
    }

    @Nullable
    protected Server getLoggedInUserAuthorityServer() {
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        return user.getUserAuthorityServer();
    }

    @Nullable
    protected GeniUrn getRelevantUserUrn() {
        if (this.speaksForUserUrn != null) {
            return this.speaksForUserUrn;
        }
        return this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
    }

    @Nullable
    protected String getRelevantUserUrnString() {
        GeniUrn u = this.getRelevantUserUrn();
        return u == null ? null : u.toString();
    }

    public List<AnyCredential> getLocalUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2) throws JFedException {
        assert (this.getRelevantUserUrn() != null);
        return this.getUserCredentials(logger2, this.getRelevantUserUrn());
    }

    public abstract boolean hasUserCredentials();

    public abstract boolean hasSpeaksForSupport();

    @Override
    public void setSpeaksFor(@Nullable List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        assert (this.hasSpeaksForSupport());
    }

    public void setExtraOptionsForCallsWithCredential(@Nullable Map<String, ?> extraOptionsForCallsWithCredential) {
        this.extraOptionsForCallsWithCredential = extraOptionsForCallsWithCredential;
    }

    @Nullable
    protected Map<String, Object> addCredentialExtraOptions(@Nullable Map<String, Object> extraOptions) {
        if (this.extraOptionsForCallsWithCredential == null) {
            return extraOptions;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (extraOptions != null) {
            res.putAll(extraOptions);
        }
        res.putAll(this.extraOptionsForCallsWithCredential);
        return res;
    }

    protected boolean hasUserCredentials(@Nullable List<AnyCredential> userCredentials) {
        if (userCredentials == null || userCredentials.isEmpty()) {
            return false;
        }
        boolean hasUnknownCredential = false;
        boolean hasValidCredential = false;
        boolean hasExpiredCredential = false;
        ArrayList<AnyCredential> toRemove = new ArrayList<AnyCredential>();
        for (AnyCredential existingCredential : userCredentials) {
            if (existingCredential.getExpiresDate() == null) {
                LOG.warn("UserAndSliceApiWrapper could not determine an expirationDate for the current credential. We assume it is still valid.");
                hasUnknownCredential = true;
                continue;
            }
            Date now = new Date(System.currentTimeMillis() + 120000L);
            if (existingCredential.getExpiresDate().before(now)) {
                hasExpiredCredential = true;
                LOG.info("UserAndSliceApiWrapper.hasUserCredentials encountered an expired credential");
                toRemove.add(existingCredential);
                continue;
            }
            hasValidCredential = true;
        }
        userCredentials.removeAll(toRemove);
        if (hasUnknownCredential && hasExpiredCredential) {
            LOG.warn("UserAndSliceApiWrapper.hasUserCredentials encountered a credential with unknown expire time, and one with expired time. Will have to assume there IS a valid credential.");
        }
        if (hasValidCredential) {
            return true;
        }
        if (hasUnknownCredential) {
            return true;
        }
        if (hasExpiredCredential) {
            return false;
        }
        return false;
    }

    public abstract List<AnyCredential> getCachedUserCredentialsForAM();

    public abstract List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2) throws JFedException;

    public abstract List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2) throws JFedException;

    public abstract List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2) throws JFedException;

    public abstract List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull List<AnyCredential> var2, @Nonnull GeniUrn var3) throws JFedException;

    public abstract Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull List<AnyCredential> var2, @Nonnull GeniUrn var3) throws JFedException;

    public abstract boolean isRegisterAggregatesForSliceSupported();

    public void registerAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate, Date sliverCreationDate) throws JFedException {
        throw new UnsupportedOperationException("registerAggregatesForSlice is not supported by this API");
    }

    public void updateSliverExpirationDateInfoForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate) throws JFedException {
        throw new UnsupportedOperationException("updateSliverExpirationDateInfoForSlice is not supported by this API");
    }

    public void unregisterAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nullable Collection<GeniUrn> sliverUrns) throws JFedException {
        throw new UnsupportedOperationException("unregisterAggregatesForSlice is not supported by this API");
    }

    public boolean isSliceRspecSupported() {
        return false;
    }

    public void registerRspec(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull GeniUrn sliceUrn, @Nullable GeniUrn aggregateUrn, @Nonnull String RSpec, @Nonnull Date sliceProvisionDate) throws JFedException {
        throw new UnsupportedOperationException("registerAggregatesForSlice is not supported by this API");
    }

    public SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull String sliceName, @Nullable String subAuthName) throws JFedException {
        return this.createSlice(logger2, sliceName, null, subAuthName);
    }

    public abstract SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull String var2, @Nullable Date var3, @Nullable String var4) throws JFedException;

    public abstract List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull List<AnyCredential> var2, @Nonnull Date var3) throws JFedException;

    @Nonnull
    protected static GeniUrn findSliceUrn(@Nonnull List<AnyCredential> sliceCredentials) {
        for (AnyCredential c : sliceCredentials) {
            if (!(c instanceof SfaCredential)) continue;
            SfaCredential sc = (SfaCredential)c;
            try {
                GeniUrn urn = new GeniUrn(sc.getTargetUrn());
                if (!Objects.equals(urn.getEncodedResourceType(), "slice")) continue;
                return urn;
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new IllegalArgumentException("Credential contains an invalid targetUrn: '" + sc.getTargetUrn() + "'", e);
            }
        }
        throw new IllegalArgumentException("No sliceUrn could be found in the given sliceCredentials");
    }

    public abstract List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2) throws JFedException;

    public abstract SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger var1) throws JFedException;

    public abstract List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2) throws JFedException;

    public abstract void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2, @Nonnull List<AnyCredential> var3, @Nonnull GeniUrn var4) throws JFedException;

    public abstract void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2, @Nonnull List<AnyCredential> var3, @Nonnull List<GeniUrn> var4, @Nonnull String var5) throws JFedException;

    public abstract void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2, @Nonnull List<AnyCredential> var3, @Nonnull GeniUrn var4) throws JFedException;

    public abstract List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull String var2) throws JFedException;

    public abstract List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull GeniUrn var2, @Nonnull List<AnyCredential> var3) throws JFedException;

    public abstract boolean hasSubAuthDetailsSupport();

    public abstract void getSubAuthorityDetails(@Nonnull be.iminds.ilabt.jfed.log.Logger var1, @Nonnull String var2) throws JFedException;

    public static class SliceInfo {
        @Nonnull
        private final String name;
        @Nonnull
        private final GeniUrn urn;
        @Nonnull
        private final List<AnyCredential> credentials;

        public SliceInfo(@Nonnull String name, @Nonnull GeniUrn urn, @Nonnull List<AnyCredential> credentials) {
            assert (!credentials.isEmpty());
            this.name = name;
            this.urn = urn;
            this.credentials = new ArrayList<AnyCredential>(credentials);
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public GeniUrn getUrn() {
            return this.urn;
        }

        @Nonnull
        public List<AnyCredential> getCredentials() {
            return this.credentials;
        }

        @Nonnull
        public String toString() {
            return "SliceInfo{name='" + this.name + "', urn=" + this.urn + ", credentials=" + this.credentials + "}";
        }
    }

    public static enum SubAuthoritySupport {
        SUB_AUTHORITY_MANDATORY,
        SUB_AUTHORITY_OPTIONAL,
        SUB_AUTHORITY_FORBIDDEN;

    }
}

