/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingDirector;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMv3Wrapper
extends AggregateManagerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AMv3Wrapper.class);
    @Nonnull
    private final AggregateManager3 am3;

    @Override
    @Nonnull
    public List<AnyCredential> filterCredentials(@Nonnull List<AnyCredential> origCredentials) {
        assert (this.amServer != null);
        boolean removeAbac = this.amServer.hasFlag(Server.Flag.workaroundRemoveAbacCredential);
        boolean removeSfa = this.amServer.hasFlag(Server.Flag.workaroundRemoveSfaCredential);
        if (!removeAbac && !removeSfa) {
            return origCredentials;
        }
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        for (AnyCredential cred : origCredentials) {
            if (cred instanceof SfaCredential) {
                if (!removeSfa) {
                    res.add(cred);
                } else {
                    LOG.debug("Removing SfaCredential");
                }
            }
            if (!(cred instanceof AbacCredential)) continue;
            if (!removeAbac || cred.isSpeaksFor()) {
                res.add(cred);
                continue;
            }
            LOG.debug("Removing AbacCredential");
        }
        if (res.isEmpty() && !origCredentials.isEmpty()) {
            LOG.warn("After filtering credentials, none are left. Will have to fall back to using them all anyway.");
            return origCredentials;
        }
        return res;
    }

    public AMv3Wrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull Server amServer) {
        super(logger2, geniUserProvider, connectionProvider, jFedPreferences, amServer);
        this.am3 = new AggregateManager3(logger2, jFedPreferences);
    }

    @Nonnull
    public static StatusDetails.SliverStatus getGlobalSliverStatus(@Nonnull AggregateManager3.SliverInfo sliverInfo) {
        String operationalStatus = sliverInfo.getOperationalStatus();
        if (sliverInfo.getAllocationStatus().equalsIgnoreCase("geni_unallocated")) {
            return StatusDetails.SliverStatus.UNALLOCATED;
        }
        if (sliverInfo.getAllocationStatus().equalsIgnoreCase("geni_allocated")) {
            return StatusDetails.SliverStatus.CHANGING;
        }
        if (operationalStatus.equalsIgnoreCase("geni_pending_allocation")) {
            return StatusDetails.SliverStatus.CHANGING;
        }
        if (operationalStatus.equalsIgnoreCase("geni_notready")) {
            return StatusDetails.SliverStatus.NOTREADY;
        }
        if (operationalStatus.equalsIgnoreCase("geni_configuring")) {
            return StatusDetails.SliverStatus.CHANGING;
        }
        if (operationalStatus.equalsIgnoreCase("geni_updating_users")) {
            return StatusDetails.SliverStatus.CHANGING;
        }
        if (operationalStatus.equalsIgnoreCase("geni_stopping")) {
            return StatusDetails.SliverStatus.CHANGING;
        }
        if (operationalStatus.equalsIgnoreCase("geni_ready")) {
            return StatusDetails.SliverStatus.READY;
        }
        if (operationalStatus.equalsIgnoreCase("geni_ready_busy")) {
            return StatusDetails.SliverStatus.READY;
        }
        if (operationalStatus.equalsIgnoreCase("geni_failed")) {
            return StatusDetails.SliverStatus.FAIL;
        }
        LOG.warn("Server returned unknown sliver operationalStatus: '{}'  (allocationStatus={})", (Object)operationalStatus, (Object)sliverInfo.getAllocationStatus());
        return StatusDetails.SliverStatus.UNKNOWN;
    }

    @Nonnull
    protected SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
    }

    @Override
    public Map getVersion() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.VersionInfo> reply = this.am3.getVersion(this.getConnection());
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("GetVersion Call not successful", reply);
        }
        return reply.getRawResult();
    }

    @Override
    public String listResources(@Nonnull List<AnyCredential> userCredentials, boolean available, @Nonnull String type, @Nonnull String version) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<String> reply;
        this.lastAmReply = reply = this.am3.listResources(this.getConnection(), this.addSpeaksForCredentials(this.filterCredentials(userCredentials)), type, version, available, true, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("ListResources Call not successful", reply);
        }
        return reply.getValue();
    }

    @Override
    public boolean hasSeperateAllocateAndProvision() {
        return true;
    }

    @Override
    @Nonnull
    public AllocateReplyAmv3 allocate(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, @Nullable Date requestedExpirationDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyAllocate;
        String endTime = requestedExpirationDate == null ? null : RFC3339Util.dateToRFC3339String(requestedExpirationDate, true, true, true);
        SfaConnection con = this.getConnection();
        this.lastAmReply = replyAllocate = this.am3.allocate(con, sliceUrn.getValue(), this.finalizeSliceCredentials(sliceCredentials), rspec, endTime, this.addCredentialExtraOptions(null));
        if (!replyAllocate.getGeniResponseCode().isSuccess()) {
            if (StitchingDirector.isAnyNotSupported(replyAllocate)) {
                throw new AggregateManagerWrapper.AnyVlanUnsupportedException(replyAllocate);
            }
            if (StitchingDirector.isUnavailableVlan(replyAllocate)) {
                throw new AggregateManagerWrapper.VlanUnavailableException(StitchingDirector.getUnavailableVlan(replyAllocate), replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES)) {
                throw new AggregateManagerWrapper.NotEnoughFreeResourcesException(replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED)) {
                throw new AggregateManagerWrapper.TermsAndConditionsException(replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM)) {
                throw new AggregateManagerWrapper.ReservationProblemException(replyAllocate);
            }
            throw new JFedException("Allocate Call not successful", replyAllocate);
        }
        if (replyAllocate.getValue() == null) {
            throw new JFedException("Allocate call was succesful, but returned nothing", replyAllocate);
        }
        return new AllocateReplyAmv3(replyAllocate.getValue().getSliverInfo(), replyAllocate.getValue().getRspec());
    }

    @Override
    @Nonnull
    public AggregateManagerWrapper.AllocateReply allocate(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, @Nonnull Date startDate, @Nonnull Date endDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyAllocate;
        String startTime = RFC3339Util.dateToRFC3339String(startDate, true, true, true);
        String endTime = RFC3339Util.dateToRFC3339String(endDate, true, true, true);
        Map<String, Object> extraOptionsStartTime = Collections.singletonMap("geni_start_time", startTime);
        this.lastAmReply = replyAllocate = this.am3.allocate(this.getConnection(), sliceUrn.getValue(), this.finalizeSliceCredentials(sliceCredentials), rspec, endTime, this.addCredentialExtraOptionsToMap(extraOptionsStartTime));
        if (!replyAllocate.getGeniResponseCode().isSuccess()) {
            if (StitchingDirector.isAnyNotSupported(replyAllocate)) {
                throw new AggregateManagerWrapper.AnyVlanUnsupportedException(replyAllocate);
            }
            if (StitchingDirector.isUnavailableVlan(replyAllocate)) {
                throw new AggregateManagerWrapper.VlanUnavailableException(StitchingDirector.getUnavailableVlan(replyAllocate), replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES)) {
                throw new AggregateManagerWrapper.NotEnoughFreeResourcesException(replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED)) {
                throw new AggregateManagerWrapper.TermsAndConditionsException(replyAllocate);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyAllocate, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM)) {
                throw new AggregateManagerWrapper.ReservationProblemException(replyAllocate);
            }
            throw new JFedException("Allocate Call not successful", replyAllocate);
        }
        if (replyAllocate.getValue() == null) {
            throw new JFedException("Allocate call was succesful, but returned nothing", replyAllocate);
        }
        return new AllocateReplyAmv3(replyAllocate.getValue().getSliverInfo(), replyAllocate.getValue().getRspec());
    }

    @Override
    public String provisionAndStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable List<UserSpec> users, @Nullable Date requestedExpirationDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyProvision = this.internalProvision(sliceUrn, sliceCredentials, users, requestedExpirationDate);
        this.internalAssureExpireDate(replyProvision, sliceUrn, sliceCredentials, requestedExpirationDate);
        if (replyProvision.getValue() == null) {
            throw new JFedException("Error processing Provision reply");
        }
        String rspec = replyProvision.getValue().getRspec();
        try {
            this.waitForProvisioned(replyProvision, sliceUrn, sliceCredentials);
            this.poaStart(sliceUrn, sliceCredentials);
            this.lastAmReply = replyProvision;
            this.internalAssureExpireDate(replyProvision, sliceUrn, sliceCredentials, requestedExpirationDate);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lastAmReply = replyProvision;
        return rspec;
    }

    private void waitForProvisioned(@Nonnull AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyProvision, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException, InterruptedException {
        if (!replyProvision.getGeniResponseCode().isSuccess()) {
            return;
        }
        if (replyProvision.getValue() == null) {
            return;
        }
        if (replyProvision.getValue().getSliverInfo() == null) {
            return;
        }
        if (replyProvision.getValue().getSliverInfo().isEmpty()) {
            return;
        }
        boolean needToWait = false;
        for (AggregateManager3.SliverInfo sliverInfo : replyProvision.getValue().getSliverInfo()) {
            if (sliverInfo.getAllocationStatus().equalsIgnoreCase("geni_allocated")) {
                needToWait = true;
            }
            if (!sliverInfo.getOperationalStatus().equalsIgnoreCase("geni_pending_allocation")) continue;
            needToWait = true;
        }
        if (!needToWait) {
            return;
        }
        List<String> urns = Collections.singletonList(sliceUrn.getValue());
        Instant timeout = Instant.now().plus(15L, ChronoUnit.MINUTES);
        while (needToWait && !Instant.now().isAfter(timeout)) {
            Thread.sleep(5000L);
            AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo> statusReply = this.am3.status(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), null, this.addCredentialExtraOptions(null));
            if (!statusReply.getGeniResponseCode().isSuccess()) {
                return;
            }
            if (statusReply.getValue() == null) {
                return;
            }
            if (statusReply.getValue().getSliverInfo().isEmpty()) {
                return;
            }
            needToWait = false;
            for (AggregateManager3.SliverInfo sliverInfo : statusReply.getValue().getSliverInfo()) {
                if (sliverInfo.getAllocationStatus().equalsIgnoreCase("geni_allocated")) {
                    needToWait = true;
                }
                if (!sliverInfo.getOperationalStatus().equalsIgnoreCase("geni_pending_allocation")) continue;
                needToWait = true;
            }
        }
    }

    @Override
    public AggregateManagerWrapper.ProvisionReply provision(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable List<UserSpec> users, @Nullable Date requestedExpirationDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyProvision = this.internalProvision(sliceUrn, sliceCredentials, users, requestedExpirationDate);
        this.internalAssureExpireDate(replyProvision, sliceUrn, sliceCredentials, requestedExpirationDate);
        if (replyProvision.getValue() == null) {
            throw new JFedException("Error processing Provision reply");
        }
        return new AggregateManagerWrapper.ProvisionReply(replyProvision.getValue().getRspec(), replyProvision.getValue().getSliverInfo());
    }

    private AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> internalProvision(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable List<UserSpec> users, @Nullable Date requestedExpirationDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyProvision;
        String endTime = requestedExpirationDate == null ? null : RFC3339Util.dateToRFC3339String(requestedExpirationDate, true, true, true);
        List<String> urns = Collections.singletonList(sliceUrn.getValue());
        this.lastAmReply = replyProvision = this.am3.provision(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), "geni", "3", null, endTime, users, this.addCredentialExtraOptions(null));
        if (!replyProvision.getGeniResponseCode().isSuccess()) {
            if (AbstractGeniAggregateManager.isCommonError(replyProvision, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES)) {
                throw new AggregateManagerWrapper.NotEnoughFreeResourcesException(replyProvision);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyProvision, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED)) {
                throw new AggregateManagerWrapper.TermsAndConditionsException(replyProvision);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyProvision, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM)) {
                throw new AggregateManagerWrapper.ReservationProblemException(replyProvision);
            }
            if (StitchingDirector.isAnyNotSupported(replyProvision)) {
                throw new AggregateManagerWrapper.AnyVlanUnsupportedException(replyProvision);
            }
            if (StitchingDirector.isUnavailableVlan(replyProvision)) {
                throw new AggregateManagerWrapper.VlanUnavailableException(StitchingDirector.getUnavailableVlan(replyProvision), replyProvision);
            }
            throw new JFedException("Provision Call not successful", replyProvision);
        }
        return replyProvision;
    }

    private void internalAssureExpireDate(@Nonnull AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.AllocateAndProvisionInfo> replyProvision, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable Date requestedExpirationDate) {
        if (requestedExpirationDate != null && replyProvision.getGeniResponseCode().isSuccess() && replyProvision.getValue() != null && replyProvision.getValue().getSliverInfo() != null && !replyProvision.getValue().getSliverInfo().isEmpty()) {
            block7: {
                try {
                    Date actualExpiresDate = replyProvision.getValue().getSliverInfo().get(0).getExpiresDate();
                    if (!actualExpiresDate.after(requestedExpirationDate)) break block7;
                    LOG.info("We requested a geni_end_time in the Provision call, but the AMv3 AM returned a later date! To try fix this, we execute a Renew.");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.renewSlivers(sliceUrn, null, this.finalizeSliceCredentials(sliceCredentials), requestedExpirationDate);
                    }
                    catch (JFedException ex) {
                        LOG.error("Error when trying to define expiration date for newly created sliver", ex);
                    }
                }
                catch (ParseException e) {
                    LOG.warn("Error parsing Provision reply geni_expires date '{}'", (Object)replyProvision.getValue().getSliverInfo().get(0).getExpires());
                }
            }
            this.lastAmReply = replyProvision;
        }
    }

    @Override
    public void poaStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        List<String> urns = Collections.singletonList(sliceUrn.getValue());
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> replyPerfOpAction = this.am3.performOperationalAction(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), "geni_start", null, this.addCredentialExtraOptions(null));
        if (!replyPerfOpAction.getGeniResponseCode().isSuccess()) {
            if (AbstractGeniAggregateManager.isCommonError(replyPerfOpAction, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES)) {
                throw new AggregateManagerWrapper.NotEnoughFreeResourcesException(replyPerfOpAction);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyPerfOpAction, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED)) {
                throw new AggregateManagerWrapper.TermsAndConditionsException(replyPerfOpAction);
            }
            if (AbstractGeniAggregateManager.isCommonError(replyPerfOpAction, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM)) {
                throw new AggregateManagerWrapper.ReservationProblemException(replyPerfOpAction);
            }
            throw new JFedException("PerformOperationAction Call not successful", replyPerfOpAction);
        }
    }

    @Override
    public String createSliver(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, @Nullable List<UserSpec> users, @Nullable Date requestedExpirationDate) throws JFedException {
        this.allocate(sliceUrn, (List)sliceCredentials, rspec, requestedExpirationDate);
        return this.provisionAndStart(sliceUrn, sliceCredentials, users, requestedExpirationDate);
    }

    @Override
    public void deleteSliver(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        List<String> urns = Collections.singletonList(sliceUrn.getValue());
        this.lastAmReply = reply = this.am3.delete(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), null, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                return;
            }
            throw new JFedException("Delete Call not successful", reply);
        }
    }

    @Override
    @Nullable
    public StatusDetails status(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AggregateManager3.StatusInfo statusInfo = this.status_v3(sliceUrn, sliceCredentials);
        if (statusInfo == null) {
            return new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED);
        }
        if (statusInfo.getSliverInfo().isEmpty()) {
            return new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED);
        }
        StatusDetails res = null;
        for (AggregateManager3.SliverInfo sliverInfo : statusInfo.getSliverInfo()) {
            StatusDetails.SliverStatus s2 = AMv3Wrapper.getGlobalSliverStatus(sliverInfo);
            StatusDetails sliverStatusDetails = new StatusDetails(s2, GeniUrn.parse(sliverInfo.getSliverUrn()));
            if (res != null) {
                res.add(sliverStatusDetails);
            } else {
                res = sliverStatusDetails;
            }
            if (sliverInfo.getExpires() != null) {
                try {
                    res.addKnownExpires(sliverInfo.getExpiresDate());
                }
                catch (ParseException e) {
                    LOG.debug("Error parsing date in sliver_info {}", (Object)sliverInfo.getExpires(), (Object)e);
                }
            }
            if (sliverInfo.getError() == null || sliverInfo.getError().isEmpty()) continue;
            res.addError(new ErrorDetails(sliverInfo.getError(), sliverInfo.getSliverUrn()));
        }
        return res;
    }

    @Override
    @Nullable
    public AggregateManager3.StatusInfo status_v3(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo> reply;
        LOG.debug("Calling AMv3Wrapper status with {} credentials", (Object)sliceCredentials.size());
        ArrayList<String> urns = new ArrayList<String>();
        urns.add(sliceUrn.getValue());
        this.lastAmReply = reply = this.am3.status(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), null, this.addCredentialExtraOptions(null));
        if (reply.getGeniResponseCode() == GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED) {
            return null;
        }
        AggregateManager3.StatusInfo status = reply.getValue();
        if (!reply.getGeniResponseCode().isSuccess() || status == null) {
            throw new JFedException("Status Call not successful", reply);
        }
        return status;
    }

    @Override
    public String describe(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo> reply;
        ArrayList<String> urns = new ArrayList<String>();
        urns.add(sliceUrn.getValue());
        String type = "geni";
        String version = "3";
        if (this.amServer != null && this.amServer.isServerType("FOAM")) {
            type = "GENI";
        }
        this.lastAmReply = reply = this.am3.describe(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), type, "3", true, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (reply.getGeniResponseCode() == GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED) {
                throw new JFedException("No such slice found", reply);
            }
            throw new JFedException("Describe Call not successful", reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Error processing Describe reply");
        }
        return reply.getValue().getManifestRspec();
    }

    @Override
    public List<GeniUrn> renewSlivers(@Nullable GeniUrn sliceUrn, @Nullable List<GeniUrn> sliverUrns, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpire) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        List<String> urns;
        if (sliceUrn == null && (sliverUrns == null || sliverUrns.isEmpty())) {
            throw new IllegalArgumentException("renewSlivers was called with both sliceUrn == null and sliverUrn empty or null (sliverUrns=" + sliverUrns + ")");
        }
        if (sliceUrn != null) {
            urns = Collections.singletonList(sliceUrn.getValue());
            if (sliverUrns != null && !sliverUrns.isEmpty()) {
                throw new IllegalArgumentException("Either the sliceUrn or the sliverUrns may be defined, not both");
            }
        } else {
            urns = sliverUrns.stream().map(ResourceUrn::getValue).collect(Collectors.toList());
        }
        this.lastAmReply = reply = this.am3.renew(this.getConnection(), urns, this.finalizeSliceCredentials(sliceCredentials), newExpire, null, this.addCredentialExtraOptions(null));
        if (reply.getGeniResponseCode().getCode() == GeniAMResponseCode.GENIRESPONSE_REFUSED.getCode()) {
            throw new RenewRefusedException("Renew Call Refused: " + reply.getOutput(), reply);
        }
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Renew Call not successful", reply);
        }
        ArrayList<GeniUrn> updatedSliverUrns = new ArrayList<GeniUrn>();
        if (reply.getValue() != null) {
            for (AggregateManager3.SliverInfo si : reply.getValue()) {
                GeniUrn u = GeniUrn.parse(si.getSliverUrn());
                if (u != null) {
                    updatedSliverUrns.add(u);
                    continue;
                }
                LOG.warn("AMv3Wapper.renewSlivers() got sliver info with bad urn: " + si.getSliverUrn() + " -> will be paranoid and return null (which means \"I don't know\" in this case')");
                return null;
            }
        }
        return updatedSliverUrns;
    }

    @Override
    public boolean isExirationdateSetByCreateSliver() {
        return true;
    }

    @Override
    public boolean isShareLanSupported() {
        assert (this.amServer != null);
        return this.amServer.hasFlag(Server.Flag.featurePoaShareLan);
    }

    @Override
    public void shareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String newSharedLanName) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        HashMap<String, Object> extraOptions = new HashMap<String, Object>();
        extraOptions.put("geni_sharelan_lanname", lanClientId);
        extraOptions.put("geni_sharelan_token", newSharedLanName);
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliceUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_sharelan", false, this.addCredentialExtraOptionsToMap(extraOptions));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Share lan command failed: " + reply.getOutput(), reply);
        }
    }

    @Override
    public void unshareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String sharedLanName) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        HashMap<String, Object> extraOptions = new HashMap<String, Object>();
        extraOptions.put("geni_sharelan_lanname", lanClientId);
        extraOptions.put("geni_sharelan_token", sharedLanName);
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliceUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_unsharelan", false, this.addCredentialExtraOptionsToMap(extraOptions));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Unshare lan command failed: " + reply.getOutput(), reply);
        }
    }

    @Override
    public boolean isRestartSupported() {
        assert (this.amServer != null);
        return !this.amServer.isServerType("planetlab");
    }

    @Override
    public boolean isReloadOSSupported() {
        assert (this.amServer != null);
        return !this.amServer.isServerType("planetlab");
    }

    @Override
    public boolean isOpenConsoleSupported() {
        assert (this.amServer != null);
        return !this.amServer.isServerType("planetlab");
    }

    @Override
    public void restart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliceUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_restart", false, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Restart node command failed: " + reply.getOutput(), reply);
        }
    }

    @Override
    public void reloadOS(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliceUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_reload", false, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Reload OS on node command failed: " + reply.getOutput(), reply);
        }
    }

    @Override
    public URL openConsole(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliverUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_console_url", false, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Get Console URL on node command failed: " + reply.getOutput(), reply);
        }
        Object val = reply.getRawValue();
        if (val instanceof String) {
            try {
                return new URL((String)val);
            }
            catch (MalformedURLException e) {
                throw new JFedException("POA geni_console_url returned invalid URL: '" + val + "'", e);
            }
        }
        throw new JFedException("POA geni_console_url returned invalid URL: '" + val + "'", reply);
    }

    @Override
    public boolean isEditSshKeysSupported() {
        return true;
    }

    @Override
    public void editSshKeys(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Collection<UserSpec> userSpecs) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<List<AggregateManager3.SliverInfo>> reply;
        HashMap<String, Object> extraOptions = new HashMap<String, Object>();
        extraOptions.put("geni_users", userSpecs.stream().map(UserSpec::getAsMap).collect(Collectors.toList()));
        this.lastAmReply = reply = this.am3.performOperationalAction(this.getConnection(), Collections.singletonList(sliceUrn.getValue()), this.finalizeSliceCredentials(sliceCredentials), "geni_update_users", false, this.addCredentialExtraOptionsToMap(extraOptions));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Edit SSH keys command failed: " + reply.getOutput(), reply);
        }
    }

    @Override
    public boolean areUserDiskImageFunctionsSupported() {
        return false;
    }

    @Override
    public void setSpeaksFor(@Nullable List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        if (speakingForUrn != null) {
            this.setExtraOptionsForCallsWithCredential(Collections.singletonMap("geni_speaking_for", speakingForUrn.getValue()));
        } else {
            this.setExtraOptionsForCallsWithCredential(null);
        }
    }

    public static class AllocateReplyAmv3
    implements AggregateManagerWrapper.AllocateReply {
        private final String manifest;
        @Nullable
        private final List<GeniUrn> sliverUrns;

        private AllocateReplyAmv3(@Nullable List<AggregateManager3.SliverInfo> sliverInfos, String manifest) {
            this.manifest = manifest;
            if (sliverInfos != null) {
                this.sliverUrns = new ArrayList<GeniUrn>();
                for (AggregateManager3.SliverInfo si : sliverInfos) {
                    try {
                        GeniUrn sliverUrn = new GeniUrn(si.getSliverUrn());
                        this.sliverUrns.add(sliverUrn);
                    }
                    catch (GeniUrn.GeniUrnParseException e) {
                        LOG.error("Could not parse GeniUrn in AMv3 Allocate reply", e);
                    }
                }
            } else {
                this.sliverUrns = null;
            }
        }

        @Override
        public String getManifest() {
            return this.manifest;
        }

        @Override
        @Nullable
        public List<GeniUrn> getSliverUrns() {
            return this.sliverUrns;
        }
    }

    public static class RenewRefusedException
    extends JFedException {
        public RenewRefusedException(@Nonnull String s2, @Nonnull XmlRpcApiCallReply<?> reply) {
            super(s2, reply);
        }
    }
}

