/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority.finder;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorityFinder.class);
    private final TestbedInfoSource model;
    private final JFedPreferences jFedPreferences;

    @Inject
    public AuthorityFinder(TestbedInfoSource model, JFedPreferences jFedPreferences) {
        this.model = model;
        this.jFedPreferences = jFedPreferences;
    }

    public int size() {
        return this.model.getServers().size();
    }

    @Nullable
    public Server findByAnyUrn(@Nonnull String urnString, @Nonnull Purpose purpose) {
        return this.findByUrn(urnString, purpose, true);
    }

    @Nullable
    public Server findByUrn(@Nonnull String urnString, @Nonnull Purpose purpose) {
        return this.findByUrn(urnString, purpose, false);
    }

    @Nullable
    public Server findByUrn(@Nonnull String urnString, @Nonnull Purpose purpose, boolean ignoreTypeAndName) {
        GeniUrn u = GeniUrn.parse(urnString);
        if (u == null) {
            LOG.warn("Tried to lookup Server using the invalid URN \"" + urnString + "\" -> solving problem by returning null");
            return null;
        }
        return this.findByUrn(u, purpose, ignoreTypeAndName);
    }

    public Server findByUrn(@Nonnull GeniUrn urn, @Nonnull Purpose purpose) {
        return this.findByUrn(urn, purpose, false);
    }

    public Server findByAnyUrn(@Nonnull GeniUrn urn, @Nonnull Purpose purpose) {
        return this.findByUrn(urn, purpose, true);
    }

    public Server findByUrn(@Nonnull GeniUrn urn, @Nonnull Purpose purpose, boolean ignoreTypeAndName) {
        TestbedInfoSource.SubAuthMatchPreference preferred;
        TestbedInfoSource.SubAuthMatchAllowed allowed;
        block18: {
            block17: {
                CentralBrokerArchitectureChoice centralBrokerArchitectureChoice;
                String prefenceForceExoSM = this.jFedPreferences.getString(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM).trim().toLowerCase();
                String prefenceRecoverExoSM = this.jFedPreferences.getString(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD).trim().toLowerCase();
                switch (purpose) {
                    case STITCHING: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY;
                        centralBrokerArchitectureChoice = null;
                        break;
                    }
                    case RECOVER: {
                        if (!prefenceRecoverExoSM.equalsIgnoreCase("single")) {
                            LOG.warn("Expected " + CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD + " to be \"single\", but it is \"" + prefenceRecoverExoSM + "\"");
                        }
                    }
                    case CREATE_SLIVER: 
                    case DELETE: 
                    case STATUS: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL;
                        if (Objects.equals(prefenceForceExoSM, "auto")) {
                            centralBrokerArchitectureChoice = CentralBrokerArchitectureChoice.USE_GLOBAL_SETTING;
                            break;
                        }
                        centralBrokerArchitectureChoice = Objects.equals(prefenceForceExoSM, "yes") ? CentralBrokerArchitectureChoice.FORCE_TOP : CentralBrokerArchitectureChoice.FORCE_SUBAUTH;
                        break;
                    }
                    case RECOVER_BOTH_FIRST: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL;
                        centralBrokerArchitectureChoice = CentralBrokerArchitectureChoice.FORCE_TOP;
                        break;
                    }
                    case RECOVER_BOTH_SECOND: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL;
                        centralBrokerArchitectureChoice = CentralBrokerArchitectureChoice.FORCE_SUBAUTH;
                        break;
                    }
                    case REQUEST_RSPEC: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY;
                        centralBrokerArchitectureChoice = CentralBrokerArchitectureChoice.FORCE_SUBAUTH;
                        break;
                    }
                    case FIND_USERAUTH: {
                        allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL;
                        centralBrokerArchitectureChoice = null;
                        break;
                    }
                    default: {
                        throw new RuntimeException("BUG: Unimplemented functionality for " + purpose);
                    }
                }
                if (this.isSubAuthHandlingServer(urn)) {
                    allowed = TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL;
                }
                if (centralBrokerArchitectureChoice == null || !this.isCentralBrokerArchitecture(urn)) break block17;
                switch (centralBrokerArchitectureChoice) {
                    case FORCE_TOP: {
                        preferred = TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL;
                        break block18;
                    }
                    case FORCE_SUBAUTH: {
                        preferred = TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY;
                        break block18;
                    }
                    case USE_GLOBAL_SETTING: {
                        Server centralBrokerAuth = this.model.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
                        preferred = centralBrokerAuth != null && centralBrokerAuth.hasFlag(Server.Flag.preferToplevelOverSubauthority) ? TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL : TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY;
                        break block18;
                    }
                    default: {
                        throw new RuntimeException("Unsupported centralBrokerArchitectureChoice=" + centralBrokerArchitectureChoice);
                    }
                }
            }
            preferred = TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY;
        }
        return this.model.getByUrn(urn, allowed, preferred, ignoreTypeAndName);
    }

    public boolean isCentralBrokerArchitecture(@Nonnull GeniUrn urn) {
        Server aMatch = this.model.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL, true);
        return aMatch != null && (aMatch.hasFlag(Server.Flag.centralBrokerArchitectureBrokerauth) || aMatch.hasFlag(Server.Flag.centralBrokerArchitectureSubauth));
    }

    public boolean isSubAuthHandlingServer(@Nonnull GeniUrn urn) {
        Server aMatch = this.model.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL, true);
        return aMatch != null && aMatch.hasFlag(Server.Flag.featureHandlesAllSubAuthorities);
    }

    public static enum Purpose {
        CREATE_SLIVER,
        STITCHING,
        STATUS,
        DELETE,
        RECOVER,
        RECOVER_BOTH_FIRST,
        RECOVER_BOTH_SECOND,
        REQUEST_RSPEC,
        FIND_USERAUTH;

    }

    private static enum CentralBrokerArchitectureChoice {
        FORCE_TOP,
        FORCE_SUBAUTH,
        USE_GLOBAL_SETTING;

    }
}

