/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority.legacy;

import be.iminds.ilabt.jfed.lowlevel.authority.binding.Authorities;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacyAuthorityListModel;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacySfaAuthority;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyStoredAuthorityList {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyStoredAuthorityList.class);

    public static LoadResult load(String content, LegacyAuthorityListModel authorityListModel) {
        try {
            ByteArrayInputStream sis = new ByteArrayInputStream(content.getBytes("UTF-8"));
            return LegacyStoredAuthorityList.load(sis, authorityListModel);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("UnsupportedEncodingException", e);
            return new LoadResult(false);
        }
    }

    public static LoadResult load(File file, LegacyAuthorityListModel authorityListModel) {
        if (!file.exists()) {
            return new LoadResult(false);
        }
        try {
            return LegacyStoredAuthorityList.load(new FileInputStream(file), authorityListModel);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Error reading authorities from XML file \"" + file + "\": ", e);
            return new LoadResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadResult load(InputStream is, LegacyAuthorityListModel authorityListModel) {
        ArrayList<String> extraFiles = new ArrayList<String>();
        try {
            Class<Authorities> docClass = Authorities.class;
            String packageName = docClass.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance(packageName);
            Unmarshaller u = jc.createUnmarshaller();
            Authorities c = (Authorities)u.unmarshal(is);
            ArrayList<Object> authorities = new ArrayList<Object>();
            for (Authorities.Authority xmlAuthority : c.getAuthority()) {
                LegacySfaAuthority sfaAuthority = LegacySfaAuthority.fromXml(xmlAuthority);
                if (sfaAuthority == null) continue;
                LegacySfaAuthority existingSfaAuthority = authorityListModel.getByUrnExact(sfaAuthority.getUrnString());
                if (existingSfaAuthority == null) {
                    authorityListModel.addAuthority(sfaAuthority);
                    authorities.add(sfaAuthority);
                    continue;
                }
                boolean replace = false;
                if (existingSfaAuthority.isWasStored()) {
                    replace = true;
                }
                if (existingSfaAuthority.getSource() != null) {
                    switch (existingSfaAuthority.getSource()) {
                        case BUILTIN: {
                            replace = true;
                            break;
                        }
                        case USER_PROVIDED: {
                            break;
                        }
                    }
                }
                if (replace) {
                    authorityListModel.removeByUrn(sfaAuthority.getUrnString());
                    authorityListModel.addAuthority(sfaAuthority);
                    authorities.add(sfaAuthority);
                    continue;
                }
                authorities.add(authorityListModel.mergeOrAdd(sfaAuthority));
            }
            for (Authorities.Type authorityType : c.getType()) {
                if (authorityType.getName() == null || authorityType.getName().trim().isEmpty()) continue;
                for (String specialId : authorityType.getSpecial()) {
                    try {
                        if (specialId == null || specialId.trim().isEmpty()) continue;
                        LegacySfaAuthority.SpecialCase specialCase = LegacySfaAuthority.SpecialCase.fromString(specialId.trim());
                        authorities.stream().filter(auth -> auth.getType() != null && auth.getType().equalsIgnoreCase(authorityType.getName())).forEach(auth -> auth.setSpecialCase(specialCase, true));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Parsed authority XML contained unknown <special> option: \"" + specialId + "\"");
                    }
                }
            }
            int curVersion = 1;
            for (Authorities.ExtraFile extraFile : c.getExtraFile()) {
                if (extraFile.getMinVersion().intValue() <= curVersion) {
                    extraFiles.add(extraFile.getUrl());
                    continue;
                }
                LOG.debug("Ignoring extrafile for version " + extraFile.getMinVersion());
            }
        }
        catch (Exception e) {
            LOG.warn("Error reading authorities from XML: ", e);
            LoadResult loadResult = new LoadResult(false);
            return loadResult;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return new LoadResult(true, extraFiles);
    }

    public static void save(File file, LegacyAuthorityListModel authorityListModel) {
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!dir.exists()) {
                LOG.warn("could not save authorities to \"" + file.getName() + "\", as dir \"" + dir.getName() + "\" could not be created.");
                return;
            }
            FileWriter writer = new FileWriter(file);
            LegacyStoredAuthorityList.toXml(writer, authorityListModel.getAuthorities(), false, false);
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("Error writing authorities to XML file \"" + file.getName() + "\": ", e);
        }
    }

    public static String toXml(LegacyAuthorityListModel authorityListModel) {
        return LegacyStoredAuthorityList.toXml(authorityListModel.getAuthorities(), false, false);
    }

    public static String toXml(List<LegacySfaAuthority> authorityList, boolean omitDeclaration, boolean noNamespace) {
        try {
            StringWriter stringWriter = new StringWriter();
            LegacyStoredAuthorityList.toXml(stringWriter, authorityList, omitDeclaration, noNamespace);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            LOG.warn("WARNING: Error writing authorities to XML: ", e);
            return null;
        }
    }

    public static void toXml(Writer outputWriter, List<LegacySfaAuthority> authorityList, boolean omitDeclaration, boolean noNamespace) {
        try {
            Authorities xmlAuthorities = new Authorities();
            for (LegacySfaAuthority auth : authorityList) {
                Authorities.Authority xmlAuth = auth.toXml();
                xmlAuthorities.getAuthority().add(xmlAuth);
            }
            JAXBContext context = JAXBContext.newInstance(Authorities.class);
            Marshaller m3 = context.createMarshaller();
            if (omitDeclaration) {
                m3.setProperty("jaxb.fragment", Boolean.TRUE);
            }
            m3.setProperty("jaxb.formatted.output", Boolean.TRUE);
            m3.marshal((Object)xmlAuthorities, outputWriter);
        }
        catch (JAXBException e) {
            LOG.warn("WARNING: Error writing authorities: ", e);
        }
    }

    public static class LoadResult {
        private final boolean success;
        private final List<String> extraFiles;

        public LoadResult(boolean success, List<String> extraFiles) {
            this.success = success;
            this.extraFiles = extraFiles;
        }

        public LoadResult(boolean success) {
            this(success, Collections.emptyList());
        }

        public boolean isSuccess() {
            return this.success;
        }

        public List<String> getExtraFiles() {
            return this.extraFiles;
        }
    }
}

