/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection_pool;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniAMExtensions;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HandleUntrustedCallback;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.debug_info.DebugInfoFactory;
import be.iminds.ilabt.jfed.util.lib.JFedPasswordManager;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfaConnectionPool
implements JFedConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SfaConnectionPool.class);
    private final Map<ConnectionSpecification, JFedConnection> conPool = Collections.synchronizedMap(new HashMap());
    private final JFedTrustStore baseTrustStore;
    private final JFedPreferences jFedPreferences;
    private final ConnectionBuilderFactory connectionBuilderFactory;
    private final JFedPasswordManager passwordManager;
    private final long firstDate = System.currentTimeMillis();
    private JFedConnection.ProxyInfo defaultProxy = null;
    private long lastThreadCpuDump = 0L;
    private final Map<Long, Long> prev_thread_cpuNs_sinceStart_ByThreadId = new HashMap<Long, Long>();
    private long prevCpuNsSinceStart = 0L;
    private long prevDate = System.currentTimeMillis();
    private boolean debugCpuUsage = false;

    @Inject
    public SfaConnectionPool(JFedTrustStore baseTrustStore, JFedPreferences jFedPreferences, ConnectionBuilderFactory connectionBuilderFactory, JFedPasswordManager passwordManager) {
        this.baseTrustStore = baseTrustStore;
        this.jFedPreferences = jFedPreferences;
        this.connectionBuilderFactory = connectionBuilderFactory;
        this.passwordManager = passwordManager;
        this.startAutoExpire();
        if (baseTrustStore == null) {
            throw new NullPointerException("got null baseTrustStore: cannot create SfaConnectionPool");
        }
        if (jFedPreferences.hasKey(CorePreferenceKey.PREF_DEBUG_CPU)) {
            this.setDebugCpuUsage(jFedPreferences.getBoolean(CorePreferenceKey.PREF_DEBUG_CPU));
            jFedPreferences.addPreferenceChangeListener(CorePreferenceKey.PREF_DEBUG_CPU, () -> this.setDebugCpuUsage(jFedPreferences.getBoolean(CorePreferenceKey.PREF_DEBUG_CPU)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<ConnectionSpecification, JFedConnection> map = this.conPool;
        synchronized (map) {
            return this.conPool.size();
        }
    }

    public JFedConnection.ProxyInfo getDefaultProxy() {
        return this.defaultProxy;
    }

    public void setDefaultProxy(JFedConnection.ProxyInfo defaultProxy) {
        this.defaultProxy = defaultProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<ConnectionSpecification, JFedConnection> map = this.conPool;
        synchronized (map) {
            this.conPool.clear();
        }
    }

    private LoginInfo getSimpleLogin(ApiInfo.ApiName api, GeniUser user) {
        String serviceName;
        List<LoginInfo> logins = this.passwordManager.getLoginsAndRequestIfNone(serviceName, switch (api) {
            case ApiInfo.ApiName.FED4FIRE_SLA_COLLECTOR -> {
                serviceName = "sla";
                yield "SLA Collector";
            }
            default -> throw new RuntimeException("Login retrieval not implemented for service " + api);
        }, this.jFedPreferences, user);
        if (logins.isEmpty()) {
            return null;
        }
        return logins.get(0);
    }

    @Override
    public JFedConnection getConnectionByAuthority(@Nullable GeniUser user, @Nonnull Server server, @Nonnull Class targetClass) throws JFedException {
        return this.getConnectionByAuthority(user, server, targetClass, false);
    }

    public JFedConnection getConnectionByAuthority(@Nullable GeniUser user, @Nonnull Server server, @Nonnull Class targetClass, boolean disableClientAuthentication) throws JFedException {
        ApiInfo.Api api = ApiInfo.classToApi(targetClass);
        if (api != null) {
            return this.getConnectionByAuthority(user, server, api, disableClientAuthentication);
        }
        if (Objects.equals(targetClass, ProtoGeniAMExtensions.class)) {
            JFedConnection con = this.getConnectionByAuthority(user, server, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), disableClientAuthentication);
            if (con != null) {
                return con;
            }
            return this.getConnectionByAuthority(user, server, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3), disableClientAuthentication);
        }
        throw new JFedException("Cannot get connection for " + targetClass.getName());
    }

    public JFedConnection getConnectionByUserAuthority(@Nonnull GeniUser user, @Nonnull ApiInfo.Api api) throws JFedException {
        return this.getConnectionByUserAuthority(user, api, false);
    }

    public JFedConnection getConnectionByUserAuthority(@Nonnull GeniUser user, @Nonnull ApiInfo.Api api, boolean disableClientAuthentication) throws JFedException {
        assert (user.getUserAuthorityServer() != null) : "getConnectionByUserAuthority requires that the user's authority is known";
        Server server = user.getUserAuthorityServer();
        assert (server != null);
        return this.getConnectionByAuthority(user, server, api, disableClientAuthentication);
    }

    @Override
    public JFedConnection getConnectionByUrl(JFedTrustStore overrideTrustStore, GeniUser user, URL serverUrl, HandleUntrustedCallback handleUntrustedCallback, ApiInfo.Api api, Service serviceForDebugInfo, List<String> overrideAllowedServerCertificateAlias) throws JFedException {
        return this.getConnectionByUrl(overrideTrustStore, user, serverUrl, handleUntrustedCallback, api, false, false, null, serviceForDebugInfo, overrideAllowedServerCertificateAlias);
    }

    public JFedConnection getConnectionByUrl(JFedTrustStore overrideTrustStore, GeniUser user, URL serverUrl, HandleUntrustedCallback handleUntrustedCallback, ApiInfo.Api api, boolean disableClientAuthentication, Service serviceForDebugInfo, List<String> overrideAllowedServerCertificateAlias) throws JFedException {
        return this.getConnectionByUrl(overrideTrustStore, user, serverUrl, handleUntrustedCallback, api, disableClientAuthentication, false, null, serviceForDebugInfo, overrideAllowedServerCertificateAlias);
    }

    public JFedConnection getConnectionByUrl(JFedTrustStore overrideTrustStore, GeniUser user, URL serverUrl, HandleUntrustedCallback handleUntrustedCallback, ApiInfo.Api api, boolean disableClientAuthentication, boolean overrideProxy, JFedConnection.ProxyInfo overrideProxyInfo, Service serviceForDebugInfo, List<String> overrideAllowedServerCertificateAlias) throws JFedException {
        assert (api != null);
        JFedTrustStore conTrustStore = overrideTrustStore == null ? this.baseTrustStore : overrideTrustStore;
        JFedConnection.ProxyInfo usedProxyInfo = overrideProxy ? overrideProxyInfo : this.defaultProxy;
        if (serverUrl == null) {
            throw new RuntimeException("getConnectionByUrl: serverUrl null for api: " + api);
        }
        ConnectionBuilder connectionBuilder = this.connectionBuilderFactory.createConnectionBuilder();
        connectionBuilder.setUrl(serverUrl);
        connectionBuilder.setDebugInfo(DebugInfoFactory.createFromService(user, serviceForDebugInfo));
        connectionBuilder.setProxy(usedProxyInfo, false);
        connectionBuilder.setHackOverrideAllowedServerCertificateAlias(overrideAllowedServerCertificateAlias);
        switch (api.getName().getAuthentication()) {
            case NONE: {
                connectionBuilder.useNoAuthentication();
                break;
            }
            case HTTP_BASIC: {
                LoginInfo login = this.getSimpleLogin(api.getName(), user);
                if (login == null) {
                    LOG.error("Failed to get login info, will not create connection.");
                    return null;
                }
                connectionBuilder.useHttpBasicAuthentication(login);
                break;
            }
            case SSL_CLIENT_AUTH: {
                assert (user != null) : "HTTPS connections require that a user is logged in";
                connectionBuilder.useSslClientAuthentication(user.getClientCertificateChain(), user.getPrivateKey());
                break;
            }
            default: {
                throw new RuntimeException("Unhandled Authentication: " + api.getName().getAuthentication());
            }
        }
        if (Objects.equals(serverUrl.getProtocol(), "https")) {
            connectionBuilder.useHttps(conTrustStore, handleUntrustedCallback);
        } else {
            connectionBuilder.useHttp();
            if (api.getName().getAuthentication() == ConnectionConfig.Authentication.SSL_CLIENT_AUTH) {
                LOG.warn("This API (" + api + ") normally uses SSL CLIENT AUTHENTICATION. However, the server URL uses HTTP instead of HTTPS. Because of this, SSL client authentication cannot be used and will be DISABLED.");
                connectionBuilder.useNoAuthentication();
            }
        }
        JFedConnection con = switch (api.getName().getConnectionType()) {
            case ConnectionConfig.Type.HTTP -> connectionBuilder.buildHttpConnection();
            case ConnectionConfig.Type.SFA -> connectionBuilder.buildSfaConnection();
            default -> throw new RuntimeException("Unhandled Connection Type: " + api.getName().getConnectionType());
        };
        assert (con != null);
        return con;
    }

    @Override
    public JFedConnection getConnectionByAuthority(GeniUser user, @Nonnull Server server, @Nonnull ApiInfo.Api api) throws JFedException {
        return this.getConnectionByAuthority(user, server, api, false, false, null);
    }

    public JFedConnection getConnectionByAuthority(GeniUser user, Server server, ApiInfo.Api api, boolean disableClientAuthentication) throws JFedException {
        return this.getConnectionByAuthority(user, server, api, disableClientAuthentication, false, null);
    }

    public JFedConnection getConnectionByAuthority(GeniUser user, Server server, ApiInfo.Api api, boolean disableClientAuthentication, JFedConnection.ProxyInfo overwriteProxyInfo) throws JFedException {
        return this.getConnectionByAuthority(user, server, api, disableClientAuthentication, true, overwriteProxyInfo);
    }

    public JFedConnection getConnectionByAuthority(GeniUser user, @Nonnull Server server, @Nonnull ApiInfo.Api api, boolean disableClientAuthentication, boolean overrideProxy, JFedConnection.ProxyInfo overwriteProxyInfo) throws JFedException {
        JFedConnection.ProxyInfo usedProxyInfo;
        JFedConnection.ProxyInfo proxyInfo = usedProxyInfo = overrideProxy ? overwriteProxyInfo : this.defaultProxy;
        if (server.getServices() == null || server.getServices().isEmpty()) {
            throw new JFedException("Server has no services: server ID: " + server.getId());
        }
        Service usedService = null;
        for (Service service : server.getServices()) {
            if (!api.matches(service)) continue;
            usedService = service;
        }
        if (usedService == null) {
            throw new JFedException("Server has no services for api '" + api.getId() + "' server ID: " + server.getId());
        }
        ConnectionSpecification conSpec = new ConnectionSpecification(user, server, usedService, disableClientAuthentication, usedProxyInfo);
        return this.getConnectionByConnectionSpecification(conSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFedConnection getConnectionByConnectionSpecification(@Nonnull ConnectionSpecification connectionSpecification) throws JFedException {
        JFedConnection con;
        GeniUser user = connectionSpecification.getUser();
        Server server = connectionSpecification.getServer();
        Service service = connectionSpecification.getService();
        boolean disableClientAuthentication = connectionSpecification.isDisableClientAuth();
        assert (server != null);
        assert (service != null);
        Map<ConnectionSpecification, JFedConnection> map = this.conPool;
        synchronized (map) {
            con = this.conPool.get(connectionSpecification);
        }
        if (con == null) {
            LOG.trace("No cached connection for " + connectionSpecification);
        }
        if (con != null && (con.isError() || con.isExpired())) {
            LOG.debug("NOT reusing cached connection {} for {} due to error in connection.", (Object)con.getConnectionId(), (Object)connectionSpecification);
            map = this.conPool;
            synchronized (map) {
                this.conPool.remove(connectionSpecification);
            }
            try {
                con.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close error or expired connection. Will ignore.", e);
            }
            con = null;
        }
        if (con != null) {
            LOG.trace("Re-using cached connection {} for {}", (Object)con.getConnectionId(), (Object)connectionSpecification);
        }
        if (con == null) {
            URL serverUrl;
            try {
                serverUrl = new URL(service.getUrl());
            }
            catch (MalformedURLException e) {
                throw new JFedException("Service (id=" + service.getId() + ") has invalid URL: \"" + service.getUrl() + "\"", e);
            }
            JFedTrustStore conTrustStore = new JFedTrustStore(this.baseTrustStore);
            final ConnectionBuilder connectionBuilder = this.connectionBuilderFactory.createConnectionBuilder();
            int defaultConnectTimeout = this.jFedPreferences.getInt(CorePreferenceKey.PREF_SOCKET_CONNECT_TIMEOUT_MS, 10000);
            int defaultReadTimeout = this.jFedPreferences.getInt(CorePreferenceKey.PREF_SOCKET_READ_TIMEOUT_MS, 120000);
            int connectTimeout = defaultConnectTimeout;
            int readTimeout = defaultReadTimeout;
            if (server.hasFlag(Server.Flag.workaroundLongConnectTimeout)) {
                connectTimeout = 60000;
            }
            if (server.hasFlag(Server.Flag.workaroundInsanelyLongConnectTimeout)) {
                connectTimeout = 120000;
            }
            if (server.hasFlag(Server.Flag.workaroundLongReadTimeout)) {
                readTimeout = 360000;
            }
            if (server.hasFlag(Server.Flag.workaroundInsanelyLongReadTimeout)) {
                readTimeout = 900000;
            }
            if (defaultReadTimeout > readTimeout) {
                readTimeout = defaultReadTimeout;
            }
            if (defaultConnectTimeout > connectTimeout) {
                connectTimeout = defaultConnectTimeout;
            }
            connectionBuilder.setSocketConnectTimeoutMs(connectTimeout);
            connectionBuilder.setSocketReadTimeoutMs(readTimeout);
            connectionBuilder.setUrl(serverUrl);
            connectionBuilder.setDebugInfo(DebugInfoFactory.createFromService(user, connectionSpecification.getService()));
            connectionBuilder.setProxy(connectionSpecification.getProxyInfo(), false);
            ApiInfo.ApiName api = ApiInfo.findById(service.getApi());
            if (api == null) {
                throw new JFedException("API is now known: api: \"" + service.getApi() + "\"   service ID: " + service.getId() + "   server ID: " + server.getId());
            }
            switch (api.getAuthentication()) {
                case HTTP_BASIC: {
                    LoginInfo login = this.getSimpleLogin(api, user);
                    if (login == null) {
                        LOG.error("Failed to get login info, will not create connection.");
                        return null;
                    }
                    connectionBuilder.useHttpBasicAuthentication(login);
                    break;
                }
                case SSL_CLIENT_AUTH: {
                    if (!disableClientAuthentication) {
                        assert (user != null) : "HTTPS connections require that a user is logged in";
                        connectionBuilder.useSslClientAuthentication(user.getClientCertificateChain(), user.getPrivateKey());
                        break;
                    }
                }
                case NONE: {
                    connectionBuilder.useNoAuthentication();
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled Authentication: " + api.getAuthentication());
                }
            }
            if (Objects.equals(serverUrl.getProtocol(), "https")) {
                if (server.hasCertificateChain()) {
                    conTrustStore.addTrustedPemCertificateIfNotAddedAndValidPem(server.getCertificateChain());
                    if (server.hasAllowedCertificateAlias()) {
                        conTrustStore.addAllowedServerCertificateHostnameAlias(server.getAllowedCertificateAlias());
                        LOG.debug("Using SSL conTrustStore with cert and with alias \"" + server.getAllowedCertificateAlias() + "\" for server " + server.getName() + " (" + server.getId() + ")");
                    } else {
                        LOG.debug("Using SSL conTrustStore with cert but without alias for server " + server.getName() + " (" + server.getId() + ")");
                    }
                } else {
                    LOG.debug("Using SSL conTrustStore without cert or alias info for server " + server.getName() + " (" + server.getId() + ")");
                }
                if (user.getUserAuthorityServer() != null && user.getUserAuthorityServer().hasCertificateChain()) {
                    conTrustStore.addTrustedPemCertificateIfNotAddedAndValidPem(user.getUserAuthorityServer().getCertificateChain());
                    if (user.getUserAuthorityServer().hasAllowedCertificateAlias()) {
                        conTrustStore.addAllowedServerCertificateHostnameAlias(user.getUserAuthorityServer().getAllowedCertificateAlias());
                    }
                }
                connectionBuilder.useHttps(conTrustStore, null);
            } else {
                connectionBuilder.useHttp();
                if (api.getAuthentication() == ConnectionConfig.Authentication.SSL_CLIENT_AUTH) {
                    LOG.warn("This API (" + api + ") normally uses SSL CLIENT AUTHENTICATION. However, the server URL uses HTTP instead of HTTPS. Because of this, SSL client authentication cannot be used and will be DISABLED.");
                    connectionBuilder.useNoAuthentication();
                }
            }
            JFedConnection.JFedConnectionFactory conCopier = switch (api.getConnectionType()) {
                case ConnectionConfig.Type.HTTP -> new JFedConnection.JFedConnectionFactory(){

                    @Override
                    public JFedConnection create() throws JFedException {
                        HttpConnection res = connectionBuilder.buildHttpConnection();
                        assert (res != null);
                        res.setConnectionFactory(this);
                        return res;
                    }
                };
                case ConnectionConfig.Type.SFA -> new JFedConnection.JFedConnectionFactory(){

                    @Override
                    public JFedConnection create() throws JFedException {
                        SfaConnection res = connectionBuilder.buildSfaConnection();
                        assert (res != null);
                        res.setConnectionFactory(this);
                        return res;
                    }
                };
                default -> throw new RuntimeException("Unhandled Connection Type: " + api.getConnectionType());
            };
            con = conCopier.create();
            LOG.trace("Created a new connection {} for {}", (Object)con.getConnectionId(), (Object)connectionSpecification);
            con.setConnectionFactory(conCopier);
            assert (con.canDuplicate());
            if (!server.hasFlag(Server.Flag.workaroundMustReconnectEachCall)) {
                Map<ConnectionSpecification, JFedConnection> map2 = this.conPool;
                synchronized (map2) {
                    this.conPool.put(connectionSpecification, con);
                }
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ConnectionSpecification, JFedConnection> map = this.conPool;
        synchronized (map) {
            for (JFedConnection conn : this.conPool.values()) {
                LOG.debug("Closing connection to {}", (Object)conn.getServerUrl());
                conn.close();
            }
            this.conPool.clear();
        }
        LOG.debug("Cleared connection pool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpired() {
        int connectionsCleared = 0;
        Map<ConnectionSpecification, JFedConnection> map = this.conPool;
        synchronized (map) {
            Iterator<Map.Entry<ConnectionSpecification, JFedConnection>> it = this.conPool.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ConnectionSpecification, JFedConnection> entry = it.next();
                JFedConnection con = entry.getValue();
                if (!con.isExpired()) continue;
                LOG.debug("Closing expired connection to {}. inUse={} lastUse={} ms ago", con.getServerUrl(), con.isInUse(), System.currentTimeMillis() - con.getLastCallTime().getTime());
                con.close();
                it.remove();
                ++connectionsCleared;
            }
        }
        int conCount = this.conPool.size();
        if (connectionsCleared > 0) {
            LOG.debug("Periodical check of expired connections in connection pool: Closed " + connectionsCleared + " (" + conCount + " remain open)");
        } else {
            LOG.debug("Periodical check of expired connections in connection pool: Did not find any. (" + conCount + " remain open)");
        }
        if (this.debugCpuUsage) {
            this.dumpCpuUsage();
        }
    }

    public void setDebugCpuUsage(boolean debugCpuUsage) {
        this.debugCpuUsage = debugCpuUsage;
    }

    public void dumpCpuUsage() {
        ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
        if (!tmxb.isThreadCpuTimeSupported()) {
            LOG.debug("Thread CPU measurements are not supported");
        } else {
            boolean dumpThreadCpuNow = System.currentTimeMillis() - this.lastThreadCpuDump > 60000L;
            StringBuilder logString = new StringBuilder();
            StringBuilder highCpulogString = new StringBuilder();
            long[] threadIDs = tmxb.getAllThreadIds();
            long cpuNsSinceStart = 0L;
            for (long threadID : threadIDs) {
                long cpuTime = tmxb.getThreadCpuTime(threadID);
                cpuNsSinceStart += cpuTime;
            }
            long curDate = System.currentTimeMillis();
            long realMsSincePrev = curDate - this.prevDate;
            long realMsSinceStart = curDate - this.firstDate;
            long cpuNsSincePrev = cpuNsSinceStart - this.prevCpuNsSinceStart;
            double cpuPercentOfReal_sinceStart = (double)cpuNsSinceStart * 100.0 / ((double)realMsSinceStart * 1000000.0);
            double cpuPercentOfReal_sincePrev = (double)cpuNsSincePrev * 100.0 / ((double)realMsSincePrev * 1000000.0);
            for (long threadID : threadIDs) {
                ThreadInfo threadInfo = tmxb.getThreadInfo(threadID);
                if (threadInfo == null) continue;
                String threadName = threadInfo.getThreadName();
                long thread_cpuNs_sinceStart = tmxb.getThreadCpuTime(threadID);
                Long prev_thread_cpuNs_sinceStart = this.prev_thread_cpuNs_sinceStart_ByThreadId.get(threadID);
                if (prev_thread_cpuNs_sinceStart == null) {
                    prev_thread_cpuNs_sinceStart = 0L;
                }
                long thread_cpuNs_sincePrev = thread_cpuNs_sinceStart - prev_thread_cpuNs_sinceStart;
                double thread_cpuPercentOfProcess_sinceStart = (double)thread_cpuNs_sinceStart * 100.0 / (double)cpuNsSinceStart;
                double thread_cpuPercentOfProcess_sincePrev = (double)thread_cpuNs_sincePrev * 100.0 / (double)cpuNsSincePrev;
                double thread_cpuPercentOfReal_sinceStart = (double)thread_cpuNs_sinceStart * 100.0 / ((double)realMsSinceStart * 1000000.0);
                double thread_cpuPercentOfReal_sincePrev = (double)thread_cpuNs_sincePrev * 100.0 / ((double)realMsSincePrev * 1000000.0);
                logString.append("Thread ").append(threadID).append(" \"").append(threadName).append("\"\n").append("    from start:  cpuNs=").append(thread_cpuNs_sinceStart).append(" ").append(" (").append(thread_cpuPercentOfProcess_sinceStart).append("% of process cputime)").append(" (").append(thread_cpuPercentOfReal_sinceStart).append("% of real time)\n").append("    from prev:  cpuNS=").append(thread_cpuNs_sincePrev).append(" ").append(" (").append(thread_cpuPercentOfProcess_sincePrev).append("% of process cputime)").append(" (").append(thread_cpuPercentOfReal_sincePrev).append("% of real time)\n");
                if (thread_cpuPercentOfProcess_sinceStart > 20.0 || thread_cpuPercentOfProcess_sincePrev > 20.0) {
                    highCpulogString.append("NOTE: HIGH CPU USE Thread ").append(threadID).append(" \"").append(threadName).append("\"").append("\n").append(" from start:  cpuNs=").append(thread_cpuNs_sinceStart).append(" ").append(" (").append(thread_cpuPercentOfProcess_sinceStart).append("% of process cputime)").append(" (").append(thread_cpuPercentOfReal_sinceStart).append("% of real time)").append("\n").append("  from prev:  cpuNS=").append(thread_cpuNs_sincePrev).append(" ").append(" (").append(thread_cpuPercentOfProcess_sincePrev).append("% of process cputime)").append(" (").append(thread_cpuPercentOfReal_sincePrev).append("% of real time)").append("\n").append("       Running for ").append(realMsSinceStart).append(" ms.     Used ").append(cpuNsSinceStart).append(" ns of cpu time in total. =").append(cpuPercentOfReal_sinceStart).append("%").append("\n").append("Last CPU print was ").append(realMsSincePrev).append(" ms ago. Used ").append(cpuNsSincePrev).append(" ns of cpu time in that time. =").append(cpuPercentOfReal_sincePrev).append("%\n");
                }
                this.prev_thread_cpuNs_sinceStart_ByThreadId.put(threadID, thread_cpuNs_sinceStart);
            }
            logString.append("       Running for ").append(realMsSinceStart).append(" ms.     Used ").append(cpuNsSinceStart).append(" ns of cpu time in total. =").append(cpuPercentOfReal_sinceStart).append("%\n");
            logString.append("Last CPU print was ").append(realMsSincePrev).append(" ms ago. Used ").append(cpuNsSincePrev).append(" ns of cpu time in that time. =").append(cpuPercentOfReal_sincePrev).append("%");
            this.prevCpuNsSinceStart = cpuNsSinceStart;
            this.prevDate = curDate;
            if (dumpThreadCpuNow) {
                LOG.info("Thread overview:\n" + logString.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Thread overview:\n" + logString.toString());
            } else {
                LOG.warn(highCpulogString.toString());
            }
            if (dumpThreadCpuNow) {
                this.lastThreadCpuDump = System.currentTimeMillis();
            }
        }
    }

    protected void startAutoExpire() {
        TimerTask expireConnectionsTask = new TimerTask(){

            @Override
            public void run() {
                SfaConnectionPool.this.clearExpired();
            }
        };
        Timer timer = new Timer("SfaConnectionPool-AutoExpire", true);
        timer.schedule(expireConnectionsTask, 10000L, 10000L);
    }

    private static class ConnectionSpecification {
        private final GeniUser user;
        private final Server server;
        private final Service service;
        private final boolean disableClientAuth;
        private final JFedConnection.ProxyInfo proxyInfo;

        private ConnectionSpecification(GeniUser user, Server server, Service service, boolean disableClientAuth, JFedConnection.ProxyInfo proxyInfo) {
            if (server == null) {
                throw new RuntimeException("server == null");
            }
            if (service == null) {
                throw new RuntimeException("service == null");
            }
            this.user = user;
            this.service = service;
            this.server = server;
            this.disableClientAuth = disableClientAuth;
            this.proxyInfo = proxyInfo;
        }

        public Service getService() {
            return this.service;
        }

        public Server getServer() {
            return this.server;
        }

        public boolean isDisableClientAuth() {
            return this.disableClientAuth;
        }

        public JFedConnection.ProxyInfo getProxyInfo() {
            return this.proxyInfo;
        }

        public GeniUser getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionSpecification that = (ConnectionSpecification)o;
            if (this.user == null != (that.user == null)) {
                return false;
            }
            if (this.user != null && !Objects.equals(this.user.getUserUrn(), that.user.getUserUrn())) {
                return false;
            }
            if (!Objects.equals(this.service.getId(), that.service.getId())) {
                return false;
            }
            if (!Objects.equals(this.server.getId(), that.server.getId())) {
                return false;
            }
            if (this.proxyInfo == null != (that.proxyInfo == null)) {
                return false;
            }
            if (this.proxyInfo != null && !Objects.equals(this.proxyInfo, that.proxyInfo)) {
                return false;
            }
            return this.disableClientAuth == that.disableClientAuth;
        }

        public int hashCode() {
            int result = ((Integer)this.service.getId()).hashCode();
            if (this.proxyInfo != null) {
                result = 31 * result + this.proxyInfo.hashCode();
            }
            result = 31 * result + ((Integer)this.server.getId()).hashCode();
            result = 31 * result + (this.disableClientAuth ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ConnectionSpecification{user=" + (this.user == null ? "null" : this.user.getUserUrnString()) + ", service=" + this.service.getId() + ", server=" + this.server.getId() + ", disableClientAuth=" + this.disableClientAuth + ", defaultProxy=" + this.proxyInfo + "}";
        }
    }
}

