/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.credential;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ServerTrustInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.io.IOException;
import java.io.StringReader;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AbacCredential
extends AnyCredential {
    private static final Logger LOG = LoggerFactory.getLogger(AbacCredential.class);
    protected final String name;
    @Nonnull
    protected final String credentialXml;
    protected final String type;
    protected final String version;
    private boolean processed = false;
    private boolean speaksFor;
    private GeniUrn spokenForUrn;
    private PublicKey spokenForPubKey;
    private List<String> signerCerts;
    protected String headKeyId;
    protected String tailKeyId;
    protected String headRole;
    protected String expiresText;
    private static final String CREDENTIAL_NAMESPACE_URI = "http://www.protogeni.net/resources/credential/credential.xsd";

    protected AbacCredential(String name, @Nonnull String credentialXml, String type, String version) {
        super(name, credentialXml, type, version);
        this.name = name;
        this.credentialXml = credentialXml;
        this.type = type;
        this.version = version;
        assert (type.equalsIgnoreCase("abac") || type.equalsIgnoreCase("geni_abac")) : "Created SfaCredential not of type sfa, but of type=\"" + type + "\" version=\"" + version + "\"";
    }

    @Override
    public String getExpires() {
        return this.expiresText;
    }

    @Override
    public Date getExpiresDate() {
        this.process();
        try {
            return this.expiresText == null ? null : RFC3339Util.iso8601StringToDate(this.expiresText);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date in ABAC credential expires: \"" + this.expiresText + "\"", e);
        }
    }

    @Override
    @Nonnull
    public String getCredentialXml() {
        return this.credentialXml;
    }

    @Override
    public boolean isSpeaksFor() {
        this.process();
        return this.speaksFor;
    }

    public GeniUrn getSpokenForUrn() {
        this.process();
        return this.spokenForUrn;
    }

    public PublicKey getSpokenForPubKey() {
        this.process();
        return this.spokenForPubKey;
    }

    public String getHeadKeyId() {
        return this.headKeyId;
    }

    public String getTailKeyId() {
        return this.tailKeyId;
    }

    public String getHeadRole() {
        return this.headRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        if (this.processed) {
            return;
        }
        this.processed = true;
        this.speaksFor = false;
        this.signerCerts = new ArrayList<String>();
        this.spokenForUrn = null;
        this.spokenForPubKey = null;
        XMLStreamReader streamReader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(this.credentialXml));
            streamReader = xif.createXMLStreamReader(xml);
            boolean withinSignedCredential = false;
            boolean withinCredential = false;
            boolean withinAbac = false;
            boolean withinExpires = false;
            boolean withinHead = false;
            boolean withinTail = false;
            boolean withinKeyId = false;
            boolean withinRole = false;
            boolean withinSignatures = false;
            boolean withinSignature = false;
            boolean withinKeyInfo = false;
            boolean withinX509Data = false;
            boolean withinX509Certificate = false;
            Object x509certText = "";
            block16: while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        if (Objects.equals(streamReader.getName().getLocalPart(), "signed-credential")) {
                            withinSignedCredential = true;
                        }
                        if (withinSignedCredential && Objects.equals(streamReader.getName().getLocalPart(), "credential")) {
                            withinCredential = true;
                        }
                        if (withinCredential && Objects.equals(streamReader.getName().getLocalPart(), "expires")) {
                            withinExpires = true;
                        }
                        if (withinCredential && Objects.equals(streamReader.getName().getLocalPart(), "abac")) {
                            withinAbac = true;
                        }
                        if (withinAbac && Objects.equals(streamReader.getName().getLocalPart(), "head")) {
                            withinHead = true;
                        }
                        if (withinAbac && Objects.equals(streamReader.getName().getLocalPart(), "tail")) {
                            withinTail = true;
                        }
                        if (withinHead && Objects.equals(streamReader.getName().getLocalPart(), "role")) {
                            withinRole = true;
                        }
                        if ((withinHead || withinTail) && Objects.equals(streamReader.getName().getLocalPart(), "keyid")) {
                            withinKeyId = true;
                        }
                        if (withinSignedCredential && Objects.equals(streamReader.getName().getLocalPart(), "signatures")) {
                            withinSignatures = true;
                        }
                        if (withinSignatures && Objects.equals(streamReader.getName().getLocalPart(), "Signature")) {
                            withinSignature = true;
                        }
                        if (withinSignature && Objects.equals(streamReader.getName().getLocalPart(), "KeyInfo")) {
                            withinKeyInfo = true;
                        }
                        if (withinKeyInfo && Objects.equals(streamReader.getName().getLocalPart(), "X509Data")) {
                            withinX509Data = true;
                        }
                        if (!withinX509Data || !Objects.equals(streamReader.getName().getLocalPart(), "X509Certificate")) continue block16;
                        withinX509Certificate = true;
                        x509certText = "";
                        continue block16;
                    }
                    case 2: {
                        if (withinSignedCredential && Objects.equals(streamReader.getName().getLocalPart(), "signed-credential")) {
                            withinSignedCredential = false;
                        }
                        if (withinSignatures && Objects.equals(streamReader.getName().getLocalPart(), "credential")) {
                            withinCredential = false;
                        }
                        if (withinCredential && Objects.equals(streamReader.getName().getLocalPart(), "abac")) {
                            withinAbac = false;
                        }
                        if (withinCredential && Objects.equals(streamReader.getName().getLocalPart(), "expires")) {
                            withinExpires = false;
                        }
                        if (withinAbac && Objects.equals(streamReader.getName().getLocalPart(), "head")) {
                            withinHead = false;
                        }
                        if (withinAbac && Objects.equals(streamReader.getName().getLocalPart(), "tail")) {
                            withinTail = false;
                        }
                        if (withinHead && Objects.equals(streamReader.getName().getLocalPart(), "role")) {
                            withinRole = false;
                        }
                        if ((withinHead || withinTail) && Objects.equals(streamReader.getName().getLocalPart(), "keyid")) {
                            withinKeyId = false;
                        }
                        if (withinSignedCredential && Objects.equals(streamReader.getName().getLocalPart(), "signatures")) {
                            withinSignatures = false;
                        }
                        if (withinSignatures && Objects.equals(streamReader.getName().getLocalPart(), "Signature")) {
                            withinSignature = false;
                        }
                        if (withinSignature && Objects.equals(streamReader.getName().getLocalPart(), "KeyInfo")) {
                            withinKeyInfo = false;
                        }
                        if (withinKeyInfo && Objects.equals(streamReader.getName().getLocalPart(), "X509Data")) {
                            withinX509Data = false;
                        }
                        if (!withinX509Data || !Objects.equals(streamReader.getName().getLocalPart(), "X509Certificate")) continue block16;
                        if (!((String)x509certText).trim().isEmpty() && x509certText != null) {
                            if (!((String)x509certText).startsWith("-----BEGIN CERTIFICATE-----")) {
                                x509certText = "-----BEGIN CERTIFICATE-----\n" + (String)x509certText + "\n-----END CERTIFICATE-----\n";
                            }
                            this.signerCerts.add(((String)x509certText).trim());
                        }
                        withinX509Certificate = false;
                        x509certText = "";
                        continue block16;
                    }
                    case 4: {
                        String roleText;
                        if (withinRole && (roleText = streamReader.getText()) != null) {
                            this.headRole = roleText.trim();
                            this.speaksFor = this.headRole.toLowerCase().startsWith("speaks_for_");
                        }
                        if (withinExpires) {
                            this.expiresText = streamReader.getText();
                        }
                        if (withinHead && withinKeyId) {
                            this.headKeyId = streamReader.getText();
                        }
                        if (withinTail && withinKeyId) {
                            this.tailKeyId = streamReader.getText();
                        }
                        if (!withinX509Certificate) continue block16;
                        x509certText = (String)x509certText + streamReader.getText();
                        continue block16;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            LOG.error("Exception while parsing ABAC credential", e);
            this.speaksFor = false;
        }
        finally {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (XMLStreamException e) {
                    LOG.error("Exception closing streamReader is ignored", e);
                }
            }
        }
        if (this.speaksFor) {
            ArrayList<GeniUrn> subjectUrns = new ArrayList<GeniUrn>();
            ArrayList<GeniUrn> issuerUrns = new ArrayList<GeniUrn>();
            for (String signerCert : this.signerCerts) {
                X509Certificate cert = KeyUtil.pemToX509Certificate(signerCert);
                if (cert == null) {
                    LOG.warn("Failed to convert signerCert to X509 certificate: \"\"\"\n" + signerCert + "\n\"\"\"");
                    continue;
                }
                subjectUrns.addAll(KeyUtil.findUrnsInCertAltNames(cert, KeyUtil.AltNamesSource.SUBJECT_ALT_NAMES, false));
                issuerUrns.addAll(KeyUtil.findUrnsInCertAltNames(cert, KeyUtil.AltNamesSource.ISSUES_ALT_NAMES, false));
            }
            ArrayList possibleUserUrns = new ArrayList(subjectUrns);
            possibleUserUrns.removeAll(issuerUrns);
            if (!possibleUserUrns.isEmpty()) {
                if (possibleUserUrns.size() > 1) {
                    System.err.println("Warning: more than 1 possible user urn in speaksFor credential signer subject alt names: " + possibleUserUrns);
                    LOG.warn("Warning: more than 1 possible user urn in speaksFor credential signer subject alt names: " + possibleUserUrns);
                }
                this.spokenForUrn = (GeniUrn)possibleUserUrns.get(0);
                for (String signerCert : this.signerCerts) {
                    String spokenForKeyId;
                    X509Certificate cert = KeyUtil.pemToX509Certificate(signerCert);
                    if (cert == null) {
                        LOG.warn("Failed to convert signerCert to X509 certificate: \"\"\"\n" + signerCert + "\n\"\"\"");
                        continue;
                    }
                    this.spokenForPubKey = cert.getPublicKey();
                    assert (this.speaksFor);
                    String signerKeyId = AbacCredential.generateKeyId(cert);
                    if (Objects.equals(signerKeyId, spokenForKeyId = this.headRole.substring("speaks_for_".length()))) continue;
                    throw new RuntimeException("AbacCredential credential is speaksfor, but signer does not match spoken for: signer=" + signerKeyId + " spokenForKeyId=" + spokenForKeyId);
                }
            }
        }
    }

    @Override
    public boolean check(TestbedInfoSource testbedInfoSource) throws CredentialException {
        this.process();
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        for (String signerCert : this.signerCerts) {
            X509Certificate cert = KeyUtil.pemToX509Certificate(signerCert);
            if (cert == null) {
                LOG.warn("Could not process signerCert {}..., skipping", (Object)signerCert.substring(0, Math.min(signerCert.length(), 10)));
                continue;
            }
            List<GeniUrn> urns = KeyUtil.findUrnsInCertAltNames(cert, KeyUtil.AltNamesSource.SUBJECT_ALT_NAMES, false);
            urns.addAll(KeyUtil.findUrnsInCertAltNames(cert, KeyUtil.AltNamesSource.ISSUES_ALT_NAMES, false));
            for (GeniUrn urn : urns) {
                Server auth = testbedInfoSource.getFromAnyUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
                jFedTrustStore.addAuthorityCert(ServerTrustInfo.convert(auth));
            }
        }
        return this.check(jFedTrustStore.getTrustStore());
    }

    public static String getGeniSubjectName(X509Certificate geniUserCert) {
        if (geniUserCert == null) {
            return "null";
        }
        return geniUserCert.getSubjectDN().getName();
    }

    public static String generateKeyId(X509Certificate cert) {
        PublicKey pubKey = cert.getPublicKey();
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            RSAPublicKey rsaPubKey = (RSAPublicKey)pubKey;
            byte[] keyDataBytes = KeyUtil.getPublicKeyPKCS1(rsaPubKey);
            crypt.update(keyDataBytes);
            byte[] bytes = crypt.digest();
            Object res = "";
            for (byte aByte : bytes) {
                res = (String)res + String.format("%02x", aByte);
            }
            return res;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This java has no support for SHA-1", e);
        }
    }

    public static AbacCredential createSpeaksFor(Date expireDate, X509Certificate speakerToolCert, X509Certificate spokenForCert, Key spokenForPrivateKey) throws CredentialException {
        String credentialXmlString;
        Document doc;
        String userKeyhash = AbacCredential.generateKeyId(spokenForCert).toLowerCase();
        String toolKeyhash = AbacCredential.generateKeyId(speakerToolCert).toLowerCase();
        String expiresString = RFC3339Util.dateToRFC3339String(expireDate, true);
        String credentialId = "_0";
        String template = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<signed-credential xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:noNamespaceSchemaLocation=\"http://www.protogeni.net/resources/credential/credential.xsd\"\nxsi:schemaLocation=\"http://www.protogeni.net/resources/credential/ext/policy/1\nhttp://www.protogeni.net/resources/credential/ext/policy/1/policy.xsd\">\n  <credential xml:id=\"" + credentialId + "\">\n\n        <type>abac</type>\n        <serial/>\n        <owner_gid/>\n        <target_gid/>\n        <uuid/>\n        <expires>" + expiresString + "</expires>\n        <abac>\n            <rt0>\n                <version>1.1</version>\n                <head>\n   <ABACprincipal><keyid>" + userKeyhash + "</keyid></ABACprincipal>\n   <role>speaks_for_" + userKeyhash + "</role>\n</head>\n<tail>\n   <ABACprincipal><keyid>" + toolKeyhash + "</keyid></ABACprincipal>\n</tail>\n\n            </rt0>\n        </abac>\n\n</credential>\n  <signatures>\n  </signatures>\n</signed-credential>";
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(template)));
            Element rootElement = doc.getDocumentElement();
            assert (rootElement != null);
            assert (rootElement.getTagName() != null);
            assert (Objects.equals(rootElement.getTagName(), "signed-credential"));
            NodeList credentialNl = rootElement.getElementsByTagName("credential");
            assert (credentialNl.getLength() == 1);
            LOG.debug("Need to mark " + credentialNl.getLength() + " <credential> xml:id attributes as xml IDs");
            for (int j = 0; j < credentialNl.getLength(); ++j) {
                Node n = credentialNl.item(j);
                if (n.getNodeType() != 1) continue;
                Element credentialEl = (Element)n;
                NamedNodeMap l = credentialEl.getAttributes();
                for (int i = 0; i < l.getLength(); ++i) {
                    Attr a = (Attr)l.item(i);
                    if (Objects.equals(a.getName(), "xml:id")) {
                        LOG.debug("Marking <credential> Attribute as id: " + a);
                        credentialEl.setIdAttributeNode(a, true);
                        continue;
                    }
                    LOG.debug("<credential> Attribute is not id: '" + a.getNamespaceURI() + "' : '" + a.getName() + "' -> " + a);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CredentialException("Failed to create credential: " + e.getMessage(), e);
        }
        try {
            credentialXmlString = XmlUtil.signXml(doc, credentialId, "signatures", spokenForCert, spokenForPrivateKey);
        }
        catch (TransformerException | XMLSecurityException e) {
            throw new CredentialException("Failed to sign generated credential: " + e.getMessage(), e);
        }
        return new AbacCredential("speaksFor credential allowing " + AbacCredential.getGeniSubjectName(speakerToolCert) + " to speak for " + AbacCredential.getGeniSubjectName(spokenForCert), credentialXmlString, "abac", "1.1");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbacCredential that = (AbacCredential)o;
        if (!Objects.equals(this.credentialXml, that.credentialXml)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.credentialXml.hashCode();
        return result;
    }
}

