/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.HostnameAndCertificateMismatchSSLException;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpInfoXmlRpcTransportFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsGeneral;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.JFedConnectivityException;
import be.iminds.ilabt.jfed.lowlevel.lib.JFedTimeoutException;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.DataConversionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.schmizz.sshj.connection.channel.OpenFailException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.jetbrains.annotations.Contract;
import org.slf4j.LoggerFactory;

public abstract class AbstractApi {
    protected static final ReplyConverter<String> STRING_REPLY_CONVERTER = resultValueObject -> {
        String value;
        if (resultValueObject != null && !(value = resultValueObject.toString()).isEmpty()) {
            return value;
        }
        return null;
    };
    protected static final ReplyConverter<Boolean> BOOLEAN_REPLY_CONVERTER = resultValueObject -> {
        try {
            return (Boolean)resultValueObject;
        }
        catch (Exception ignored) {
            return false;
        }
    };
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(AbstractApi.class);
    @Nonnull
    protected final JFedPreferences jFedPreferences;
    @Nonnull
    private RetrySettings retrySettings;
    @Nonnull
    private ApiInfo.Api api;
    @Nonnull
    private Logger logger;
    private HttpCallDetails lastHttpResult;
    private XMLRPCCallDetails lastXmlRpcResult;
    private ApiCallReply lastApiCallReply;
    private boolean allowGzip = true;
    private boolean allowDeflate = true;
    private static final Pattern PATTERN_KEEP_ALIVE_TIMEOUT = Pattern.compile("timeout=([0-9]*)");

    public AbstractApi(@Nonnull Logger logger2, @Nonnull RetrySettings retrySettings, @Nonnull ApiInfo.Api api, @Nonnull JFedPreferences jFedPreferences) {
        assert (logger2 != null);
        assert (api != null);
        assert (jFedPreferences != null);
        this.logger = logger2;
        this.retrySettings = retrySettings;
        this.api = api;
        this.jFedPreferences = jFedPreferences;
    }

    public AbstractApi(@Nonnull Logger logger2, @Nonnull ApiInfo.Api api, @Nonnull JFedPreferences jFedPreferences) {
        this(logger2, jFedPreferences.getRetrySettings(), api, jFedPreferences);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String apiSpecifiesNullableString(@Nullable Object o) throws BadReplyGeniException {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new BadReplyGeniException("The API specified a String was expected here, but a " + o.getClass().getName() + " was found instead. value=" + o);
    }

    @Nonnull
    public static String apiSpecifiesNonNullString(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof String) {
            return (String)o;
        }
        throw new BadReplyGeniException("The API specified a String was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=" + o);
    }

    @Nonnull
    public static List<String> apiSpecifiesListOfString(@Nullable Object o) throws BadReplyGeniException {
        return AbstractApi.apiSpecifiesListOfT(String.class, o);
    }

    @Nonnull
    public static <T> List<T> apiSpecifiesListOfT(Class<T> tClass, Object o) throws BadReplyGeniException {
        if (o != null && o instanceof Object[]) {
            Object[] oArray = (Object[])o;
            ArrayList<Object> result = new ArrayList<Object>(oArray.length);
            for (Object el : oArray) {
                if (!tClass.isInstance(el)) {
                    throw new BadReplyGeniException("The API specified a List of " + tClass.getName() + " was expected here, but at least one element was " + (el == null ? null : el.getClass().getName()) + ". elementValue=" + el + " ListValue=" + o);
                }
                result.add(el);
            }
            return result;
        }
        throw new BadReplyGeniException("The API specified a List of " + tClass.getName() + " was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=\"" + o + "\"");
    }

    @Nonnull
    public static Map<String, Object> apiSpecifiesMapStringToObject(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof Map) {
            for (Map.Entry entryO : ((Map)o).entrySet()) {
                Map.Entry entry = entryO;
                if (entry == null) {
                    throw new BadReplyGeniException("at least one element is null. o=" + o);
                }
                if (entry.getKey() instanceof String) continue;
                throw new BadReplyGeniException("The API specified a Map mapping Strings to Objects was expected here, but at least one element has a key of type  " + (entry.getKey() == null ? null : entry.getKey().getClass().getName()) + ". keyValue=" + entry.getKey() + " MapValue=" + o);
            }
            return (Map)o;
        }
        throw new BadReplyGeniException("The API specified a Map mapping Strings to Objects was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=\"" + o + "\"");
    }

    @Nonnull
    public static Map<String, String> apiSpecifiesMapStringToString(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof Map) {
            for (Map.Entry entryO : ((Map)o).entrySet()) {
                Map.Entry entry = entryO;
                if (entry == null) {
                    throw new BadReplyGeniException("at least one element is null. o=" + o);
                }
                if (entry.getKey() == null || !(entry.getKey() instanceof String)) {
                    throw new BadReplyGeniException("The API specified a Map mapping Strings to String was expected here, but at least one element has a key of type  " + (entry.getKey() == null ? null : entry.getKey().getClass().getName()) + ". keyValue=" + entry.getKey() + " MapValue=" + o);
                }
                if (entry.getValue() != null && entry.getValue() instanceof String) continue;
                throw new BadReplyGeniException("The API specified a Map mapping Strings to String was expected here, but at least one element has a value of type  " + (entry.getValue() == null ? null : entry.getValue().getClass().getName()) + ". valueValue=" + entry.getKey() + " MapValue=" + o);
            }
            return (Map)o;
        }
        throw new BadReplyGeniException("The API specified a Map mapping Strings to String was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=" + o);
    }

    public static int apiSpecifiesInt(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof Integer) {
            return (Integer)o;
        }
        throw new BadReplyGeniException("The API specified a Integer was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=" + o);
    }

    @Nonnull
    public static String apiSpecifiesString(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof String) {
            return (String)o;
        }
        throw new BadReplyGeniException("The API specified a String was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=" + o);
    }

    @Nonnull
    public static Boolean apiSpecifiesBoolean(@Nullable Object o) throws BadReplyGeniException {
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new BadReplyGeniException("The API specified a Boolean was expected here, but a " + (o == null ? null : o.getClass().getName()) + " was found instead. value=" + o);
    }

    @Nonnull
    public static String apiSpecifiesStringInMap(@Nonnull Map<String, Object> ht, @Nonnull String key) throws BadReplyGeniException {
        if (ht.containsKey(key)) {
            try {
                return AbstractApi.apiSpecifiesString(ht.get(key));
            }
            catch (BadReplyGeniException e) {
                throw new BadReplyGeniException("The API specified the dictionary to have a String value for key '" + key + "', but it is not valid", (Exception)e);
            }
        }
        throw new BadReplyGeniException("The API specified the dictionary to have a String value for key '" + key + "', but it is not present");
    }

    @Nullable
    public static String apiSpecifiesOptionalStringInMap(@Nonnull Map<String, Object> ht, @Nonnull String key) throws BadReplyGeniException {
        if (ht.containsKey(key)) {
            try {
                Object val = ht.get(key);
                if (val == null) {
                    return null;
                }
                return AbstractApi.apiSpecifiesString(val);
            }
            catch (BadReplyGeniException e) {
                throw new BadReplyGeniException("The API specified the dictionary to have a String value for key '" + key + "', but it is not a String", (Exception)e);
            }
        }
        return null;
    }

    @Nonnull
    public static GeniUrn apiSpecifiesGeniUrn(@Nullable Object o) throws BadReplyGeniException {
        try {
            return new GeniUrn(AbstractApi.apiSpecifiesString(o));
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new BadReplyGeniException("The API specified a GeniUrn was expected here, but could not parse '" + o + "'");
        }
    }

    @Nonnull
    public static GeniUrn apiSpecifiesGeniUrnInMap(@Nonnull Map<String, Object> ht, @Nonnull String key) throws BadReplyGeniException {
        if (ht.containsKey(key)) {
            try {
                return AbstractApi.apiSpecifiesGeniUrn(ht.get(key));
            }
            catch (BadReplyGeniException e) {
                throw new BadReplyGeniException("The API specified the dictionary to have a GeniUrn value for key '" + key + "', but it is not valid", (Exception)e);
            }
        }
        throw new BadReplyGeniException("The API specified the dictionary to have a GeniUrn value for key '" + key + "', but it is not present");
    }

    @Nonnull
    public static Date apiSpecifiesDate(@Nullable Object dateValue) throws BadReplyGeniException {
        if (dateValue instanceof Date) {
            return (Date)dateValue;
        }
        if (dateValue instanceof String) {
            try {
                return RFC3339Util.rfc3339StringToDate((String)dateValue);
            }
            catch (ParseException e) {
                throw new BadReplyGeniException("Could not parse date '" + dateValue + "'");
            }
        }
        throw new BadReplyGeniException("Expected a valid date");
    }

    @Nonnull
    public static Date apiSpecifiesDateInMap(@Nonnull Map<String, Object> ht, @Nonnull String key) throws BadReplyGeniException {
        if (ht.containsKey(key)) {
            try {
                Object val = ht.get(key);
                if (val == null) {
                    throw new BadReplyGeniException("The API specified the dictionary to have a RFC3339 Date value for key '" + key + "', but it is a null");
                }
                return AbstractApi.apiSpecifiesDate(val);
            }
            catch (BadReplyGeniException e) {
                throw new BadReplyGeniException("The API specified the dictionary to have a RFC3339 Date value for key '" + key + "', but it is not valid", (Exception)e);
            }
        }
        throw new BadReplyGeniException("The API specified the dictionary to have a RFC3339 Date value for key '" + key + "', but it is not present");
    }

    @Nullable
    public static Date apiSpecifiesOptionalDateInMap(@Nonnull Map<String, Object> ht, @Nonnull String key) throws BadReplyGeniException {
        if (ht.containsKey(key)) {
            try {
                Object val = ht.get(key);
                if (val == null) {
                    return null;
                }
                return AbstractApi.apiSpecifiesDate(val);
            }
            catch (BadReplyGeniException e) {
                throw new BadReplyGeniException("The API specified the dictionary to have a RFC3339 Date value for key '" + key + "', but it is not valid", (Exception)e);
            }
        }
        return null;
    }

    @Nonnull
    public static List<Map> createCredentialsListWithTypeAndVersion(@Nonnull List<AnyCredential> credentialList) {
        if (credentialList.contains(null)) {
            throw new IllegalArgumentException("Illegal arguments: no AnyCredential is allowed to be null in credentialList: " + credentialList);
        }
        List<Map> credentialsList = credentialList.stream().map(AnyCredential::getGeniV3Map).collect(Collectors.toList());
        assert (!credentialsList.contains(null));
        return credentialsList;
    }

    @Nonnull
    protected static Map<String, Object> makeMethodParameters(@Nonnull String name, @Nonnull Object val) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(name, val);
        return res;
    }

    @Nonnull
    protected static Map<String, Object> makeMethodParameters(Object ... args) {
        assert (args.length % 2 == 0);
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            res.put((String)args[i], args[i + 1]);
        }
        return res;
    }

    @Contract(value="null -> false")
    public static boolean isTimeout(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (AbstractApi.isTimeoutHelper(e)) {
            return true;
        }
        while (e.getCause() != null) {
            if (!AbstractApi.isTimeoutHelper(e = e.getCause())) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    protected static boolean isTimeoutHelper(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof TimeoutException) {
            return true;
        }
        if (e instanceof InterruptedIOException) {
            assert (e instanceof ConnectTimeoutException || e instanceof SocketTimeoutException);
            return true;
        }
        if (e instanceof NoHttpResponseException) {
            return true;
        }
        if (e instanceof IOException && e.getMessage() != null) {
            if (e.getMessage().toLowerCase().contains("Connection timed out".toLowerCase())) {
                return true;
            }
            if (e.getMessage().toLowerCase().contains("SSH_OPEN_CONNECT_FAILED".toLowerCase())) {
                return true;
            }
            if (e.getMessage().toLowerCase().contains("The server refused to open the channel".toLowerCase())) {
                return true;
            }
            if (e.getMessage().toLowerCase().contains("Could not open channel".toLowerCase())) {
                return true;
            }
        }
        return e instanceof XmlRpcClientException && e.getMessage().equals("Unable to end request");
    }

    @Nonnull
    protected static Map<String, Object> createOptionsMap(@Nullable Map<String, ?> extraOptions) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        return options;
    }

    @Nonnull
    public abstract String getName();

    @Nonnull
    public ApiInfo.Api getApi() {
        return this.api;
    }

    @Nonnull
    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nonnull Logger logger2) {
        this.logger = logger2;
    }

    @Nonnull
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public void setRetrySettings(@Nullable RetrySettings retrySettings) {
        this.retrySettings = retrySettings == null ? this.jFedPreferences.getRetrySettings() : retrySettings;
    }

    protected void log(@Nullable XMLRPCCallDetails xmlRpcRes, @Nullable ApiCallReply reply, @Nonnull String javaMethodName, @Nonnull String geniMethodName, @Nonnull SfaConnection con, @Nullable Map<String, Object> methodParameters) {
        this.log(xmlRpcRes, reply, javaMethodName, geniMethodName, con, methodParameters == null ? Collections.emptyMap() : methodParameters, null);
    }

    protected void log(@Nullable XMLRPCCallDetails xmlRpcRes, @Nullable ApiCallReply reply, @Nonnull String javaMethodName, @Nonnull String geniMethodName, @Nonnull SfaConnection con, @Nonnull Map<String, Object> methodParameters, Throwable extraException) {
        JFedConnection.DebugInfo debugInfo;
        Throwable ex;
        String httpReply;
        String httpReplyHeaders;
        StatusLine httpStatusLine;
        String httpRequest;
        String httpRequestHeaders;
        String httpRequestLine;
        this.lastHttpResult = xmlRpcRes;
        this.lastXmlRpcResult = xmlRpcRes;
        this.lastApiCallReply = reply;
        if (xmlRpcRes != null && xmlRpcRes.getLastConnection() != null && xmlRpcRes.getLastConnection() instanceof SfaConnection) {
            con = (SfaConnection)xmlRpcRes.getLastConnection();
        }
        assert (this.logger != null);
        String serverUrl = con.getServerUrl();
        assert (xmlRpcRes.getServerUrl() == null || con.getServerUrl().equals(xmlRpcRes.getServerUrl())) : "Wrongfully assumed that XML-RPC always uses base URL: " + xmlRpcRes.getServerUrl() + " != " + con.getServerUrl();
        String apiName = this.getName();
        if (xmlRpcRes == null) {
            if (con.getXmlRpcTransportFactory() != null) {
                httpRequestLine = con.getXmlRpcTransportFactory().getHttpRequestLine();
                httpRequestHeaders = con.getXmlRpcTransportFactory().getHttpRequestHeaders();
                httpRequest = con.getXmlRpcTransportFactory().getHttpSentHistory();
                httpStatusLine = con.getXmlRpcTransportFactory().getHttpStatusLine();
                httpReplyHeaders = con.getXmlRpcTransportFactory().getHttpResponseHeaders();
                httpReply = con.getXmlRpcTransportFactory().getHttpReceivedHistory();
            } else {
                httpRequestLine = null;
                httpRequestHeaders = null;
                httpRequest = null;
                httpStatusLine = null;
                httpReplyHeaders = null;
                httpReply = null;
            }
        } else {
            httpRequestLine = xmlRpcRes.getRequestHttpRequestLine();
            httpRequestHeaders = xmlRpcRes.getRequestHttpHeaders();
            httpRequest = xmlRpcRes.getRequestHttpContent();
            httpStatusLine = xmlRpcRes.getResultHttpStatusLineObject();
            httpReplyHeaders = xmlRpcRes.getResultHttpHeaders();
            httpReply = xmlRpcRes.getResultHttpContent();
        }
        Throwable throwable = ex = xmlRpcRes == null ? null : xmlRpcRes.getException();
        if (ex == null) {
            ex = extraException;
        }
        ApiCallDetails res = new ApiCallDetails((debugInfo = con.getDebugInfo()) == null ? null : debugInfo.getServiceId(), debugInfo == null ? null : debugInfo.getServerId(), debugInfo == null ? null : debugInfo.getServerName(), debugInfo == null ? null : debugInfo.getServerUrn(), debugInfo == null ? null : debugInfo.getTestbedId(), con.getConnectionConfig(), serverUrl, "" + con.getConnectionId(), apiName, javaMethodName, geniMethodName, reply, httpRequestLine, httpRequestHeaders, httpRequest, httpStatusLine == null ? null : httpStatusLine.toString(), httpReplyHeaders, httpReply, xmlRpcRes == null ? null : xmlRpcRes.getRequest(), xmlRpcRes == null ? null : xmlRpcRes.getResult(), methodParameters, xmlRpcRes == null ? null : xmlRpcRes.getStartTime(), xmlRpcRes == null ? null : xmlRpcRes.getStopTime(), ex);
        this.getLogger().fireResult(res);
    }

    protected void logNonSfa(@Nullable HttpCallDetails httpCallDetails, @Nullable ApiCallReply reply, @Nonnull String javaMethodName, @Nonnull String apiMethodName, @Nonnull JFedConnection con, @Nonnull Map<String, Object> methodParameters, @Nullable Exception exception) {
        this.lastHttpResult = httpCallDetails;
        this.lastXmlRpcResult = null;
        this.lastApiCallReply = reply;
        assert (this.logger != null);
        JFedConnection.DebugInfo debugInfo = con.getDebugInfo();
        String serverBaseUrl = con.getServerUrl();
        String apiName = this.getName();
        ApiCallDetails res = new ApiCallDetails(debugInfo == null ? null : debugInfo.getServiceId(), debugInfo == null ? null : debugInfo.getServerId(), debugInfo == null ? null : debugInfo.getServerName(), debugInfo == null ? null : debugInfo.getServerUrn(), debugInfo == null ? null : debugInfo.getTestbedId(), con.getConnectionConfig(), httpCallDetails != null ? httpCallDetails.getServerUrl() : con.getConnectionConfig().getServerUrlString(), "" + con.getConnectionId(), apiName, javaMethodName, apiMethodName, reply, httpCallDetails == null ? null : httpCallDetails.getRequestHttpRequestLine(), httpCallDetails == null ? null : httpCallDetails.getRequestHttpHeaders(), httpCallDetails == null ? null : httpCallDetails.getRequestHttpContent(), httpCallDetails == null ? null : httpCallDetails.getResultHttpStatusLine(), httpCallDetails == null ? null : httpCallDetails.getResultHttpHeaders(), httpCallDetails == null ? null : httpCallDetails.getResultHttpContent(), null, null, methodParameters, httpCallDetails == null ? null : httpCallDetails.getStartTime(), httpCallDetails == null ? null : httpCallDetails.getStopTime(), (Throwable)exception);
        this.getLogger().fireResult(res);
    }

    public HttpCallDetails getLastHttpResult() {
        return this.lastHttpResult;
    }

    public XMLRPCCallDetails getLastXmlRpcResult() {
        return this.lastXmlRpcResult;
    }

    protected abstract boolean isBusyReply(XMLRPCCallDetails var1);

    protected boolean isPossibleTemporaryErrorReply(XMLRPCCallDetails res) {
        return false;
    }

    protected boolean isPossibleTimeoutReply(XMLRPCCallDetails res) {
        return false;
    }

    protected HttpCallDetails executeHttpCall(HttpConnection con, String apiMethodName, HttpVerb httpVerb, String url, ContentType requestContentType, String requestContent, String javaMethodName, Map<String, Object> methodParameters, Map<String, Object> urlParameters, Map<String, String> extraHeaders) throws JFedException, MalformedURLException {
        return this.executeHttpCall(con, apiMethodName, httpVerb, url, requestContent == null ? null : new StringEntity(requestContent, requestContentType), javaMethodName, methodParameters, urlParameters, extraHeaders);
    }

    protected HttpCallDetails executeHttpCall(HttpConnection con, String apiMethodName, HttpVerb httpVerb, String url, ContentType requestContentType, String requestContent, String javaMethodName, Map<String, Object> methodParameters, Map<String, Object> urlParameters) throws JFedException, MalformedURLException {
        return this.executeHttpCall(con, apiMethodName, httpVerb, url, requestContent == null ? null : new StringEntity(requestContent, requestContentType), javaMethodName, methodParameters, urlParameters, null);
    }

    protected void setAllowGzip(boolean allowGzip) {
        this.allowGzip = allowGzip;
    }

    public void setAllowDeflate(boolean allowDeflate) {
        this.allowDeflate = allowDeflate;
    }

    protected HttpCallDetails executeHttpCall(HttpConnection con, String apiMethodName, HttpVerb httpVerb, String baseUrl, HttpEntity requestEntity, String javaMethodName, Map<String, Object> methodParameters, Map<String, Object> urlParameters, Map<String, String> extraHeaders) throws JFedException, MalformedURLException {
        URI uri;
        assert (con != null);
        ConnectionConfig conConf = con.getConnectionConfig();
        assert (conConf != null);
        HttpClient httpClient = this.allowDeflate || this.allowGzip ? new DecompressingHttpClient(con.getHttpClient()) : con.getHttpClient();
        assert (httpClient != null);
        Date startTime = new Date();
        HttpRequestBase httpCall = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(baseUrl);
            for (Map.Entry<String, Object> e : urlParameters.entrySet()) {
                uriBuilder.addParameter(e.getKey(), "" + e.getValue());
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        switch (httpVerb) {
            case GET: {
                httpCall = new HttpGet(uri);
                assert (requestEntity == null) : "Cannot send content with HTTP GET";
                break;
            }
            case POST: {
                HttpPost h2 = new HttpPost(uri);
                httpCall = h2;
                if (requestEntity == null) break;
                h2.setEntity(requestEntity);
                break;
            }
            case PUT: {
                HttpPut h2 = new HttpPut(uri);
                httpCall = h2;
                if (requestEntity == null) break;
                h2.setEntity(requestEntity);
                break;
            }
            case DELETE: {
                httpCall = new HttpDelete(uri);
                LOG.warn("Sending content with a HTTP DELETE call! This is rather unexpected..");
            }
        }
        assert (httpCall != null);
        if (extraHeaders != null) {
            for (Map.Entry entry : extraHeaders.entrySet()) {
                httpCall.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        httpCall.addHeader("Accept", "*/*");
        if (this.allowGzip || this.allowDeflate) {
            Object allowed = "";
            if (this.allowGzip) {
                allowed = (String)allowed + "gzip";
            }
            if (this.allowDeflate && this.allowGzip) {
                allowed = (String)allowed + ", ";
            }
            if (this.allowDeflate) {
                allowed = (String)allowed + "deflate";
            }
            httpCall.addHeader("Accept-Encoding", (String)allowed);
        }
        StringBuilder httpRequestHeaders = new StringBuilder(200);
        for (Header header : httpCall.getAllHeaders()) {
            httpRequestHeaders.append(header.toString()).append("\n");
        }
        httpRequestHeaders.append("\n");
        int timeoutRetries = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            DefaultHttpCallDetails httpCallDetails;
            try {
                DefaultHttpCallDetails httpCallDetails2;
                con.markInUse();
                tryAgain = false;
                LOG.trace("AbstractApi.executeHttpCall executing call to \"" + uri.toASCIIString() + "\"");
                startTime = new Date();
                Object var16_21 = null;
                HttpResponse response = con.getHttpContext() != null ? httpClient.execute((HttpUriRequest)httpCall, con.getHttpContext()) : httpClient.execute(httpCall);
                Date date = new Date();
                LOG.trace("AbstractApi.executeHttpCall call returned statusline \"" + response.getStatusLine() + "\"");
                boolean busy = false;
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 500) {
                    busy = true;
                }
                StringBuilder httpResponseHeaders = new StringBuilder(200);
                for (Header header : response.getAllHeaders()) {
                    httpResponseHeaders.append(header.toString()).append("\n");
                }
                httpResponseHeaders.append("\n");
                HttpEntity entity = response.getEntity();
                String resultContent = entity != null ? IOUtils.streamToString(entity.getContent(), "UTF-8") : "";
                LOG.trace("AbstractApi.executeHttpCall call returned: \"" + resultContent + "\"");
                DefaultHttpCallDetails defaultHttpCallDetails = httpCallDetails2 = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, response.getStatusLine(), httpResponseHeaders.toString(), resultContent, startTime, date, null, con);
                return defaultHttpCallDetails;
            }
            catch (InterruptedIOException e) {
                Date date = new Date();
                LOG.debug("AbstractApi.executeHttpCall call threw InterruptedIOException (typically SocketTimeoutException or ConnectTimeoutException)", e);
                httpCallDetails = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, null, null, null, startTime, date, e, con);
                if (timeoutRetries++ >= this.retrySettings.getTimeoutMaxRetries()) {
                    Object extra = "";
                    if (timeoutRetries - 1 > 0) {
                        extra = "Already retried " + timeoutRetries + " times after timeout. ";
                    }
                    throw new JFedTimeoutException("AbstractApi.executeHttpCall call threw timeout exception. " + (String)extra + "Possibly incorrect URL \"" + con.getServerUrl() + "\". Could also be connectivity problem.", (Throwable)e, null, GeniAMResponseCode.SERVER_TIMEOUT_ERROR);
                }
                this.logNonSfa(httpCallDetails, null, javaMethodName, apiMethodName, con, methodParameters, e);
                LOG.info("Got read timeout (timeoutRetries=" + timeoutRetries + ") from server. Waiting " + this.retrySettings.getTimeoutMsBeforeRetry() + "ms, and trying again...");
                try {
                    Thread.sleep(this.retrySettings.getTimeoutMsBeforeRetry());
                }
                catch (InterruptedException ex) {
                    LOG.warn("InterruptedException in wait after timeout. Possible reason: User interrupted wait?", ex);
                    httpCall.abort();
                    throw new JFedException("Aborted waiting after timeout", (Throwable)ex, null, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
                }
                tryAgain = true;
                httpCall.abort();
            }
            catch (SSLPeerUnverifiedException ex) {
                httpCallDetails = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, null, null, null, startTime, new Date(), ex, con);
                this.logNonSfa(httpCallDetails, null, javaMethodName, apiMethodName, con, methodParameters, ex);
                httpCall.abort();
                throw new JFedConnectivityException("The server certificate for '" + uri.toASCIIString() + "' could not be verified. Error message \"" + ex.getMessage() + "\". Possible causes:\n  - The server's self-signed certificate is not in our trust store. \n  - The server's certificate \"CN\" field is not the server hostname or a known alias. \n  - The server is not accepting our client login certificate+key pair (perhaps is is not federated with our \"login provider\"). \n  - If the server's certificate is not self signed, we might not have the root certificate of the trust chain in our trust store.", ex);
            }
            catch (SSLException ex) {
                httpCallDetails = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, null, null, null, startTime, new Date(), ex, con);
                this.logNonSfa(httpCallDetails, null, javaMethodName, apiMethodName, con, methodParameters, ex);
                httpCall.abort();
                throw new JFedConnectivityException("SSLException: " + ex.getMessage(), ex);
            }
            catch (ClientProtocolException ex) {
                httpCallDetails = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, null, null, null, startTime, new Date(), ex, con);
                this.logNonSfa(httpCallDetails, null, javaMethodName, apiMethodName, con, methodParameters, ex);
                httpCall.abort();
                throw new JFedConnectivityException("ClientProtocolException: " + ex.getMessage(), ex);
            }
            catch (IOException ex) {
                httpCallDetails = new DefaultHttpCallDetails(conConf, uri.toASCIIString(), httpCall.getRequestLine().toString(), httpRequestHeaders.toString(), requestEntity, null, null, null, startTime, new Date(), ex, con);
                this.logNonSfa(httpCallDetails, null, javaMethodName, apiMethodName, con, methodParameters, ex);
                httpCall.abort();
                throw new JFedConnectivityException("IOException: " + ex.getMessage(), ex);
            }
            finally {
                con.markNotInUse();
            }
        }
        throw new RuntimeException("Bug in code, this should never occur.");
    }

    protected XMLRPCCallDetailsWithCodeValueError executeXmlRpcCommandGeni(@Nonnull SfaConnection con, @Nonnull String command, @Nonnull List argv, @Nonnull Map<String, Object> methodParameters) throws JFedException {
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, command, argv, methodParameters, true);
        if (!(res instanceof XMLRPCCallDetailsWithCodeValueError)) {
            XMLRPCCallDetailsWithCodeValueError convertedres = new XMLRPCCallDetailsWithCodeValueError(res.getConnectionConfig(), res.getServerUrl(), res.getRequestHttpRequestLine(), res.getRequestHttpHeaders(), res.getRequestHttpContent(), res.getResultHttpStatusLineObject(), res.getResultHttpHeaders(), res.getResultHttpContent(), res.getRequest(), (Map)res.getResult(), res.getStartTime(), res.getStopTime(), res.getException(), con);
            return convertedres;
        }
        return (XMLRPCCallDetailsWithCodeValueError)res;
    }

    protected boolean isBusy(@Nullable Object xmlRpcClientReply, @Nullable SfaConnection con, @Nullable XMLRPCCallDetails xMLRPCCallDetails) {
        int code;
        LOG.trace("isBusy called");
        if (con != null && con.getXmlRpcTransportFactory() != null && con.getXmlRpcTransportFactory().getHttpStatusLine() != null && (code = con.getXmlRpcTransportFactory().getHttpStatusLine().getStatusCode()) == 503) {
            return true;
        }
        if (xmlRpcClientReply == null) {
            return false;
        }
        if (xmlRpcClientReply instanceof XmlRpcException) {
            XmlRpcException ex = (XmlRpcException)xmlRpcClientReply;
            LOG.info("XmlRpc call returned XmlRpcException of class=" + ex.getClass().getName() + " code=" + ex.code + " msg=" + ex.getMessage(), ex);
            if (this.isBusy(ex)) {
                return true;
            }
        }
        LOG.trace("isBusy xMLRPCCallDetails=" + xMLRPCCallDetails + " xmlRpcClientReply=" + xmlRpcClientReply.getClass().getName());
        if (xMLRPCCallDetails != null && this.isBusyReply(xMLRPCCallDetails)) {
            return true;
        }
        LOG.trace("not busy");
        return false;
    }

    protected boolean isTimeout(Object xmlRpcClientReply, SfaConnection con) {
        XmlRpcException ex;
        if (con != null && con.getXmlRpcTransportFactory() != null && con.getXmlRpcTransportFactory().getHttpStatusLine() != null) {
            int code = con.getXmlRpcTransportFactory().getHttpStatusLine().getStatusCode();
            if (code == 504) {
                return true;
            }
            if (code == 408) {
                return true;
            }
            if (code == 419) {
                return true;
            }
            if (code == 524) {
                return true;
            }
            if (code == 598) {
                return true;
            }
            if (code == 599) {
                return true;
            }
        }
        if (xmlRpcClientReply == null) {
            return false;
        }
        return xmlRpcClientReply.getClass().equals(XmlRpcException.class) && AbstractApi.isTimeout(ex = (XmlRpcException)xmlRpcClientReply);
    }

    protected boolean isPossibleTemporaryError(Object xmlRpcClientReply, SfaConnection con, XMLRPCCallDetails xMLRPCCallDetails) {
        XmlRpcException ex;
        if (xmlRpcClientReply == null) {
            return false;
        }
        if (xmlRpcClientReply.getClass().equals(XmlRpcException.class) && this.isPossibleTemporaryError(ex = (XmlRpcException)xmlRpcClientReply)) {
            return true;
        }
        return xMLRPCCallDetails != null && this.isPossibleTemporaryErrorReply(xMLRPCCallDetails);
    }

    protected boolean isPossibleTemporaryError(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e.getClass().equals(XmlRpcException.class)) {
            XmlRpcException ex = (XmlRpcException)e;
            if (ex.code == -32500 && ex.getMessage().equals("Could not verify user certificate chain")) {
                return true;
            }
        }
        if (this.isPossibleTemporaryErrorHelper(e)) {
            return true;
        }
        while (e.getCause() != null) {
            if (!AbstractApi.isTimeoutHelper(e = e.getCause())) continue;
            return true;
        }
        return false;
    }

    protected boolean isPossibleTemporaryErrorHelper(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof SSLPeerUnverifiedException && e.getMessage().trim().contains("peer not authenticated")) {
            return true;
        }
        return e instanceof OpenFailException;
    }

    protected boolean isBusy(Exception ex) {
        if (ex == null) {
            return false;
        }
        if (this.isBusyNoRecurse(ex)) {
            return true;
        }
        Throwable recurseEx = ex;
        while (recurseEx != null) {
            if ((recurseEx = recurseEx.getCause()) == null || !this.isBusyNoRecurse(recurseEx)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBusyNoRecurse(@Nonnull Throwable ex) {
        if (ex instanceof HttpInfoXmlRpcTransportFactory.HttpServerErrorException) {
            HttpInfoXmlRpcTransportFactory.HttpServerErrorException serverErrEx = (HttpInfoXmlRpcTransportFactory.HttpServerErrorException)ex;
            if (serverErrEx.getStatusNr() == 503) {
                return true;
            }
            if (serverErrEx.getStatusNr() == 500) {
                LOG.warn("Saw a HTTP 500 status. Not assuming this is a \"busy\" reply.");
            }
        }
        if (ex.getMessage() != null && ex.getMessage().toLowerCase().contains("busy")) {
            return true;
        }
        if (ex.getMessage() != null && ex.getMessage().toLowerCase().contains("503")) {
            return true;
        }
        if (ex instanceof XmlRpcException) {
            XmlRpcException xmlRpcEx = (XmlRpcException)ex;
            if (xmlRpcEx.code == 503) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XMLRPCCallDetails executeXmlRpcCommand(@Nonnull SfaConnection con, @Nonnull String command, @Nonnull List argv, @Nonnull Map<String, Object> methodParameters, boolean geni) throws JFedException {
        Date startTime = null;
        Date stopTime = null;
        int busyRetries = 0;
        int possibleTempErrorRetries = 0;
        int timeoutRetries = 0;
        try {
            boolean possibleTempError;
            boolean busy;
            boolean timeout;
            void var15_17;
            Exception e;
            Object rc;
            con.markInUse();
            boolean useNewConnection = false;
            while (true) {
                if (useNewConnection) {
                    if (!con.canDuplicate()) {
                        LOG.error("Should have retried with new connection, but the connection cannot create a new copy of itself. Will fall back to retry on same connection.");
                    } else {
                        JFedConnection newCon = con.getNewConnection();
                        if (newCon != null) {
                            con = (SfaConnection)newCon;
                        } else {
                            LOG.error("Should have retried with new connection, but the connection failed to create a new copy of itself. Will fall back to retry on same connection.");
                        }
                    }
                }
                useNewConnection = false;
                XmlRpcClient xmlRpcClient = con.getXmlRpcClient();
                this.lastHttpResult = null;
                this.lastXmlRpcResult = null;
                stopTime = null;
                rc = null;
                e = null;
                Object var15_18 = null;
                XmlRpcClient xmlRpcClient2 = xmlRpcClient;
                synchronized (xmlRpcClient2) {
                    try {
                        boolean useGeneralXmlRpcDetails;
                        startTime = new Date();
                        con.markCallTime();
                        con.logWillExecuteXmlRpc(command, argv);
                        rc = xmlRpcClient.execute(command, argv);
                        stopTime = new Date();
                        if (con != null && con.getXmlRpcTransportFactory() != null && con.getXmlRpcTransportFactory().getHttpResponseHeaders() != null) {
                            List<Header> responseHeaders = con.getXmlRpcTransportFactory().getRawHttpResponseHeaders();
                            for (Header h2 : responseHeaders) {
                                if (!h2.getName().equalsIgnoreCase("Keep-Alive")) continue;
                                String string = h2.getValue();
                                Matcher matcherTimeout = PATTERN_KEEP_ALIVE_TIMEOUT.matcher(string);
                                if (!matcherTimeout.find()) break;
                                String timeoutS = matcherTimeout.group(1);
                                try {
                                    long connectionExpireMs = (long)Integer.parseInt(timeoutS) * 1000L;
                                    con.reduceConnectionExpireMs(connectionExpireMs);
                                }
                                catch (NumberFormatException e1) {
                                    LOG.warn("Invalid timeout in HTTP header Keep-Alive: \"" + string + "\": \"" + timeoutS + "\"", e1);
                                }
                                break;
                            }
                        }
                        if (rc == null) {
                            useGeneralXmlRpcDetails = true;
                        } else if (rc.getClass().equals(XmlRpcException.class)) {
                            useGeneralXmlRpcDetails = true;
                        } else if (geni) {
                            if (!(rc instanceof HashMap)) throw new RuntimeException("Geni reply is not a Map! It is " + (String)(rc == null ? "null" : "a" + rc.getClass().getName()));
                            HashMap r = (HashMap)rc;
                            useGeneralXmlRpcDetails = false;
                            XMLRPCCallDetailsWithCodeValueError xMLRPCCallDetailsWithCodeValueError = new XMLRPCCallDetailsWithCodeValueError(con.getConnectionConfig(), con.getServerUrl(), con.getXmlRpcTransportFactory().getHttpRequestLine(), con.getXmlRpcTransportFactory().getHttpRequestHeaders(), con.getXmlRpcTransportFactory().getHttpSentHistory(), con.getXmlRpcTransportFactory().getHttpStatusLine(), con.getXmlRpcTransportFactory().getHttpResponseHeaders(), con.getXmlRpcTransportFactory().getHttpReceivedHistory(), argv, r, startTime, stopTime, null, con);
                        } else {
                            useGeneralXmlRpcDetails = true;
                        }
                        if (useGeneralXmlRpcDetails) {
                            XMLRPCCallDetailsGeneral xMLRPCCallDetailsGeneral = new XMLRPCCallDetailsGeneral(con.getConnectionConfig(), con.getServerUrl(), con.getXmlRpcTransportFactory().getHttpRequestLine(), con.getXmlRpcTransportFactory().getHttpRequestHeaders(), con.getXmlRpcTransportFactory().getHttpSentHistory(), con.getXmlRpcTransportFactory().getHttpStatusLine(), con.getXmlRpcTransportFactory().getHttpResponseHeaders(), con.getXmlRpcTransportFactory().getHttpReceivedHistory(), argv, rc, startTime, stopTime, null, con);
                        }
                    }
                    catch (Exception ex) {
                        e = ex;
                        stopTime = new Date();
                        HttpInfoXmlRpcTransportFactory fact = con == null ? null : con.getXmlRpcTransportFactory();
                        XMLRPCCallDetailsGeneral xMLRPCCallDetailsGeneral = new XMLRPCCallDetailsGeneral(con == null ? null : con.getConnectionConfig(), con == null ? null : con.getServerUrl(), fact == null ? null : fact.getHttpRequestLine(), fact == null ? null : fact.getHttpRequestHeaders(), fact == null ? null : fact.getHttpSentHistory(), fact == null ? null : fact.getHttpStatusLine(), fact == null ? null : fact.getHttpResponseHeaders(), fact == null ? null : fact.getHttpReceivedHistory(), argv, null, startTime, stopTime, e, con);
                    }
                }
                assert (var15_17 != null);
                boolean bl = timeout = AbstractApi.isTimeout(e) || this.isTimeout(rc, con);
                if (timeout) {
                    if (timeoutRetries++ >= this.retrySettings.getTimeoutMaxRetries()) {
                        Object extra = "";
                        if (timeoutRetries - 1 <= 0) throw new JFedTimeoutException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " threw timeout exception. " + (String)extra + "Possibly incorrect URL \"" + con.getServerUrl() + "\". Could also be connectivity problem.", (Throwable)e, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.SERVER_TIMEOUT_ERROR);
                        extra = "Already retried " + timeoutRetries + " times after timeout. ";
                        throw new JFedTimeoutException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " threw timeout exception. " + (String)extra + "Possibly incorrect URL \"" + con.getServerUrl() + "\". Could also be connectivity problem.", (Throwable)e, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.SERVER_TIMEOUT_ERROR);
                    }
                    this.log((XMLRPCCallDetails)var15_17, null, "javaMethodNameUnknownDueToTimeout", command, con, methodParameters);
                    LOG.info("Got read timeout (timeoutRetries=" + timeoutRetries + ") from server. Waiting " + this.retrySettings.getTimeoutMsBeforeRetry() + " milliseconds, and trying again...");
                    try {
                        Thread.sleep(this.retrySettings.getTimeoutMsBeforeRetry());
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("InterruptedException in wait after timeout. Possible reason: User interrupted wait?", ex);
                        throw new JFedException("Aborted waiting after timeout", (Throwable)ex, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
                    }
                    useNewConnection = true;
                    possibleTempErrorRetries = 0;
                    busyRetries = 0;
                    continue;
                }
                boolean bl2 = busy = this.isBusy(e) || this.isBusy(rc, con, (XMLRPCCallDetails)var15_17);
                if (busy) {
                    if (busyRetries++ >= this.retrySettings.getBusyMaxRetries()) {
                        LOG.warn("Received \"Busy\" reply from server. NOT waiting and retrying: busyRetries=" + busyRetries + " maxBusyCount=" + this.retrySettings.getBusyMaxRetries());
                        Object extra = "";
                        if (busyRetries - 1 <= 0) throw new JFedException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " received 'BUSY' reply" + (String)extra + ".", (XMLRPCCallDetails)var15_17, GeniAMResponseCode.GENIRESPONSE_BUSY);
                        extra = ", and already retried " + busyRetries + " times after busy (which is the maximum number)";
                        throw new JFedException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " received 'BUSY' reply" + (String)extra + ".", (XMLRPCCallDetails)var15_17, GeniAMResponseCode.GENIRESPONSE_BUSY);
                    }
                    this.log((XMLRPCCallDetails)var15_17, null, "javaMethodNameUnknownDueToBusy", command, con, methodParameters);
                    LOG.info("Received \"Busy\" reply from server. Waiting " + this.retrySettings.getBusyMsBeforeRetry() + " milliseconds, and trying again... busyRetries=" + busyRetries + " maxBusyCount=" + this.retrySettings.getBusyMaxRetries());
                    try {
                        Thread.sleep(this.retrySettings.getBusyMsBeforeRetry());
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("InterruptedException in wait after busy. Possible reason: User interrupted wait?", e);
                        throw new JFedException("Aborted waiting after busy", (Throwable)ex, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
                    }
                    useNewConnection = con.getDebugInfo() != null && con.getDebugInfo().getServerHasFlagWorkaroundMustReconnectEachCall() != null ? con.getDebugInfo().getServerHasFlagWorkaroundMustReconnectEachCall() : true;
                    possibleTempErrorRetries = 0;
                    timeoutRetries = 0;
                    continue;
                }
                boolean bl3 = possibleTempError = this.isPossibleTemporaryError(e) || this.isPossibleTemporaryError(rc, con, (XMLRPCCallDetails)var15_17);
                if (!possibleTempError) break;
                if (possibleTempErrorRetries++ >= this.retrySettings.getPossibleTemporaryErrorMaxRetries()) {
                    LOG.warn("Received \"Possible Temporary error\" reply from server. NOT waiting and retrying: possibleTempErrorRetries=" + possibleTempErrorRetries + " getPossibleTemporaryErrorMaxRetries()=" + this.retrySettings.getPossibleTemporaryErrorMaxRetries());
                    Object extra = "";
                    if (possibleTempErrorRetries - 1 <= 0) throw new JFedException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " received possible temporary error reply" + (String)extra + ".", (XMLRPCCallDetails)var15_17, GeniAMResponseCode.GENIRESPONSE_BUSY);
                    extra = ", and already retried " + possibleTempErrorRetries + " times after possibleTempError (which is the maximum number)";
                    throw new JFedException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " received possible temporary error reply" + (String)extra + ".", (XMLRPCCallDetails)var15_17, GeniAMResponseCode.GENIRESPONSE_BUSY);
                }
                this.log((XMLRPCCallDetails)var15_17, null, "javaMethodNameUnknownDueToPossibleTempError", command, con, methodParameters);
                LOG.info("Received possible temporary error from server. Waiting " + this.retrySettings.getPossibleTemporaryErrorMsBeforeRetry() + " milliseconds, and trying again... possibleTempErrorRetries=" + possibleTempErrorRetries + " maxPossibleTemporaryErrorCount=" + this.retrySettings.getPossibleTemporaryErrorMaxRetries());
                try {
                    Thread.sleep(this.retrySettings.getPossibleTemporaryErrorMsBeforeRetry());
                }
                catch (InterruptedException ex) {
                    LOG.warn("InterruptedException in wait after possibleTempError. Possible reason: User interrupted wait?", e);
                    throw new JFedException("Aborted waiting after possibleTempError", (Throwable)ex, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
                }
                useNewConnection = true;
                timeoutRetries = 0;
            }
            assert (!timeout);
            assert (!busy);
            assert (!possibleTempError);
            boolean possiblyIncorrectURL = false;
            if (e != null) {
                boolean bl;
                void var26_54;
                boolean bl4 = false;
                boolean sawHostnameAndCertificateMismatchSSLException = false;
                boolean sawXmlRpcException = false;
                boolean sawSocketException = false;
                boolean sawSocketClosedException = false;
                boolean sawHttpHostConnectException = false;
                Exception exception = e;
                while (var26_54 != null) {
                    if (var26_54 instanceof XmlRpcException) {
                        sawXmlRpcException = true;
                    }
                    if (var26_54 instanceof SocketException) {
                        sawSocketException = true;
                    }
                    if (var26_54 instanceof SocketException && var26_54.getMessage() != null && var26_54.getMessage().trim().equalsIgnoreCase("Socket is closed")) {
                        sawSocketClosedException = true;
                    }
                    if (var26_54 instanceof HttpHostConnectException) {
                        sawHttpHostConnectException = true;
                    }
                    if (var26_54 instanceof SSLException) {
                        bl = true;
                    }
                    if (var26_54 instanceof HostnameAndCertificateMismatchSSLException) {
                        sawHostnameAndCertificateMismatchSSLException = true;
                    }
                    Throwable throwable = var26_54.getCause();
                }
                possiblyIncorrectURL = sawSocketException && !sawSocketClosedException || sawHttpHostConnectException || !sawXmlRpcException && !bl && !sawHostnameAndCertificateMismatchSSLException;
                throw new JFedConnectivityException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " threw exception.(Con.ID=" + con.getConnectionId() + ") " + (String)(possiblyIncorrectURL ? " Is URL correct? \"" + con.getServerUrl() + "\"" : (sawHostnameAndCertificateMismatchSSLException ? "Server certificate did not match the server hostname. This error is typically caused by a (minor) server SSL misconfiguration combined with java's paranoid security. jFed can be configured to make java trust the SSL certificate despite of this (but is not configured that way for this server yet)." : "")), (Throwable)e, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
            }
            if (rc == null) {
                possiblyIncorrectURL = true;
                throw new JFedConnectivityException("XML RPC call for command \"" + command + "\" with argv size=" + argv.size() + " returned null." + (String)(possiblyIncorrectURL ? " Is URL correct? \"" + con.getServerUrl() + "\"" : ""), (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
            }
            if (rc.getClass().equals(XmlRpcException.class)) {
                XmlRpcException xmlRpcException = (XmlRpcException)rc;
                LOG.info("XmlRpc call returned XmlRpcException of class=" + xmlRpcException.getClass().getName() + " code=" + xmlRpcException.code + " msg=" + xmlRpcException.getMessage(), xmlRpcException);
                throw new JFedException("XML RPC call returned error: " + xmlRpcException.getMessage(), (Throwable)xmlRpcException, (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
            }
            if (geni && !(rc instanceof Map)) {
                throw new JFedException("XMLRPC execute result class unexpected. This API is expected to return a Map, containing the entries code, value and output. Instead, it returned: " + rc.getClass().getName(), (XMLRPCCallDetails)var15_17, GeniAMResponseCode.INTERNAL_NONGENI_ERROR);
            }
            this.lastHttpResult = var15_17;
            this.lastXmlRpcResult = var15_17;
            LOG.trace("AbstactAPI.executeXmlRpcCommand answer");
            void var20_42 = var15_17;
            return var20_42;
        }
        catch (Exception e) {
            LOG.debug("AbstactAPI.executeXmlRpcCommand exception: ", e);
            XMLRPCCallDetails res = !(e instanceof JFedException) || ((JFedException)e).getXmlRpcResult() == null ? (con.getXmlRpcTransportFactory() != null ? new XMLRPCCallDetailsGeneral(con.getConnectionConfig(), con.getServerUrl(), con.getXmlRpcTransportFactory().getHttpRequestLine(), con.getXmlRpcTransportFactory().getHttpRequestHeaders(), con.getXmlRpcTransportFactory().getHttpSentHistory(), con.getXmlRpcTransportFactory().getHttpStatusLine(), con.getXmlRpcTransportFactory().getHttpResponseHeaders(), con.getXmlRpcTransportFactory().getHttpReceivedHistory(), argv, null, startTime, stopTime, e, con) : new XMLRPCCallDetailsGeneral(con.getConnectionConfig(), con.getServerUrl(), null, null, null, null, null, null, argv, null, startTime, stopTime, e, con)) : ((JFedException)e).getXmlRpcResult();
            this.lastHttpResult = res;
            this.lastXmlRpcResult = res;
            this.log(res, new ApiCallReply<String>(){

                @Override
                @Nonnull
                public GeniAMResponseCode getGeniResponseCode() {
                    return GeniAMResponseCode.INTERNAL_NONGENI_ERROR;
                }

                @Override
                @Nullable
                public String getValue() {
                    return e.getMessage();
                }

                @Override
                @Nullable
                public String getOutput() {
                    return "CLIENT SIDE ERROR while executing command: " + e.getMessage() + "\n";
                }

                @Override
                @Nullable
                public Map getRawResult() {
                    return null;
                }

                @Override
                @Nullable
                public Object getRawValue() {
                    return this.getValue();
                }
            }, "javaMethodNameUnknownDueToError", command, con, methodParameters, e);
            con.markError();
            throw new JFedException("Exception in XML RPC call: " + e.getMessage(), (Throwable)e, res, GeniAMResponseCode.SERVER_REPLY_ERROR);
        }
        finally {
            con.markNotInUse();
            con.clearLastCallData();
        }
    }

    public static enum HttpVerb {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static class DefaultHttpCallDetails
    implements HttpCallDetails {
        private final ConnectionConfig connectionConfig;
        private final String serverUrl;
        private final String requestHttpRequestLine;
        private final String requestHttpHeaders;
        private final String requestHttpContent;
        private final StatusLine resultHttpStatusLine;
        private final String resultHttpHeaders;
        private final String resultHttpContent;
        private final Date startTime;
        private final Date stopTime;
        private final Throwable exception;
        private final JFedConnection connection;

        public DefaultHttpCallDetails(ConnectionConfig connectionConfig, String serverUrl, String requestHttpRequestLine, String requestHttpHeaders, HttpEntity requestHttpEntity, StatusLine resultHttpStatusLine, String resultHttpHeaders, String resultHttpContent, Date startTime, Date stopTime, Throwable exception, JFedConnection connection) {
            this.connectionConfig = connectionConfig;
            this.serverUrl = serverUrl;
            this.requestHttpRequestLine = requestHttpRequestLine;
            this.requestHttpHeaders = requestHttpHeaders;
            this.resultHttpStatusLine = resultHttpStatusLine;
            this.resultHttpHeaders = resultHttpHeaders;
            this.resultHttpContent = resultHttpContent;
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.exception = exception;
            this.connection = connection;
            if (requestHttpEntity != null) {
                String requestHttpContentHelper;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    requestHttpEntity.writeTo(baos);
                    baos.close();
                    requestHttpContentHelper = baos.toString("UTF-8");
                }
                catch (IOException e) {
                    LOG.warn("Error writing requestHttpEntity for logging.", e);
                    requestHttpContentHelper = null;
                }
                this.requestHttpContent = requestHttpContentHelper;
            } else {
                this.requestHttpContent = null;
            }
        }

        @Override
        public String getServerUrl() {
            return this.serverUrl;
        }

        @Override
        public ConnectionConfig getConnectionConfig() {
            return this.connectionConfig;
        }

        @Override
        public String getRequestHttpContent() {
            return this.requestHttpContent;
        }

        @Override
        public int getResultHttpStatusCode() {
            return this.resultHttpStatusLine == null ? -1 : this.resultHttpStatusLine.getStatusCode();
        }

        @Override
        public String getResultHttpStatusReasonPhrase() {
            return this.resultHttpStatusLine == null ? null : this.resultHttpStatusLine.getReasonPhrase();
        }

        @Override
        public String getRequestHttpHeaders() {
            return this.requestHttpHeaders;
        }

        @Override
        public String getRequestHttpRequestLine() {
            return this.requestHttpRequestLine;
        }

        @Override
        public String getResultHttpHeaders() {
            return this.resultHttpHeaders;
        }

        @Override
        public String getResultHttpStatusLine() {
            return this.resultHttpStatusLine == null ? null : this.resultHttpStatusLine.toString();
        }

        @Override
        public StatusLine getResultHttpStatusLineObject() {
            return this.resultHttpStatusLine;
        }

        @Override
        public String getResultHttpContent() {
            return this.resultHttpContent;
        }

        @Override
        public Date getStartTime() {
            return this.startTime;
        }

        @Override
        public Date getStopTime() {
            return this.stopTime;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public JFedConnection getLastConnection() {
            return this.connection;
        }
    }

    protected static class CompressedStringConverter
    implements ReplyConverter<String> {
        private final Boolean compressed;

        public CompressedStringConverter(Boolean compressed) {
            this.compressed = compressed;
        }

        @Override
        public String convertXMLRPCCall(Object resultValueObject) throws BadReplyGeniException {
            if (resultValueObject instanceof String) {
                String resultValueString = (String)resultValueObject;
                if (resultValueString.trim().isEmpty()) {
                    return null;
                }
                if (Objects.equals(Boolean.TRUE, this.compressed)) {
                    return DataConversionUtils.decompressFromBase64(resultValueString);
                }
                return resultValueString;
            }
            return null;
        }
    }
}

