/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.util.library.DataConversionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gid {
    private static final Logger LOG = LoggerFactory.getLogger(Gid.class);
    private String encodedContent;
    private byte[] decodedContent;
    private X509Certificate certificate;
    private String subjectUuid;
    private String subjectUrn;
    private String subjectEmail;
    private static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public Gid(Gid o) {
        this(o.getEncodedContent());
    }

    public Gid(String content) {
        if (content.startsWith(CERT_HEAD)) {
            int endIndex = content.indexOf(CERT_TAIL);
            if (endIndex < 0) {
                LOG.warn("Gid got a certificate with a begin but without end: " + content);
                return;
            }
            assert (endIndex > CERT_HEAD.length());
            content = content.substring(CERT_HEAD.length(), endIndex);
        }
        this.encodedContent = content;
        this.decodedContent = DataConversionUtils.decodeBase64(content);
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.decodedContent);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.certificate = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
        }
        catch (Exception e) {
            LOG.warn("Error reading X509Certificate: " + e.getMessage(), e);
            this.certificate = null;
        }
        if (this.certificate != null) {
            try {
                if (this.certificate.getSubjectAlternativeNames() != null) {
                    for (List<?> l : this.certificate.getSubjectAlternativeNames()) {
                        if (l.size() == 2 && l.get(0) instanceof Integer) {
                            Integer nameType = (Integer)l.get(0);
                            Object name = l.get(1);
                            if (nameType != 6 || !(name instanceof String)) continue;
                            String uri = (String)name;
                            if (uri.startsWith("urn:uuid:")) {
                                this.subjectUuid = uri.substring("urn:uuid:".length());
                            }
                            if (uri.startsWith("urn:publicid:IDN")) {
                                this.subjectUrn = uri;
                            }
                            if (!uri.startsWith("email:")) continue;
                            this.subjectEmail = uri.substring("email:".length());
                            continue;
                        }
                        LOG.warn("Weird subject alt name: " + l);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error processing X509Certificate", e);
            }
        }
    }

    public String getEncodedContent() {
        return this.encodedContent;
    }

    public String getFullPemCertificate() {
        return "-----BEGIN CERTIFICATE-----\n" + this.encodedContent + "\n-----END CERTIFICATE-----\n";
    }

    public byte[] getDecodedContent() {
        return this.decodedContent;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean hasError() {
        return this.certificate == null;
    }

    public String getSubjectUuid() {
        return this.subjectUuid;
    }

    public String getSubjectUrn() {
        return this.subjectUrn;
    }

    public String getSubjectEmail() {
        return this.subjectEmail;
    }

    public String toString() {
        if (this.certificate != null) {
            return "X.509 certificate for " + this.certificate.getSubjectDN().toString();
        }
        return "Certificate with read error: " + this.encodedContent.substring(0, 20) + "...";
    }
}

