/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasicSshKeyInfo
implements SshFilesKeyInfo {
    private final PublicKey sshPublicKey;
    private final PrivateKey sshPrivateKey;

    BasicSshKeyInfo(@Nonnull PublicKey sshPublicKey, @Nonnull PrivateKey sshPrivateKey) {
        this.sshPublicKey = sshPublicKey;
        this.sshPrivateKey = sshPrivateKey;
    }

    BasicSshKeyInfo(@Nonnull KeyPair keyPair) {
        this.sshPublicKey = keyPair.getPublic();
        this.sshPrivateKey = keyPair.getPrivate();
    }

    @Override
    public boolean canReturnLockedPrivateKeyFile() {
        return true;
    }

    @Override
    public TmpFile getPrivateKeyFile() {
        return this.getUnencryptedPrivateKeyFile();
    }

    @Override
    public TmpFile getUnencryptedPrivateKeyFile() {
        String pemKey = new String(KeyUtil.privateKeyToAnyPem(this.sshPrivateKey));
        return new TmpContentFile("sskKeyBasUE", "pem", pemKey, true);
    }

    @Override
    public boolean hasUnencryptedPrivateKey() {
        return this.sshPrivateKey != null;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean unlock(char[] password) {
        throw new IllegalStateException("BasicSshKeyInfo does not supported locked private keys");
    }

    @Override
    @Nonnull
    public PublicKey getPublicKey() {
        return this.sshPublicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.sshPrivateKey;
    }

    @Override
    @Nullable
    public String getComment() {
        return null;
    }
}

