/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StitchingHopData {
    private final Logger log;
    private final String linkName;
    private final String hopUrn;
    private final String aggregateUrn;
    private final String aggregateUrl;
    private final Boolean importVlans;
    private Element hopElement;
    private Element scSpecificInfo_L2scEl;
    private String hopElId;
    private StitchingExtensionSource stitchingExtensionSource;
    private String scsVlanRangeAvailability;
    private String scsSuggestedVLANRange;
    private String lastManifestVlanRangeAvailability;
    private String lastManifestSuggestedVLANRange;
    private String advertisementVlanRangeAvailability;
    private final Set<Integer> unavailableVlans = new HashSet<Integer>();
    private Integer suggestedVlan;
    private final List<Map> rawDependencies = new ArrayList<Map>();
    private final List<StitchingHopData> dependencies = new ArrayList<StitchingHopData>();
    private final List<StitchingHopData> dependingOnThis = new ArrayList<StitchingHopData>();

    public StitchingHopData(String linkName, Map<String, Object> workflowData, Element stitchingElement, Logger log) throws BadReplyGeniException {
        this.log = log == null ? LoggerFactory.getLogger(StitchingHopData.class) : log;
        this.linkName = linkName;
        this.hopUrn = AbstractApi.apiSpecifiesStringInMap(workflowData, "hop_urn");
        assert (this.hopUrn != null);
        this.aggregateUrn = AbstractApi.apiSpecifiesStringInMap(workflowData, "aggregate_urn");
        this.aggregateUrl = AbstractApi.apiSpecifiesStringInMap(workflowData, "aggregate_url");
        this.importVlans = AbstractApi.apiSpecifiesBoolean(workflowData.get("import_vlans"));
        if (workflowData.get("dependencies") != null) {
            List<Map> dependenciesList = AbstractApi.apiSpecifiesListOfT(Map.class, workflowData.get("dependencies"));
            for (Map o : dependenciesList) {
                this.rawDependencies.add(o);
            }
        }
        this.stitchingExtensionSource = StitchingExtensionSource.SCS_REQUEST;
        this.processRspecElement(stitchingElement, this.stitchingExtensionSource);
        assert (this.hopElement != null);
    }

    public void processExtraWorkflowData(String linkName, Map<String, Object> workflowData) throws BadReplyGeniException {
        assert (Objects.equals(this.linkName, linkName));
        String otherHopUrn = AbstractApi.apiSpecifiesStringInMap(workflowData, "hop_urn");
        assert (otherHopUrn != null);
        assert (Objects.equals(otherHopUrn, this.hopUrn));
        String otherAggregateUrn = AbstractApi.apiSpecifiesStringInMap(workflowData, "aggregate_urn");
        String otherAggregateUrl = AbstractApi.apiSpecifiesStringInMap(workflowData, "aggregate_url");
        Boolean otherImportVlans = AbstractApi.apiSpecifiesBoolean(workflowData.get("import_vlans"));
        assert (Objects.equals(otherAggregateUrn, this.aggregateUrn));
        assert (Objects.equals(otherAggregateUrl, this.aggregateUrl));
        assert (Objects.equals(otherImportVlans, this.importVlans));
        assert (workflowData.get("dependencies") == null);
    }

    public void linkDeps(Collection<StitchingHopData> allData) throws BadReplyGeniException {
        for (Map workflowData : this.rawDependencies) {
            String depHopUrn = AbstractApi.apiSpecifiesStringInMap(workflowData, "hop_urn");
            for (StitchingHopData other : allData) {
                if (!Objects.equals(other.hopUrn, depHopUrn) || !Objects.equals(other.linkName, this.linkName) || this.dependencies.contains(other)) continue;
                this.dependencies.add(other);
                other.dependingOnThis.add(this);
            }
        }
    }

    void exogeniBugWorkAround_registerManifestVlan(int vlan) {
        assert (this.hopElement != null) : "There was no scs hop element";
        this.stitchingExtensionSource = StitchingExtensionSource.MANIFEST;
        this.lastManifestVlanRangeAvailability = "" + vlan;
        this.lastManifestSuggestedVLANRange = "" + vlan;
    }

    void overwriteWithManifestRspec(String manifestRspec, Element stitchingElement) {
        assert (stitchingElement != null);
        this.hopElement = null;
        this.stitchingExtensionSource = StitchingExtensionSource.MANIFEST;
        this.processRspecElement(stitchingElement, StitchingExtensionSource.MANIFEST);
        assert (this.hopElement != null);
    }

    @Deprecated
    boolean isSameAs(String otherManifestRspec) {
        assert (this.hopElement != null);
        Element otherStitchingElement = StitchingData.extractStitchingElementFromRspec(otherManifestRspec, this.log);
        List<Element> otherPathEls = XmlUtil.getDomElementChildElementsNS(otherStitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "path");
        for (Element otherPathEl : otherPathEls) {
            String otherLinkId = otherPathEl.getAttribute("id");
            assert (otherLinkId != null) : "<stitching> has <path> element without id attribute: " + otherPathEl;
            if (!Objects.equals(otherLinkId, this.linkName)) continue;
            NodeList hopList = otherPathEl.getElementsByTagNameNS("http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "hop");
            for (int i = 0; i < hopList.getLength(); ++i) {
                Node otherHopNode = hopList.item(i);
                assert (otherHopNode != null);
                assert (otherHopNode.getNodeType() == 1);
                Element otherHopElement = (Element)otherHopNode;
                Element otherLinkEl = XmlUtil.getDomElementFirstChildElementNS(otherHopElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "link");
                String otherLinkIdUrn = otherLinkEl.getAttribute("id");
                if (!Objects.equals(otherLinkIdUrn, this.hopUrn)) continue;
                Element otherScDescriptorEl = XmlUtil.getDomElementFirstChildElementNS(otherLinkEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilityDescriptor");
                Element otherScSpecificInfoEl = XmlUtil.getDomElementFirstChildElementNS(otherScDescriptorEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilitySpecificInfo");
                Element otherScSpecificInfo_L2scEl = XmlUtil.getDomElementFirstChildElementNS(otherScSpecificInfoEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilitySpecificInfo_L2sc");
                Element otherVlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElementNS(otherScSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "vlanRangeAvailability");
                Element otherSuggestedVLANRangeEl = XmlUtil.getDomElementFirstChildElementNS(otherScSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "suggestedVLANRange");
                String otherHopElId = otherHopElement.getAttribute("id");
                String otherManifestVlanRangeAvailability = otherVlanRangeAvailabilityEl.getTextContent();
                String otherManifestSuggestedVLANRange = otherSuggestedVLANRangeEl.getTextContent();
                if (!otherHopElId.trim().equalsIgnoreCase(this.hopElId.trim())) {
                    this.log.debug("isSameAs()=false because otherHopElId=" + otherHopElId + " hopElId=" + this.hopElId);
                    return false;
                }
                if (!otherManifestVlanRangeAvailability.trim().equalsIgnoreCase(this.lastManifestVlanRangeAvailability.trim())) {
                    this.log.debug("isSameAs()=false because otherManifestVlanRangeAvailability=" + otherManifestVlanRangeAvailability + " lastManifestVlanRangeAvailability=" + this.lastManifestVlanRangeAvailability);
                    return false;
                }
                if (!otherManifestSuggestedVLANRange.trim().equalsIgnoreCase(this.lastManifestSuggestedVLANRange.trim())) {
                    this.log.debug("isSameAs()=false because otherManifestSuggestedVLANRange=" + otherManifestSuggestedVLANRange + " lastManifestSuggestedVLANRange=" + this.lastManifestSuggestedVLANRange);
                    return false;
                }
                this.log.debug("isSameAs()=true because suggested and available match");
                return true;
            }
        }
        this.log.debug("isSameAs()=false because no matching hopEl found in new manifest");
        return false;
    }

    void processAdvertismentInfo(String advertisementVlanRangeAvailability) {
        this.advertisementVlanRangeAvailability = advertisementVlanRangeAvailability;
    }

    void processRspecElement(Element stitchingElement, StitchingExtensionSource stitchingExtensionSource) {
        assert (stitchingElement != null);
        assert (this.hopElement == null) : "Bug: clear this.hopElement before calling to acknowledge overwrite";
        List<Element> pathEls = XmlUtil.getDomElementChildElementsNS(stitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "path");
        for (Element pathEl : pathEls) {
            String linkId = pathEl.getAttribute("id");
            assert (linkId != null) : "<stitching> has <path> element without id attribute: " + pathEl;
            if (!Objects.equals(linkId, this.linkName)) continue;
            NodeList hopList = pathEl.getElementsByTagNameNS("http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "hop");
            for (int i = 0; i < hopList.getLength(); ++i) {
                Node hopNode = hopList.item(i);
                assert (hopNode != null);
                assert (hopNode.getNodeType() == 1);
                Element hopElement = (Element)hopNode;
                Element linkEl = XmlUtil.getDomElementFirstChildElementNS(hopElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "link");
                String linkIdUrn = linkEl.getAttribute("id");
                if (!Objects.equals(linkIdUrn, this.hopUrn)) continue;
                assert (this.hopElement == null) : "Found multiple <link> in rspec matching path id=\"" + this.linkName + "\"  hop urn=\"" + this.hopUrn + "\"";
                Element scDescriptorEl = XmlUtil.getDomElementFirstChildElementNS(linkEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilityDescriptor");
                Element scSpecificInfoEl = XmlUtil.getDomElementFirstChildElementNS(scDescriptorEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilitySpecificInfo");
                this.scSpecificInfo_L2scEl = XmlUtil.getDomElementFirstChildElementNS(scSpecificInfoEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "switchingCapabilitySpecificInfo_L2sc");
                Element vlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "vlanRangeAvailability");
                Element suggestedVLANRangeEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "suggestedVLANRange");
                this.hopElId = hopElement.getAttribute("id");
                if (stitchingExtensionSource == StitchingExtensionSource.SCS_REQUEST) {
                    this.scsVlanRangeAvailability = vlanRangeAvailabilityEl.getTextContent();
                    this.scsSuggestedVLANRange = suggestedVLANRangeEl.getTextContent();
                }
                if (stitchingExtensionSource == StitchingExtensionSource.MANIFEST) {
                    this.lastManifestVlanRangeAvailability = vlanRangeAvailabilityEl.getTextContent();
                    this.lastManifestSuggestedVLANRange = suggestedVLANRangeEl.getTextContent();
                }
                this.hopElement = hopElement;
            }
        }
        assert (this.hopElement != null) : "Found NO <link> in rspec matching path id=\"" + this.linkName + "\"  hop urn=\"" + this.hopUrn + "\"";
    }

    public Integer updateSuggestedVlan(Set<Integer> unavailableVlans, Integer newSuggestedVlan) {
        this.log.trace("updateSuggestedVlan({}, {})", (Object)this.getHopUrn(), (Object)unavailableVlans);
        this.unavailableVlans.addAll(unavailableVlans);
        VlanRange availableVlans = this.getAvailableVlans();
        assert (Collections.disjoint(unavailableVlans, availableVlans));
        if (availableVlans.isEmpty()) {
            this.suggestedVlan = null;
            return null;
        }
        if (newSuggestedVlan != null) {
            if (unavailableVlans.contains(newSuggestedVlan)) {
                this.log.warn("updateSuggestedVlan(unavailableVlans=" + unavailableVlans + ", newSuggestedVlan=" + newSuggestedVlan + ") called with newSuggestedVlan element of unavailableVlans");
                return null;
            }
            if (this.unavailableVlans.contains(newSuggestedVlan)) {
                this.log.warn("updateSuggestedVlan(unavailableVlans=" + unavailableVlans + ", newSuggestedVlan=" + newSuggestedVlan + ") this.unavailableVlans=" + this.unavailableVlans + " called with newSuggestedVlan element of this.unavailableVlans");
                return null;
            }
            this.suggestedVlan = newSuggestedVlan;
        }
        Integer res = this.getSuggestedVlan();
        assert (Collections.disjoint(unavailableVlans, availableVlans));
        assert (!unavailableVlans.contains(res));
        assert (!this.unavailableVlans.contains(res));
        this.log.debug("Chose vlan " + res);
        return res;
    }

    public List<StitchingHopData> getDependencies() {
        return this.dependencies;
    }

    public List<StitchingHopData> getDependingOnThis() {
        return this.dependingOnThis;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getHopUrn() {
        return this.hopUrn;
    }

    public String getAggregateUrn() {
        return this.aggregateUrn;
    }

    public String getAggregateUrl() {
        return this.aggregateUrl;
    }

    public Boolean getImportVlans() {
        return this.importVlans;
    }

    public Set<Integer> getUnavailableVlans() {
        return Collections.unmodifiableSet(this.unavailableVlans);
    }

    public VlanRange getAvailableVlans() {
        assert (this.unavailableVlans != null);
        VlanRange availableVlans = null;
        if (this.advertisementVlanRangeAvailability != null) {
            availableVlans = new VlanRange(this.advertisementVlanRangeAvailability);
        }
        if (availableVlans == null && this.scsVlanRangeAvailability != null) {
            availableVlans = new VlanRange(this.scsVlanRangeAvailability);
        }
        if (availableVlans == null && this.lastManifestVlanRangeAvailability != null) {
            assert (false) : "This should not occur";
            availableVlans = new VlanRange(this.lastManifestVlanRangeAvailability);
            this.log.warn("Using manifest VLAN data. This is not ever a good source, something must be wrong with the SCS data?");
        }
        if (availableVlans == null) {
            throw new RuntimeException("No data on available VLANs known");
        }
        availableVlans.removeAll(this.unavailableVlans);
        VlanRange availableVlansWithDepends = new VlanRange(availableVlans);
        assert (Objects.equals(availableVlans, availableVlansWithDepends)) : "availableVlans=" + availableVlans + " availableVlansWithDepends=" + availableVlansWithDepends;
        assert (Collections.disjoint(this.unavailableVlans, availableVlans));
        assert (Collections.disjoint(this.unavailableVlans, availableVlansWithDepends));
        assert (Objects.equals(availableVlans, availableVlansWithDepends));
        for (StitchingHopData dep : this.dependingOnThis) {
            availableVlansWithDepends.retainAll(dep.getAvailableVlans());
            assert (Collections.disjoint(this.unavailableVlans, availableVlansWithDepends));
        }
        if (!availableVlansWithDepends.isEmpty()) {
            assert (Collections.disjoint(this.unavailableVlans, availableVlansWithDepends));
            return availableVlansWithDepends;
        }
        this.log.warn("Combined with hops depending on this, there are no available VLANs: will ignore hops depending on this so we can try anyway.");
        assert (Collections.disjoint(this.unavailableVlans, availableVlans));
        return availableVlans;
    }

    public String getAvailableVlansString() {
        return this.getAvailableVlans().toString();
    }

    public Integer getSuggestedVlan() {
        VlanRange availableVlans = this.getAvailableVlans();
        if (availableVlans.isEmpty()) {
            return null;
        }
        if (this.suggestedVlan != null && availableVlans.contains(this.suggestedVlan)) {
            return this.suggestedVlan;
        }
        Integer scsSuggested = null;
        if (this.scsSuggestedVLANRange != null) {
            try {
                scsSuggested = Integer.parseInt(this.scsSuggestedVLANRange);
            }
            catch (NumberFormatException e) {
                this.log.warn("suggested vlan in stitching rspec extension is not a number: \"" + this.scsSuggestedVLANRange + "\"", e);
                scsSuggested = null;
            }
        }
        Integer lastManifestSuggested = null;
        if (this.lastManifestSuggestedVLANRange != null) {
            try {
                lastManifestSuggested = Integer.parseInt(this.lastManifestSuggestedVLANRange);
            }
            catch (NumberFormatException e) {
                this.log.warn("suggested vlan in stitching rspec extension is not a number: \"" + this.lastManifestSuggestedVLANRange + "\"", e);
                lastManifestSuggested = null;
            }
        }
        if (scsSuggested != null && !availableVlans.contains(scsSuggested)) {
            scsSuggested = null;
        }
        if (lastManifestSuggested != null && !availableVlans.contains(lastManifestSuggested)) {
            lastManifestSuggested = null;
        }
        if (lastManifestSuggested != null) {
            return lastManifestSuggested;
        }
        if (scsSuggested != null) {
            return scsSuggested;
        }
        return availableVlans.iterator().next();
    }

    public Integer getLastManifestVlan() {
        Object lastManifestSuggested = null;
        if (this.lastManifestSuggestedVLANRange != null) {
            try {
                return Integer.parseInt(this.lastManifestSuggestedVLANRange);
            }
            catch (NumberFormatException e) {
                this.log.warn("suggested vlan in stitching rspec extension is not a number: \"" + this.lastManifestSuggestedVLANRange + "\"", e);
            }
        }
        return null;
    }

    public String getRspecStitchingHopId() {
        return this.hopElId;
    }

    public Element getRspecStitchingHopElement(boolean useAny) {
        Element vlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "vlanRangeAvailability");
        Element suggestedVLANRangeEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "suggestedVLANRange");
        vlanRangeAvailabilityEl.setTextContent(this.getAvailableVlans().toString());
        if (useAny) {
            suggestedVLANRangeEl.setTextContent("any");
        } else {
            suggestedVLANRangeEl.setTextContent("" + this.getSuggestedVlan());
        }
        assert (this.hopElement != null);
        return this.hopElement;
    }

    public Element getRspecStitchingHopElement(String overwriteVlanRangeAvailability, String overwriteSuggestedVLANRange) {
        assert (overwriteVlanRangeAvailability != null);
        assert (overwriteSuggestedVLANRange != null);
        Element vlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "vlanRangeAvailability");
        Element suggestedVLANRangeEl = XmlUtil.getDomElementFirstChildElementNS(this.scSpecificInfo_L2scEl, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "suggestedVLANRange");
        vlanRangeAvailabilityEl.setTextContent(overwriteVlanRangeAvailability);
        suggestedVLANRangeEl.setTextContent(overwriteSuggestedVLANRange);
        assert (this.hopElement != null);
        return this.hopElement;
    }

    public StitchingExtensionSource getStitchingExtensionSource() {
        return this.stitchingExtensionSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StitchingHopData that = (StitchingHopData)o;
        if (!Objects.equals(this.hopUrn, that.hopUrn)) {
            return false;
        }
        return Objects.equals(this.linkName, that.linkName);
    }

    public int hashCode() {
        int result = this.linkName.hashCode();
        result = 31 * result + this.hopUrn.hashCode();
        return result;
    }

    public String toString() {
        List depUrns = this.dependencies.stream().map(stitchingHopData -> stitchingHopData.linkName + " " + stitchingHopData.getHopUrn()).collect(Collectors.toList());
        Object res = "\"StitchingHopData\" : {\n";
        res = StitchingHopData.toStringHelper((String)res, "linkName", this.linkName);
        res = StitchingHopData.toStringHelper((String)res, "hopUrn", this.hopUrn);
        res = StitchingHopData.toStringHelper((String)res, "aggregateUrn", this.aggregateUrn);
        res = StitchingHopData.toStringHelper((String)res, "aggregateUrl", this.aggregateUrl);
        res = StitchingHopData.toStringHelper((String)res, "importVlans", this.importVlans);
        res = StitchingHopData.toStringHelper((String)res, "getAvailableVlans()", this.getAvailableVlans());
        res = StitchingHopData.toStringHelper((String)res, "getSuggestedVlan()", this.getSuggestedVlan());
        res = StitchingHopData.toStringHelper((String)res, "dependencies (link+urn)", depUrns);
        res = (String)res + "}\n";
        return res;
    }

    private static String toStringHelper(String res, String objectName, Object objectValue) {
        if (objectValue == null) {
            return res;
        }
        return res + TextUtil.indent(4, "\"" + objectName + "\" : \"" + objectValue + "\"") + "\n";
    }

    public static enum StitchingExtensionSource {
        SCS_REQUEST,
        MANIFEST;

    }
}

