/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.testbed_info;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.PlanetlabSfaRegistryInterface;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniClearingHouse1;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ApiInfo.class);
    private static final Map<String, ApiName> apiByExactId = new HashMap<String, ApiName>();
    private static final Map<String, ApiName> apiByForgivingId = new HashMap<String, ApiName>();

    private static String normalizeId(String id) {
        return id.toLowerCase().replaceAll("[^A-Za-z0-9]", "");
    }

    public static ApiName getByExactId(String id) {
        return apiByExactId.get(id);
    }

    public static ApiName findById(String id) {
        assert (id != null);
        assert (!id.isEmpty());
        String normalizedId = ApiInfo.normalizeId(id);
        assert (!normalizedId.isEmpty());
        return apiByForgivingId.get(normalizedId);
    }

    public static Api classToApi(Class targetClass) {
        if (Objects.equals(targetClass, AggregateManager3.class)) {
            return new Api(ApiName.GENI_AM, 3);
        }
        if (Objects.equals(targetClass, AggregateManager2.class)) {
            return new Api(ApiName.GENI_AM, 2);
        }
        if (Objects.equals(targetClass, ProtogeniSliceAuthority.class)) {
            return new Api(ApiName.PROTOGENI_SA, 1);
        }
        if (Objects.equals(targetClass, ProtoGeniClearingHouse1.class)) {
            return new Api(ApiName.PROTOGENI_CH, 1);
        }
        if (Objects.equals(targetClass, PlanetlabSfaRegistryInterface.class)) {
            return new Api(ApiName.PLANETLAB_SLICE_REGISTRY, 1);
        }
        if (Objects.equals(targetClass, StitchingComputationService.class)) {
            return new Api(ApiName.GENI_SCS, 1);
        }
        if (Objects.equals(targetClass, FederationRegistryApi1.class)) {
            return new Api(ApiName.GENI_CH, 1);
        }
        if (Objects.equals(targetClass, FederationMemberAuthorityApi1.class)) {
            return new Api(ApiName.GENI_CH_MA, 1);
        }
        if (Objects.equals(targetClass, FederationSliceAuthorityApi1.class)) {
            return new Api(ApiName.GENI_CH_SA, 1);
        }
        if (Objects.equals(targetClass, FederationRegistryApi2.class)) {
            return new Api(ApiName.GENI_CH, 2);
        }
        if (Objects.equals(targetClass, FederationMemberAuthorityApi2.class)) {
            return new Api(ApiName.GENI_CH_MA, 2);
        }
        if (Objects.equals(targetClass, FederationSliceAuthorityApi2.class)) {
            return new Api(ApiName.GENI_CH_SA, 2);
        }
        if (Objects.equals(targetClass, SlaCollector.class)) {
            return new Api(ApiName.FED4FIRE_SLA_COLLECTOR, 1);
        }
        return null;
    }

    public static String findUrlString(Server server, ApiName apiName, int version) {
        assert (apiName != null);
        return ApiInfo.findUrlString(server, new Api(apiName, version));
    }

    public static String findUrlString(Server server, ApiName apiName, String version) {
        assert (apiName != null);
        assert (version != null);
        return ApiInfo.findUrlString(server, new Api(apiName, version));
    }

    public static String findUrlString(Server server, Api api) {
        assert (server != null);
        Service service = ApiInfo.findService(server, api);
        if (service == null) {
            return null;
        }
        return service.getUrl();
    }

    public static URL findUrl(Server server, ApiName apiName, int version) {
        assert (apiName != null);
        return ApiInfo.findUrl(server, new Api(apiName, version));
    }

    public static URL findUrl(Server server, ApiName apiName, String version) {
        assert (apiName != null);
        assert (version != null);
        return ApiInfo.findUrl(server, new Api(apiName, version));
    }

    public static URL findUrl(Server server, Api api) {
        assert (server != null);
        String urlString = ApiInfo.findUrlString(server, api);
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error("Invalid URL in Testbed config. server.id=" + server.getId() + " url=\"" + urlString + "\"", e);
            return null;
        }
    }

    public static Service findService(Server server, ApiName apiName, int version) {
        assert (apiName != null);
        return ApiInfo.findService(server, new Api(apiName, version));
    }

    public static Service findService(Server server, ApiName apiName, String version) {
        assert (apiName != null);
        assert (version != null);
        return ApiInfo.findService(server, new Api(apiName, version));
    }

    public static Service findService(Server server, Api api) {
        assert (server != null);
        if (server.getServices() == null || server.getServices().isEmpty()) {
            return null;
        }
        for (Service service : server.getServices()) {
            if (!api.matches(service)) continue;
            return service;
        }
        return null;
    }

    public static boolean hasUrl(Server server, URL url) {
        return ApiInfo.hasUrl(server, url.toExternalForm());
    }

    public static boolean hasUrl(Server server, String urlString) {
        for (Service service : server.getServices()) {
            if (!Objects.equals(urlString, service.getUrl())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUrl(Service service, URL url) {
        return Objects.equals(url.toExternalForm(), service.getUrl());
    }

    public static boolean hasUrl(Service service, String urlString) {
        return Objects.equals(urlString, service.getUrl());
    }

    public static boolean hasService(Server server, ApiName apiName, int version) {
        assert (apiName != null);
        return ApiInfo.hasService(server, new Api(apiName, version));
    }

    public static boolean hasService(Server server, ApiName apiName, String version) {
        assert (apiName != null);
        assert (version != null);
        return ApiInfo.hasService(server, new Api(apiName, version));
    }

    public static boolean hasService(Server server, Api api) {
        assert (server != null);
        if (server.getServices() == null || server.getServices().isEmpty()) {
            return false;
        }
        for (Service service : server.getServices()) {
            if (!api.matches(service)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasService(Server server, ApiName apiName) {
        assert (server != null);
        if (server.getServices() == null || server.getServices().isEmpty()) {
            return false;
        }
        for (Service service : server.getServices()) {
            if (!apiName.matchesId(service.getApi())) continue;
            return true;
        }
        return false;
    }

    public static List<GeniUrn> getDefaultComponentManagerForEach(Server server) {
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        res.add(server.getDefaultComponentManagerAsGeniUrn());
        return res;
    }

    public static List<GeniUrn> getDefaultComponentManagerForEach(Server ... servers) {
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        for (Server auth : servers) {
            res.add(auth.getDefaultComponentManagerAsGeniUrn());
        }
        return res;
    }

    public static List<GeniUrn> getDefaultComponentManagerForEach(List<Server> servers) {
        return servers.stream().map(Server::getDefaultComponentManagerAsGeniUrn).collect(Collectors.toList());
    }

    static {
        for (ApiName api : ApiName.values()) {
            apiByExactId.put(api.getId(), api);
            apiByForgivingId.put(api.getNormalizedId(), api);
        }
        apiByForgivingId.put("am", ApiName.GENI_AM);
        apiByForgivingId.put("scs", ApiName.GENI_SCS);
        apiByForgivingId.put("reputationservice", ApiName.FED4FIRE_REPUTATION_SERVICE);
        apiByForgivingId.put("reservationcalendarpage", ApiName.FED4FIRE_RESERVATION_CALENDER_PAGE);
        apiByForgivingId.put("slacollector", ApiName.FED4FIRE_SLA_COLLECTOR);
        apiByForgivingId.put("planetlabsr", ApiName.PLANETLAB_SLICE_REGISTRY);
    }

    public static enum ApiName {
        PLANETLAB_SLICE_REGISTRY("PlanetLab.SliceRegistry"),
        PROTOGENI_SA("ProtoGeni.SA"),
        PROTOGENI_CH("ProtoGeni.CH"),
        GENI_AM("Geni.AM"),
        GENI_CH("Geni.CH"),
        GENI_CH_SA("Geni.SA"),
        GENI_CH_MA("Geni.MA"),
        GENI_SCS("Geni.SCS"),
        FED4FIRE_FEDMON("Fed4Fire.Fedmon", ConnectionConfig.Authentication.NONE, ConnectionConfig.Type.HTTP),
        FED4FIRE_RESERVATION_CALENDER_PAGE("Fed4Fire.ReservationCalendarPage", ConnectionConfig.Authentication.SSL_CLIENT_AUTH, ConnectionConfig.Type.HTTP),
        FED4FIRE_SLA_COLLECTOR("Fed4Fire.SlaCollector", ConnectionConfig.Authentication.HTTP_BASIC, ConnectionConfig.Type.HTTP),
        FED4FIRE_REPUTATION_SERVICE("Fed4Fire.ReputationService", ConnectionConfig.Authentication.NONE, ConnectionConfig.Type.HTTP),
        GENERIC_HTTPS_CLIENTAUTH("Generic.Https+ClientAuth", ConnectionConfig.Authentication.SSL_CLIENT_AUTH, ConnectionConfig.Type.HTTP);

        private final String id;
        private final ConnectionConfig.Authentication authentication;
        private final ConnectionConfig.Type connectionType;

        private ApiName(@Nonnull String id, ConnectionConfig.Authentication authentication, ConnectionConfig.Type connectionType) {
            this.id = id;
            this.authentication = authentication;
            this.connectionType = connectionType;
        }

        private ApiName(String id) {
            this.id = id;
            this.authentication = ConnectionConfig.Authentication.SSL_CLIENT_AUTH;
            this.connectionType = ConnectionConfig.Type.SFA;
        }

        public String getId() {
            return this.id;
        }

        String getNormalizedId() {
            return ApiInfo.normalizeId(this.id);
        }

        public boolean matchesId(String id) {
            return Objects.equals(ApiInfo.normalizeId(this.id), ApiInfo.normalizeId(id));
        }

        public ConnectionConfig.Authentication getAuthentication() {
            return this.authentication;
        }

        public ConnectionConfig.Type getConnectionType() {
            return this.connectionType;
        }
    }

    public static class Api {
        private final ApiName name;
        private final String version;

        public Api(@Nonnull ApiName name, @Nonnull String version) {
            this.name = name;
            this.version = version;
        }

        public Api(@Nonnull ApiName name, int version) {
            this.name = name;
            this.version = "" + version;
        }

        public Api(@Nonnull String id, @Nonnull String version) {
            this.name = ApiInfo.findById(id);
            if (this.name == null) {
                throw new IllegalArgumentException("No API found with id \"" + id + "\"");
            }
            this.version = version;
        }

        public String getId() {
            return this.name.getId();
        }

        public ApiName getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean matches(Service service) {
            return Objects.equals(ApiInfo.normalizeId(service.getApi()), ApiInfo.normalizeId(this.getId())) && Objects.equals(this.version.trim(), service.getApiVersion().trim());
        }

        public boolean matchesId(String id) {
            return Objects.equals(ApiInfo.normalizeId(this.getId()), ApiInfo.normalizeId(id));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Api api = (Api)o;
            if (this.name != api.name) {
                return false;
            }
            return Objects.equals(this.version, api.version);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public String toString() {
            return "Api{name=" + this.name + ", version='" + this.version + "'}";
        }
    }
}

