/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.preferences;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProxyPreferencesManager {
    public static final String ALWAYS_USE_PROXY = "ALWAYS";
    public static final String NEVER_USE_PROXY = "NEVER";
    public static final String AUTO_USE_PROXY = "AUTO";
    private static final Logger LOG = LoggerFactory.getLogger(ProxyPreferencesManager.class);
    private static final int MAX_PORTS_TESTED = 10;
    private static final int CONNECT_TIMEOUT = 5000;
    private final GeniUserProvider geniUserProvider;
    private final SfaConnectionPool connectionPool;
    private final JFedCorePreferences jFedPreferences;
    private final TestbedInfoSource testbedInfoSource;
    private final List<ProxyPort> reachableProxies = new ArrayList<ProxyPort>();
    private final List<ProxyPort> unreachableProxies = new ArrayList<ProxyPort>();
    private boolean needProxyForJFed;
    private boolean needProxyForSsh;
    private GeniUser prevUser;
    private JFedConnection.ProxyInfo prevProxy;
    private boolean prevNeedProxyForJFed = false;

    @Inject
    public ProxyPreferencesManager(GeniUserProvider geniUserProvider, SfaConnectionPool connectionPool, JFedCorePreferences jFedPreferences, TestbedInfoSource testbedInfoSource) {
        this.geniUserProvider = geniUserProvider;
        this.connectionPool = connectionPool;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.updateProxySettings();
    }

    public void reportUnreachableProxy(@Nonnull Proxy proxyInfo, int port) {
        if (proxyInfo != null) {
            this.unreachableProxies.add(new ProxyPort(proxyInfo, port));
        }
    }

    public void reportReachableProxy(@Nonnull Proxy proxyInfo, int port) {
        this.reachableProxies.add(new ProxyPort(proxyInfo, port));
    }

    public void resetProxyReachabilityCache() {
        this.reachableProxies.clear();
        this.unreachableProxies.clear();
    }

    public JFedConnection.SshProxyInfo chooseUserProxy(List<Proxy> userAuthProxyInfo, GeniUser user, SshKeyInfo userSshKeyInfo) {
        if (this.reachableProxies.isEmpty() && this.unreachableProxies.isEmpty()) {
            this.waitForTryProxyTask(user);
        }
        String username = user.getUserUrn().getEncodedResourceName();
        if (!this.reachableProxies.isEmpty()) {
            ProxyPort pp = this.reachableProxies.get(0);
            assert (pp != null);
            LOG.debug("chooseUserProxy returns first of " + this.reachableProxies.size() + " in reachableProxies: " + pp + "  (reachableProxies=" + this.reachableProxies + " unreachableProxies=" + this.unreachableProxies + ")");
            return new JFedConnection.SshProxyInfo(pp.getHostname(), pp.getPort(), pp.getProxyInfo().transformUsername(username), userSshKeyInfo, pp.getProxyInfo().getHostKey());
        }
        for (Proxy authProxyInfo : userAuthProxyInfo) {
            assert (Objects.equals(authProxyInfo.getType(), "SSH")) : "Unexpected proxy type: '" + authProxyInfo.getType() + "'";
            VlanRange portRange = new VlanRange(authProxyInfo.getPortRange());
            LOG.debug("chooseUserProxy is looking at proxy with ports=" + portRange + " while unreachableProxies=" + this.unreachableProxies);
            ProxyPort chosenPort = null;
            for (Integer port : portRange) {
                ProxyPort curPort = new ProxyPort(authProxyInfo, port);
                if (this.unreachableProxies.contains(curPort)) continue;
                chosenPort = curPort;
                break;
            }
            if (chosenPort == null) {
                LOG.debug("Proxy at " + authProxyInfo.getHostname() + " has no reachable ports, skipping.");
                continue;
            }
            LOG.debug("chooseUserProxy search resulted in port=" + chosenPort.getPort());
            return new JFedConnection.SshProxyInfo(authProxyInfo.getHostname(), chosenPort.getPort(), authProxyInfo.transformUsername(username), userSshKeyInfo, authProxyInfo.getHostKey());
        }
        return null;
    }

    public boolean isAnyProxyReachable() {
        return !this.reachableProxies.isEmpty();
    }

    public List<ProxyPort> getReachableProxies() {
        return Collections.unmodifiableList(this.reachableProxies);
    }

    public void setNeedProxyForJFed(boolean needProxyForJFed) {
        this.needProxyForJFed = needProxyForJFed;
        this.updateProxySettings();
    }

    public void setNeedProxyForSsh(boolean needProxyForSsh) {
        this.needProxyForSsh = needProxyForSsh;
        this.updateProxySettings();
    }

    public boolean isProxyEnabledForJfed() {
        String proxyUsage = this.jFedPreferences.getString(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED);
        if (proxyUsage.equalsIgnoreCase(NEVER_USE_PROXY)) {
            return false;
        }
        if (proxyUsage.equalsIgnoreCase(AUTO_USE_PROXY)) {
            return this.needProxyForJFed;
        }
        if (proxyUsage.equalsIgnoreCase(ALWAYS_USE_PROXY)) {
            return true;
        }
        throw new RuntimeException("illegal value: proxyUsage=" + proxyUsage);
    }

    public boolean isProxyEnabledForSsh() {
        String proxyUsage = this.jFedPreferences.getString(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH);
        if (proxyUsage.equalsIgnoreCase(NEVER_USE_PROXY)) {
            return false;
        }
        if (proxyUsage.equalsIgnoreCase(AUTO_USE_PROXY)) {
            return this.needProxyForJFed;
        }
        if (proxyUsage.equalsIgnoreCase(ALWAYS_USE_PROXY)) {
            return true;
        }
        throw new RuntimeException("illegal value: proxyUsage=" + proxyUsage);
    }

    public boolean isDnsOverProxyRequiredForJFed() {
        Boolean useDnsOverSsh = this.jFedPreferences.getBoolean(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_JFED, false);
        return useDnsOverSsh;
    }

    public boolean isDnsOverProxyRequiredForSsh() {
        Boolean useDnsOverSsh = this.jFedPreferences.getBoolean(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_SSH, false);
        return useDnsOverSsh;
    }

    @Nullable
    public JFedConnection.SshProxyInfo getSshProxySettings(List<Proxy> userAuthProxyInfo, GeniUser user) {
        return this.getProxySettings(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, userAuthProxyInfo, user);
    }

    @Nullable
    public JFedConnection.SshProxyInfo getSshProxySettings(GeniUser user) {
        Server userServer = this.testbedInfoSource.getServerById(user.getUserAuthorityServerId());
        return this.getSshProxySettings(userServer.getTestbed().getProxies(), user);
    }

    @Nullable
    public JFedConnection.SshProxyInfo getProxySettings(JFedPreferences.PreferenceKey preferencesKey, @Nullable List<Proxy> userAuthProxyInfo, GeniUser user) {
        String proxyUsage = this.jFedPreferences.getString(preferencesKey);
        if (proxyUsage.equalsIgnoreCase(NEVER_USE_PROXY)) {
            return null;
        }
        if (proxyUsage.equalsIgnoreCase(AUTO_USE_PROXY) && preferencesKey == CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH && !this.needProxyForSsh) {
            return null;
        }
        if (proxyUsage.equalsIgnoreCase(AUTO_USE_PROXY) && preferencesKey == CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED && !this.needProxyForJFed) {
            return null;
        }
        if (proxyUsage.equalsIgnoreCase(ALWAYS_USE_PROXY) || proxyUsage.equalsIgnoreCase(AUTO_USE_PROXY) && this.needProxyForSsh) {
            return this.chooseUserProxy(userAuthProxyInfo != null ? userAuthProxyInfo : Collections.emptyList(), user, SshKeyInfoFactory.createGeniUserSshKeyInfo(user));
        }
        throw new RuntimeException("Unknown proxy setting for PREF_SSHPROXY_USE_FOR_SSH: \"" + proxyUsage + "\"");
    }

    public void updateProxySettings() {
        LOG.debug("ProxyPreferencesManager.updateProxySettings()");
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return;
        }
        GeniUser currentUser = this.geniUserProvider.getLoggedInGeniUser();
        Server userAuth = currentUser.getUserAuthorityServer();
        assert (userAuth != null);
        if (userAuth == null) {
            LOG.info("userAuth == null  -> Fallback: No SSH Proxy for jFed calls");
            this.connectionPool.setDefaultProxy(null);
            return;
        }
        LOG.debug("userAuth= {}", userAuth.getId());
        LOG.debug("userAuth.getTestbed().getProxies()={}", (Object)userAuth.getTestbed().getProxies());
        JFedConnection.SshProxyInfo usedProxy = this.getProxySettings(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, userAuth.getTestbed().getProxies(), currentUser);
        if (this.prevUser == currentUser && usedProxy != null && this.prevProxy != null && Objects.equals(this.prevProxy, usedProxy) && this.needProxyForJFed == this.prevNeedProxyForJFed) {
            return;
        }
        LOG.debug("ProxyPreferencesManager.updateProxySettings() -> settings changed, will update.");
        this.prevUser = currentUser;
        this.prevNeedProxyForJFed = this.needProxyForJFed;
        this.prevProxy = usedProxy;
        if (usedProxy != null) {
            LOG.info("SSH Proxy is activated for jFed calls, and there is a reachable SSH Proxy: " + usedProxy.getHostname() + ":" + usedProxy.getPort());
            this.connectionPool.setDefaultProxy(usedProxy);
            return;
        }
        LOG.info("No SSH Proxy for jFed calls");
        this.connectionPool.setDefaultProxy(null);
    }

    private void waitForTask(Runnable task) {
        Thread taskThread = new Thread(task);
        taskThread.setDaemon(true);
        taskThread.setName("TryProxyThread");
        taskThread.start();
        try {
            taskThread.join();
        }
        catch (InterruptedException e) {
            LOG.error("TryProxyThread Task aborted", e);
        }
    }

    public void waitForTryProxyTask(GeniUser user) {
        assert (user.getUserAuthorityServer() != null);
        if (user.getUserAuthorityServer().getTestbed().getProxies() == null || user.getUserAuthorityServer().getTestbed().getProxies().isEmpty()) {
            return;
        }
        this.waitForTask(new TryProxyTask(user.getUserAuthorityServer().getTestbed().getProxies()));
    }

    public void waitForTryProxyTask(Server authority) {
        if (authority.getTestbed().getProxies() == null || authority.getTestbed().getProxies().isEmpty()) {
            return;
        }
        this.waitForTask(new TryProxyTask(authority.getTestbed().getProxies()));
    }

    public TryProxyTask getTryProxyTask(GeniUser user) {
        assert (user.getUserAuthorityServer() != null);
        return new TryProxyTask(user.getUserAuthorityServer().getTestbed().getProxies());
    }

    public TryProxyTask getTryProxyTask(Server authority) {
        return new TryProxyTask(authority.getTestbed().getProxies());
    }

    public void tryProxy(@Nonnull Proxy userAuthProxyInfo) {
        int portsTested = 0;
        VlanRange portRange = new VlanRange(userAuthProxyInfo.getPortRange());
        for (Integer port : portRange) {
            if (this.testConnectivity(userAuthProxyInfo.getHostname(), port)) {
                this.reportReachableProxy(userAuthProxyInfo, port);
            } else {
                this.reportUnreachableProxy(userAuthProxyInfo, port);
            }
            if (portsTested++ < 10) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnectivity(String hostname, int port) {
        InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
        Socket socket = new Socket();
        try {
            socket.connect(socketAddress, 5000);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class ProxyPort {
        private final Proxy proxyInfo;
        private final int port;

        private ProxyPort(@Nonnull Proxy proxyInfo, int port) {
            this.port = port;
            this.proxyInfo = proxyInfo;
        }

        public Proxy getProxyInfo() {
            return this.proxyInfo;
        }

        public String getHostname() {
            return this.proxyInfo.getHostname();
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyPort proxyPort = (ProxyPort)o;
            if (this.port != proxyPort.port) {
                return false;
            }
            return Objects.equals(this.proxyInfo, proxyPort.proxyInfo);
        }

        public int hashCode() {
            int result = this.proxyInfo.hashCode();
            result = 31 * result + this.port;
            return result;
        }

        public String toString() {
            return this.proxyInfo.getHostname() + ":" + this.port;
        }
    }

    public class TryProxyTask
    implements Runnable,
    Callable<Boolean> {
        private final List<Proxy> userAuthProxyInfos;
        private boolean finished = false;
        private boolean success = false;
        private String message;
        private Throwable exception;

        private TryProxyTask(List<Proxy> userAuthProxyInfos) {
            this.userAuthProxyInfos = userAuthProxyInfos;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Boolean call() throws Exception {
            this.success = false;
            int portsTested = 0;
            this.updateMessage("Initializing proxy test");
            int totalPorts = 0;
            ArrayList<VlanRange> rangeHelpers = new ArrayList<VlanRange>();
            for (Proxy pi : this.userAuthProxyInfos) {
                VlanRange portRange = new VlanRange(pi.getPortRange());
                totalPorts += Math.min(portRange.size(), 10);
                rangeHelpers.add(portRange);
            }
            ProxyPreferencesManager.this.resetProxyReachabilityCache();
            int totalPortsTested = 0;
            block1: for (int i = 0; i < this.userAuthProxyInfos.size(); ++i) {
                Proxy userAuthProxyInfo = this.userAuthProxyInfos.get(i);
                assert (userAuthProxyInfo != null);
                VlanRange portRange = (VlanRange)rangeHelpers.get(i);
                assert (Objects.equals(userAuthProxyInfo.getType(), "SSH")) : "Unexpected proxy type '" + userAuthProxyInfo.getType() + "'";
                for (Integer port : portRange) {
                    if (portsTested >= 10) continue block1;
                    LOG.info("Testing proxy " + userAuthProxyInfo.getHostname() + ":" + port);
                    this.updateMessage(String.format("Testing proxy %s:%d", userAuthProxyInfo.getHostname(), port));
                    if (ProxyPreferencesManager.this.testConnectivity(userAuthProxyInfo.getHostname(), port)) {
                        LOG.info("-> proxy reachable " + userAuthProxyInfo.getHostname() + ":" + port);
                        ProxyPreferencesManager.this.reportReachableProxy(userAuthProxyInfo, port);
                        this.success = true;
                    } else {
                        ProxyPreferencesManager.this.reportUnreachableProxy(userAuthProxyInfo, port);
                        LOG.info("-> proxy unreachable " + userAuthProxyInfo.getHostname() + ":" + port);
                    }
                    this.updateProgress(++totalPortsTested, totalPorts);
                    ++portsTested;
                }
            }
            this.updateMessage("Finished testing proxies.");
            this.finished = true;
            return this.success;
        }

        private void updateProgress(long current, long total) {
        }

        private void updateMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

