/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFC3339Util {
    private static final Logger LOG = LoggerFactory.getLogger(RFC3339Util.class);

    @Nonnull
    public static String dateToRFC3339String(@Nonnull Date date) {
        return RFC3339Util.dateToRFC3339String(date, false, true, true);
    }

    @Nonnull
    public static String dateToRFC3339String(@Nonnull Date date, boolean forceZuluHack) {
        return RFC3339Util.dateToRFC3339String(date, forceZuluHack, true, true);
    }

    @Nonnull
    public static String dateToRFC3339String(@Nonnull Date date, boolean forceZuluHack, boolean discardSubSeconds, boolean useZinsteadOfZero) {
        SimpleDateFormat dateFormat = date.getTime() % 1000L == 0L || discardSubSeconds ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        if (forceZuluHack) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Object res = dateFormat.format(date).replaceFirst("(\\d\\d)(\\d\\d)$", "$1:$2");
        if (useZinsteadOfZero && ((String)res).endsWith("+00:00")) {
            res = ((String)res).substring(0, ((String)res).length() - "+00:00".length()) + "Z";
        }
        return res;
    }

    @Nonnull
    public static String instantToRFC3339String(@Nonnull Instant instant) {
        return RFC3339Util.instantToRFC3339String(instant, false, true, true);
    }

    @Nonnull
    public static String instantToRFC3339String(@Nonnull Instant instant, boolean forceZuluHack) {
        return RFC3339Util.instantToRFC3339String(instant, forceZuluHack, true, true);
    }

    @Nonnull
    public static String instantToRFC3339String(@Nonnull Instant instant, boolean forceZuluHack, boolean discardSubSeconds, boolean useZinsteadOfZero) {
        return RFC3339Util.dateToRFC3339String(Date.from(instant), forceZuluHack, discardSubSeconds, useZinsteadOfZero);
    }

    @Nonnull
    public static Date rfc3339StringToDate(@Nonnull String rfc3339date) throws ParseException {
        String parsableDateString = rfc3339date.trim().replace('t', 'T').replace('z', 'Z').replace(' ', 'T').replaceFirst("Z$", "+00:00").replaceFirst("(\\d\\d):(\\d\\d)$", "$1$2").replaceFirst("(\\d\\d)\\.(\\d\\d)([+-]\\d\\d\\d\\d)$", "$1.$20$3").replaceFirst("(\\d\\d)\\.(\\d)([+-]\\d\\d\\d\\d)$", "$1.$200$3");
        LOG.trace("rfc3339StringToDate(\"" + rfc3339date + "\") -> parsableDateString=" + parsableDateString);
        Date res = parsableDateString.matches(".*\\d\\d\\.\\d\\d\\d[+-]\\d\\d\\d\\d$") ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(parsableDateString) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(parsableDateString);
        LOG.trace("rfc3339StringToDate('{}') -> {}", (Object)rfc3339date, (Object)res);
        return res;
    }

    @Nonnull
    public static Instant rfc3339StringToInstant(@Nonnull String rfc3339date) throws ParseException {
        Date d = RFC3339Util.rfc3339StringToDate(rfc3339date);
        return d.toInstant();
    }

    @Nonnull
    public static Date iso8601StringToDate(@Nonnull String iso6801Date) throws ParseException {
        Date res;
        boolean hasLeapSecond = iso6801Date.contains(":59:60");
        String parsableDateString = iso6801Date.trim().replace('t', 'T').replace(' ', 'T').replace('z', 'Z').replaceFirst(":59:60", ":59:59");
        try {
            TemporalAccessor ta = DateTimeFormatter.ISO_DATE_TIME.parseBest(parsableDateString, ZonedDateTime::from, LocalDateTime::from);
            res = ta instanceof ZonedDateTime ? Date.from(((ZonedDateTime)ta).toInstant()) : Date.from(((LocalDateTime)ta).atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if (hasLeapSecond) {
            res = new Date(res.getTime() + 1000L);
        }
        LOG.trace("iso8601ToDate(\"" + iso6801Date + "\") -> " + res);
        return res;
    }

    public static class InstantJsonSerializer
    extends JsonSerializer<Instant> {
        @Override
        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            String InstantString = RFC3339Util.instantToRFC3339String(instant, true);
            jsonGenerator.writeString(InstantString);
        }
    }

    public static class InstantJsonDeserializer
    extends JsonDeserializer<Instant> {
        @Override
        public Instant deserialize(JsonParser jsonparser, DeserializationContext deserializationcontext) throws IOException {
            String instant = jsonparser.getText();
            try {
                Instant resInstant = RFC3339Util.rfc3339StringToInstant(instant);
                return resInstant;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DateJsonSerializer
    extends JsonSerializer<Date> {
        @Override
        public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            String dateString = RFC3339Util.dateToRFC3339String(date, true);
            jsonGenerator.writeString(dateString);
        }
    }

    public static class DateJsonDeserializer
    extends JsonDeserializer<Date> {
        @Override
        public Date deserialize(JsonParser jsonparser, DeserializationContext deserializationcontext) throws IOException {
            String date = jsonparser.getText();
            try {
                Date resDate = RFC3339Util.rfc3339StringToDate(date);
                return resDate;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TimeStampJsonSerializer
    extends JsonSerializer<Timestamp> {
        @Override
        public void serialize(Timestamp date, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            String dateString = RFC3339Util.dateToRFC3339String(date, true);
            jsonGenerator.writeString(dateString);
        }
    }

    public static class TimeStampJsonDeserializer
    extends JsonDeserializer<Timestamp> {
        @Override
        public Timestamp deserialize(JsonParser jsonparser, DeserializationContext deserializationcontext) throws IOException {
            String date = jsonparser.getText();
            try {
                Date resDate = RFC3339Util.rfc3339StringToDate(date);
                return new Timestamp(resDate.getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

