/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TextUtil.class);

    @Nonnull
    public static String printArray(@Nullable String[] arr) {
        if (arr == null) {
            return "null";
        }
        Object res = "[";
        boolean first = true;
        for (String a : arr) {
            if (!first) {
                res = (String)res + ", ";
            }
            res = (String)res + a;
            first = false;
        }
        res = (String)res + "]";
        return res;
    }

    @Nonnull
    public static String wrap(@Nonnull String s2, int maxLineLen) {
        if (s2.length() < maxLineLen) {
            return s2;
        }
        StringBuilder result = new StringBuilder();
        int pos = 0;
        while (pos < s2.length()) {
            int newPos = s2.indexOf(10, pos);
            if (newPos < 0 || newPos - pos > maxLineLen) {
                result.append(s2.substring(pos, Math.min(pos + maxLineLen, s2.length())));
                if (pos + maxLineLen < s2.length()) {
                    result.append('\n');
                }
                pos += maxLineLen;
                continue;
            }
            result.append(s2.substring(pos, newPos + 1));
            pos = newPos + 1;
        }
        return result.toString();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String abbreviate(@Nullable String s2, int maxLineLen) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() < maxLineLen) {
            return s2;
        }
        return s2.substring(0, maxLineLen) + "...";
    }

    @Nonnull
    public static List<String> getLines(@Nonnull String in) {
        ArrayList<String> res = new ArrayList<String>();
        Collections.addAll(res, in.split("\n"));
        return res;
    }

    @Nonnull
    public static String mkString(@Nonnull Collection<?> c, @Nonnull String sep) {
        Object res = "";
        for (Object i : c) {
            if (!((String)res).isEmpty()) {
                res = (String)res + sep;
            }
            res = (String)res + i.toString();
        }
        return res;
    }

    @Nullable
    @Contract(value="null -> null")
    public static Boolean objectToBoolean(@Nullable Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return TextUtil.stringToBoolean((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return TextUtil.stringToBoolean("" + val);
    }

    @Nullable
    @Contract(value="null -> null")
    public static String objectToStringOrNull(@Nullable Object val, boolean makeString) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (makeString) {
            return "" + val;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static Boolean stringToBoolean(@Nullable String val) {
        if (val == null) {
            return null;
        }
        switch (val = val.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "yes": {
                return true;
            }
            case "yep": {
                return true;
            }
            case "1": {
                return true;
            }
            case "t": {
                return true;
            }
            case "y": {
                return true;
            }
            case "false": {
                return false;
            }
            case "no": {
                return false;
            }
            case "nope": {
                return false;
            }
            case "f": {
                return false;
            }
            case "n": {
                return false;
            }
            case "0": {
                return false;
            }
        }
        return null;
    }

    @Nonnull
    public static String exceptionToString(@Nonnull Throwable exception) {
        assert (exception != null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String stackTrace = sw.toString();
        return stackTrace;
    }

    @Nullable
    @Contract(value="_,null -> null; _,!null -> !null")
    public static String indent(int count, @Nullable String text) {
        if (text == null) {
            return null;
        }
        Object spaces = "";
        for (int i = 0; i < count; ++i) {
            spaces = (String)spaces + " ";
        }
        int lastChar = text.isEmpty() ? 32 : (int)text.charAt(text.length() - 1);
        boolean endsWithNewLine = lastChar == 10 || lastChar == 13;
        StringBuilder result = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new StringReader(text));
            String line = br.readLine();
            while (line != null) {
                result.append((String)spaces).append(line).append("\n");
                line = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("Got an IOException where there should never be one", e);
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOG.error("Got an IOException where there should never be one", e);
                }
            }
        }
        if (!endsWithNewLine && result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return result.toString();
    }
}

