/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class ThreadFactoryUtil {
    private static Map<String, AtomicInteger> poolIdUsageCount = new ConcurrentHashMap<String, AtomicInteger>();

    public static ThreadFactory getFactory(@Nonnull String poolId) {
        return ThreadFactoryUtil.getFactory(poolId, null);
    }

    public static ThreadFactory getFactory(@Nonnull String poolId, Boolean forceDaemon) {
        AtomicInteger poolNumber = poolIdUsageCount.computeIfAbsent(poolId, key -> new AtomicInteger(1));
        return new ThreadFactoryUtilThreadFactory(poolId, poolNumber.getAndIncrement(), forceDaemon);
    }

    static class ThreadFactoryUtilThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        @Nonnull
        private final String namePrefix;
        private final Boolean forceDaemon;

        ThreadFactoryUtilThreadFactory(@Nonnull String poolId, int poolNumber, Boolean forceDaemon) {
            SecurityManager s2 = System.getSecurityManager();
            this.forceDaemon = forceDaemon;
            this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolId + "-" + poolNumber + "-thread-";
        }

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (this.forceDaemon != null) {
                t.setDaemon(this.forceDaemon);
            } else if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

