/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JFedUtils.class);

    public static String getUserDataDirectory() {
        String userDataDir = System.getProperty("os.name").toLowerCase().contains("win") ? System.getenv("APPDATA") + File.separator + "jFed" + File.separator : System.getProperty("user.home") + File.separator + ".jFed" + File.separator;
        try {
            File userDataDirFile = new File(userDataDir);
            if (!userDataDirFile.exists()) {
                LOG.info("User data dir " + userDataDir + " does not exist. Creating it.");
                if (userDataDirFile.mkdir()) {
                    return userDataDir;
                }
                LOG.warn("Could not create the user data directory. (" + userDataDir + ").");
                return null;
            }
            if (userDataDirFile.list() != null) {
                return userDataDir;
            }
            LOG.error("Unable to list the files in the user data directory");
            return null;
        }
        catch (SecurityException ex) {
            LOG.error("Unable to create User Data Directory", ex);
            return null;
        }
    }

    public static File getUserDataDirectoryFile() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir != null) {
            return new File(userDataDir);
        }
        return null;
    }

    public static Path getUserDataDirectoryPath() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir != null) {
            return Paths.get(userDataDir, new String[0]);
        }
        return null;
    }

    public static String getWindowsUserDataDirectoryString() {
        String ignoreButCreate = JFedUtils.getUserDataDirectory();
        return "%APPDATA%" + File.separator + "jFed" + File.separator;
    }

    @Nullable
    public static File createPreferencesFile(@Nonnull String filename) {
        String jFedUserDataDir = JFedUtils.getUserDataDirectory();
        if (jFedUserDataDir == null) {
            return null;
        }
        File userDataDir = new File(jFedUserDataDir);
        File preferencesFile = new File(userDataDir, filename);
        if (!preferencesFile.exists()) {
            if (!userDataDir.exists()) {
                LOG.debug("Will try to create " + userDataDir.getPath() + " dir");
                userDataDir.mkdirs();
                if (userDataDir.exists() && userDataDir.isDirectory()) {
                    LOG.info("Successfully created " + userDataDir.getPath() + " dir");
                } else {
                    LOG.error("Could not create jFed user data dir at \"" + userDataDir.getPath() + "\".");
                    return null;
                }
            }
            assert (userDataDir.exists());
            try {
                preferencesFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error("Could not create jFed preferences file: \"" + e.getMessage() + "\".", e);
                return null;
            }
        }
        assert (preferencesFile.exists());
        if (!preferencesFile.canRead()) {
            LOG.error("WARNING: cannot read jFed preferences file: \"" + preferencesFile.getPath() + "\".");
        }
        return preferencesFile;
    }
}

