/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.StringUtils;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.eclipse.jgit.util.Base64;

public class PublicKeyConvertor {
    @Nonnull
    private PublicKey publicKey;
    @Nonnull
    private String opensshFormKeyType;
    @Nonnull
    private String opensshFormEncodedKey;
    @Nullable
    private String opensshFormComment;
    private static List<String> OPENSSH_KEYTYPES = Arrays.asList("sk-ecdsa-sha2-nistp256@openssh.com", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521", "sk-ssh-ed25519@openssh.com", "ssh-ed25519", "ssh-dss", "ssh-rsa");

    private PublicKeyConvertor(@Nonnull PublicKey publicKey, @Nonnull String opensshFormKeyType, @Nonnull String opensshFormEncodedKey, @Nullable String opensshFormComment) {
        this.publicKey = publicKey;
        assert (opensshFormKeyType != null);
        assert (!opensshFormKeyType.isEmpty());
        this.opensshFormKeyType = opensshFormKeyType;
        assert (!opensshFormEncodedKey.contains(" "));
        this.opensshFormEncodedKey = opensshFormEncodedKey;
        this.opensshFormComment = opensshFormComment;
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nonnull
    public String getOpensshFormKeyType() {
        return this.opensshFormKeyType;
    }

    @Nonnull
    public String getOpensshFormEncodedKey() {
        return this.opensshFormEncodedKey;
    }

    @Nullable
    public String getOpensshFormComment() {
        return this.opensshFormComment;
    }

    @Nonnull
    public String getOpensshFormString() {
        assert (this.opensshFormKeyType != null);
        assert (!this.opensshFormKeyType.isEmpty());
        return this.opensshFormKeyType + " " + this.opensshFormEncodedKey + (String)(this.opensshFormComment == null ? "" : " " + this.opensshFormComment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicKeyConvertor)) {
            return false;
        }
        PublicKeyConvertor that = (PublicKeyConvertor)o;
        byte[] pubKey1Bytes = this.publicKey.getEncoded();
        byte[] pubKey2Bytes = that.publicKey.getEncoded();
        return Arrays.equals(pubKey1Bytes, pubKey2Bytes);
    }

    public int hashCode() {
        return Objects.hash(Base64.encodeBytes(this.publicKey.getEncoded()));
    }

    @Nonnull
    public PublicKeyConvertor withComment(@Nullable String newComment) {
        return new PublicKeyConvertor(this.publicKey, this.opensshFormKeyType, this.opensshFormEncodedKey, newComment);
    }

    @Nonnull
    public static PublicKeyConvertor fromPublicKey(@Nonnull PublicKey publicKey) {
        try {
            byte[] pubKeyBytes = OpenSSHPublicKeyUtil.encodePublicKey(PublicKeyFactory.createKey(publicKey.getEncoded()));
            String opensshFormEncodedKey = Base64.encodeBytes(pubKeyBytes);
            ByteBuffer bb = ByteBuffer.wrap(pubKeyBytes).order(ByteOrder.BIG_ENDIAN);
            int keyTypeStrLen = bb.getInt();
            byte[] keyType = new byte[keyTypeStrLen];
            bb.get(keyType);
            String opensshFormKeyType = StringUtils.newStringUtf8(keyType);
            return new PublicKeyConvertor(publicKey, opensshFormKeyType, opensshFormEncodedKey, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static PublicKeyConvertor fromOpensshFormat(@Nonnull String opensshFormatPubKey) {
        AsymmetricKeyParameter akp;
        String[] parts = opensshFormatPubKey.trim().replaceAll("\r\n", "\n").split(" ");
        String opensshFormKeyType = null;
        String opensshFormEncodedKey = null;
        String opensshFormEncodedKeyComment = null;
        for (int i = 0; i < parts.length - 1 && opensshFormEncodedKey == null; ++i) {
            if (!OPENSSH_KEYTYPES.contains(parts[i])) continue;
            opensshFormKeyType = parts[i];
            opensshFormEncodedKey = parts.length > i + 1 ? parts[i + 1] : null;
            opensshFormEncodedKeyComment = parts.length > i + 2 ? parts[i + 2] : null;
        }
        if (opensshFormEncodedKey == null) {
            throw new RuntimeException("No key found in OpenSSH authorized_keys format. format syntax: [options] <keytype> <base64-encoded key> <comment>. input=\"" + opensshFormatPubKey + "\"");
        }
        byte[] publicKeyBytes = Base64.decode(opensshFormEncodedKey);
        try {
            akp = OpenSSHPublicKeyUtil.parsePublicKey(publicKeyBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing PublicKey: " + e.getMessage(), e);
        }
        if (akp instanceof RSAKeyParameters) {
            RSAKeyParameters rkp = (RSAKeyParameters)akp;
            try {
                RSAPublicKeySpec spec = new RSAPublicKeySpec(rkp.getModulus(), rkp.getExponent());
                KeyFactory keyFact = KeyFactory.getInstance("RSA");
                PublicKey key = keyFact.generatePublic(spec);
                return new PublicKeyConvertor(key, opensshFormKeyType, opensshFormEncodedKey, opensshFormEncodedKeyComment);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating RSAPublicKey: " + e.getMessage(), e);
            }
        }
        if (akp instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters eckp = (ECPublicKeyParameters)akp;
            try {
                ECParameterSpec ecParameterSpec = EC5Util.convertToSpec(eckp.getParameters());
                ECPoint ecPoint = EC5Util.convertPoint(eckp.getQ());
                ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
                PublicKey key = KeyFactory.getInstance("EC").generatePublic(ecPublicKeySpec);
                return new PublicKeyConvertor(key, opensshFormKeyType, opensshFormEncodedKey, opensshFormEncodedKeyComment);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating ECPublicKey: " + e.getMessage(), e);
            }
        }
        if (akp instanceof Ed25519PublicKeyParameters) {
            Ed25519PublicKeyParameters edkp = (Ed25519PublicKeyParameters)akp;
            try {
                byte[] encodedPoint = edkp.getEncoded();
                byte msb = encodedPoint[encodedPoint.length - 1];
                int n = encodedPoint.length - 1;
                encodedPoint[n] = (byte)(encodedPoint[n] & 0x7F);
                boolean xOdd2 = (msb & 0x80) != 0;
                KeyUtil.reverse(encodedPoint);
                BigInteger y2 = new BigInteger(1, encodedPoint);
                EdECPoint point = new EdECPoint(xOdd2, y2);
                EdECPublicKeySpec edECSpec = new EdECPublicKeySpec(NamedParameterSpec.ED25519, point);
                KeyFactory keyFactory = KeyFactory.getInstance("Ed25519");
                PublicKey key = keyFactory.generatePublic(edECSpec);
                return new PublicKeyConvertor(key, opensshFormKeyType, opensshFormEncodedKey, opensshFormEncodedKeyComment);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating Ed25519Public: " + e.getMessage(), e);
            }
        }
        throw new RuntimeException("Unsupported public key " + akp.getClass().getName() + " from " + opensshFormKeyType + " read from " + opensshFormatPubKey);
    }
}

