/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class SocksProxyHelper {

    public static class SOCKSConnectionSocketFactory
    implements ConnectionSocketFactory {
        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            int socksPort = 10801;
            if (System.getProperty("socksProxyPort") != null) {
                socksPort = Integer.parseInt(System.getProperty("socksProxyPort"));
            }
            InetSocketAddress socksaddr = new InetSocketAddress(System.getProperty("socksProxyHost"), socksPort);
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }

        @Override
        public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            Socket sock = socket != null ? socket : this.createSocket(context);
            if (localAddress != null) {
                sock.bind(localAddress);
            }
            try {
                sock.connect(remoteAddress, connectTimeout);
            }
            catch (SocketTimeoutException ex) {
                throw new ConnectTimeoutException(ex, host, remoteAddress.getAddress());
            }
            return sock;
        }
    }
}

