/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.OpenSSHKnownHostsInMemory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class SshProxySocketImplFactory
implements SocketImplFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SshProxySocketImplFactory.class);
    protected final SSHClient sshClient;
    private static final boolean singleConnectionPerSShConnection = true;
    public static final int CONNECT_TIMEOUT_MS = 10000;
    public static final int KEX_TIMEOUT_MS = 8000;
    protected final String forcedCreateSocketHostname;
    protected final Integer forcedCreateSocketPort;

    public static DefaultConfig getDefaultjFedSshConfig() {
        DefaultConfig config = new DefaultConfig();
        config.setKeyAlgorithms(config.getKeyAlgorithms().stream().filter(keyAlgorithmNamed -> !keyAlgorithmNamed.getName().startsWith("ecdsa") && !keyAlgorithmNamed.getName().startsWith("ssh-dss")).collect(Collectors.toList()));
        return config;
    }

    public static synchronized SshProxySocketImplFactory getFactory(JFedConnection.SshProxyInfo sshProxyInfo, String forcedCreateSocketHostname, Integer forcedCreateSocketPort) throws IOException {
        return new SshProxySocketImplFactory(sshProxyInfo, null, forcedCreateSocketHostname, forcedCreateSocketPort);
    }

    public static synchronized SshProxySocketImplFactory getFactory(JFedConnection.SshProxyInfo sshProxyInfo) throws IOException {
        return new SshProxySocketImplFactory(sshProxyInfo, null, null, null);
    }

    public static synchronized SshProxySocketImplFactory getFactory(JFedConnection.SshProxyInfo sshProxyInfo, @Nullable SocketFactory customSocketFactory) throws IOException {
        return new SshProxySocketImplFactory(sshProxyInfo, customSocketFactory, null, null);
    }

    public static synchronized SshProxySocketImplFactory getFactory(JFedConnection.SshProxyInfo sshProxyInfo, @Nullable SocketFactory customSocketFactory, String forcedCreateSocketHostname, int forcedCreateSocketPort) throws IOException {
        return new SshProxySocketImplFactory(sshProxyInfo, customSocketFactory, forcedCreateSocketHostname, forcedCreateSocketPort);
    }

    private SshProxySocketImplFactory(@Nonnull JFedConnection.SshProxyInfo sshProxyInfo, @Nullable SocketFactory customSocketFactory, @Nullable String forcedCreateSocketHostname, @Nullable Integer forcedCreateSocketPort) throws IOException {
        this.forcedCreateSocketHostname = forcedCreateSocketHostname;
        this.forcedCreateSocketPort = forcedCreateSocketPort;
        this.sshClient = new SSHClient(SshProxySocketImplFactory.getDefaultjFedSshConfig());
        if (customSocketFactory != null) {
            this.sshClient.setSocketFactory(customSocketFactory);
        }
        if (sshProxyInfo.getHostKey() != null) {
            this.sshClient.addHostKeyVerifier(new OpenSSHKnownHostsInMemory(sshProxyInfo.getHostKey()));
        } else {
            LOG.warn("Cannot verify proxy host as no known_hosts-line is specified");
            this.sshClient.addHostKeyVerifier(new PromiscuousVerifier());
        }
        this.sshClient.setTimeout(8000);
        this.sshClient.setConnectTimeout(10000);
        LOG.debug("Connecting to " + sshProxyInfo.getHostname() + ":" + sshProxyInfo.getPort() + " as user " + sshProxyInfo.getUsername() + " with timeout 10000 ms");
        this.sshClient.connect(sshProxyInfo.getHostname(), sshProxyInfo.getPort());
        LOG.debug("Connect done. Will now authenticate.");
        try {
            assert (sshProxyInfo.getUsername() != null);
            assert (sshProxyInfo.getSshKeyInfo() != null);
            assert (sshProxyInfo.getSshKeyInfo().getPrivateKey() != null);
            assert (KeyUtil.matchingKeys(sshProxyInfo.getSshKeyInfo().getPublicKey(), sshProxyInfo.getSshKeyInfo().getPrivateKey()));
            this.sshClient.authPublickey(sshProxyInfo.getUsername(), new KeyPairWrapper(sshProxyInfo.getSshKeyInfo().getPublicKey(), sshProxyInfo.getSshKeyInfo().getPrivateKey()));
            LOG.debug("Connected and authenticated to {}:{}", (Object)sshProxyInfo.getHostname(), (Object)sshProxyInfo.getPort());
            this.sshClient.getConnection().getKeepAlive().setKeepAliveInterval(30);
        }
        catch (UserAuthException ex) {
            LOG.warn("Connected to {}:{}, but authentication failed", (Object)sshProxyInfo.getHostname(), (Object)sshProxyInfo.getPort());
            throw new IOException("Failed to authenticate user \"" + sshProxyInfo.getUsername() + "\" on server " + sshProxyInfo.getHostname() + ":" + sshProxyInfo.getPort(), ex);
        }
    }

    @Override
    public SocketImpl createSocketImpl() {
        if (this.sshClient == null) {
            throw new RuntimeException("The SSH connection is not ready. Cannot create socket over it.");
        }
        SSHSocketImpl res = new SSHSocketImpl(this.sshClient, this.forcedCreateSocketHostname, this.forcedCreateSocketPort);
        if (this.forcedCreateSocketHostname != null && this.forcedCreateSocketPort != null) {
            LOG.debug("returning new SSHSocketImpl with forced destination " + this.forcedCreateSocketHostname + ":" + this.forcedCreateSocketPort);
        } else {
            LOG.debug("returning new SSHSocketImpl");
        }
        return res;
    }

    private static class SSHSocketImpl
    extends SocketImpl {
        private SSHClient sshConnection;
        private DirectTCPIPChannel channel;
        protected final String forcedCreateSocketHostname;
        protected final Integer forcedCreateSocketPort;
        InputStream is;
        OutputStream os;

        SSHSocketImpl(SSHClient sshConnection, String forcedCreateSocketHostname, Integer forcedCreateSocketPort) {
            this.sshConnection = sshConnection;
            this.forcedCreateSocketHostname = forcedCreateSocketHostname;
            this.forcedCreateSocketPort = forcedCreateSocketPort;
        }

        @Override
        protected void accept(SocketImpl s2) throws IOException {
            throw new IOException("SSHSocketImpl does not implement accept");
        }

        @Override
        protected int available() throws IOException {
            if (this.is == null) {
                throw new ConnectException("Not connected");
            }
            return this.is.available();
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            if (host != null && !host.isAnyLocalAddress() || port != 0) {
                throw new IOException("SSHSocketImpl does not implement bind");
            }
        }

        @Override
        protected void close() throws IOException {
            LOG.debug("Closing SSH Proxy socket");
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
                this.is = null;
                this.os = null;
            }
            this.sshConnection.close();
            this.sshConnection = null;
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            if (this.forcedCreateSocketHostname != null && this.forcedCreateSocketPort != null) {
                this.connectToForced(300000);
                return;
            }
            InetAddress addr = Address.getByName(host);
            this.connect(addr, port);
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            if (this.forcedCreateSocketHostname != null && this.forcedCreateSocketPort != null) {
                this.connectToForced(300000);
                return;
            }
            this.connect(new InetSocketAddress(address, port), 300000);
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            if (this.forcedCreateSocketHostname != null && this.forcedCreateSocketPort != null) {
                this.connectToForced(timeout);
                return;
            }
            LOG.debug("Creating channel to " + ((InetSocketAddress)address).getHostName() + ":" + ((InetSocketAddress)address).getPort());
            this.channel = new DirectTCPIPChannel(this.sshConnection.getConnection(), new Parameters("", 0, ((InetSocketAddress)address).getHostName(), ((InetSocketAddress)address).getPort()));
            try {
                this.channel.open();
            }
            catch (IOException e) {
                IOUtils.closeQuietly(this.channel);
                throw e;
            }
            this.is = this.channel.getInputStream();
            this.os = this.channel.getOutputStream();
        }

        protected void connectToForced(int timeout) throws IOException {
            assert (this.forcedCreateSocketHostname != null);
            assert (this.forcedCreateSocketPort != null);
            LOG.debug("Creating channel to forced " + this.forcedCreateSocketHostname + ":" + this.forcedCreateSocketPort);
            this.channel = new DirectTCPIPChannel(this.sshConnection.getConnection(), new Parameters("", 0, this.forcedCreateSocketHostname, this.forcedCreateSocketPort));
            try {
                this.channel.open();
            }
            catch (IOException e) {
                IOUtils.closeQuietly(this.channel);
                throw e;
            }
            this.is = this.channel.getInputStream();
            this.os = this.channel.getOutputStream();
        }

        @Override
        protected void create(boolean stream) throws IOException {
            if (!stream) {
                throw new IOException("Cannot handle UDP streams");
            }
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this.is;
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return new FlushingOutputStream(this.os);
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new IOException("SSHSocketImpl does not implement listen");
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new IOException("SSHSocketImpl does not implement sendUrgentData");
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            if (optID == 1) {
                return false;
            }
            if (optID == 15) {
                throw new SocketException("SSHSocketImpl does not implement getOption for SO_BINDADDR");
            }
            if (optID == 4) {
                return false;
            }
            if (optID == 32) {
                return false;
            }
            if (optID == 16) {
                throw new SocketException("SSHSocketImpl does not implement getOption for IP_MULTICAST_IF");
            }
            if (optID == 31) {
                throw new SocketException("SSHSocketImpl does not implement getOption for IP_MULTICAST_IF2");
            }
            if (optID == 18) {
                throw new SocketException("SSHSocketImpl does not implement getOption for IP_MULTICAST_LOOP");
            }
            if (optID == 3) {
                throw new SocketException("SSHSocketImpl does not implement getOption for IP_TOS");
            }
            if (optID == 128) {
                return 0;
            }
            if (optID == 4102) {
                return 0;
            }
            if (optID == 4097) {
                throw new SocketException("SSHSocketImpl does not implement getOption for SO_SNDBUF");
            }
            if (optID == 4098) {
                throw new SocketException("SSHSocketImpl does not implement getOption for SO_RCVBUF");
            }
            if (optID == 8) {
                return false;
            }
            if (optID == 4099) {
                return false;
            }
            throw new SocketException("SSHSocketImpl does not implement getOption for " + optID);
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            if (optID == 4102) {
                LOG.info("SSHSocketImpl.setOption opt={}==SO_TIMEOUT val={} is used.This is ignored, which has been known to cause bugs in the past!", (Object)optID, value);
            } else {
                LOG.debug("Ignoring SSHSocketImpl.setOption opt={} val={}", (Object)optID, value);
            }
        }
    }

    private static class FlushingOutputStream
    extends OutputStream {
        private final OutputStream orig;

        public FlushingOutputStream(OutputStream orig) {
            this.orig = orig;
        }

        @Override
        public void write(int i) throws IOException {
            this.orig.write(i);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.orig.write(b);
            this.orig.flush();
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.orig.write(b, off, len);
            this.orig.flush();
        }

        @Override
        public void flush() throws IOException {
            this.orig.flush();
        }

        @Override
        public void close() throws IOException {
            this.orig.close();
        }
    }

    private static class LoggingOutputStream
    extends OutputStream {
        private final OutputStream orig;

        public LoggingOutputStream(OutputStream orig) {
            this.orig = orig;
        }

        @Override
        public void write(int i) throws IOException {
            LOG.debug("LoggingOutputStream.write(i=" + i + ")");
            this.orig.write(i);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            LOG.debug("LoggingOutputStream.write(b.length=" + b.length + ")");
            this.orig.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            LOG.debug("LoggingOutputStream.write(b, off=" + off + ", len=" + len + ")");
            this.orig.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            LOG.debug("LoggingOutputStream.flush()");
            this.orig.flush();
        }

        @Override
        public void close() throws IOException {
            LOG.debug("LoggingOutputStream.close()");
            this.orig.close();
        }
    }

    private static class LoggingInputStream
    extends InputStream {
        private final InputStream orig;

        public LoggingInputStream(InputStream orig) {
            this.orig = orig;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            LOG.debug("LoggingInputStream.read(b.length=" + b.length + ")");
            int res = this.orig.read(b);
            LOG.debug("LoggingInputStream.read(b.length=" + b.length + ") returns " + res);
            return res;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            LOG.debug("LoggingInputStream.read(b.length=" + b.length + ", off=" + off + ", len=" + len + ")");
            int res = this.orig.read(b, off, len);
            LOG.debug("LoggingInputStream.read(b.length=" + b.length + ", off=" + off + ", len=" + len + ") returns " + res);
            return res;
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            LOG.debug("LoggingInputStream.readAllBytes()");
            return this.orig.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            LOG.debug("LoggingInputStream.readNBytes(len=" + len + ")");
            return this.orig.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            LOG.debug("LoggingInputStream.readNBytes(b.length=" + b.length + ", off=" + off + ", len=" + len + ")");
            int res = this.orig.readNBytes(b, off, len);
            LOG.debug("LoggingInputStream.readNBytes(b.length=" + b.length + ", off=" + off + ", len=" + len + ") returns " + res);
            return res;
        }

        @Override
        public long skip(long n) throws IOException {
            LOG.debug("LoggingInputStream.skip(n=" + n + ")");
            return this.orig.skip(n);
        }

        @Override
        public int available() throws IOException {
            LOG.debug("LoggingInputStream.available()");
            return this.orig.available();
        }

        @Override
        public void close() throws IOException {
            LOG.debug("LoggingInputStream.close()");
            this.orig.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            LOG.debug("LoggingInputStream.mark(readlimit=" + readlimit + ")");
            this.orig.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            LOG.debug("LoggingInputStream.reset()");
            this.orig.reset();
        }

        @Override
        public boolean markSupported() {
            LOG.debug("LoggingInputStream.markSupported()");
            return this.orig.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            LOG.debug("LoggingInputStream.transferTo()");
            return this.orig.transferTo(out);
        }

        @Override
        public int read() throws IOException {
            LOG.debug("LoggingInputStream.read()");
            return this.orig.read();
        }
    }

    public static class DirectTCPIPChannel
    extends AbstractDirectChannel {
        protected final Parameters parameters;

        public DirectTCPIPChannel(Connection conn, Parameters parameters) {
            super(conn, "direct-tcpip");
            this.parameters = parameters;
        }

        @Override
        protected SSHPacket buildOpenReq() {
            return (SSHPacket)((SSHPacket)((SSHPacket)((SSHPacket)super.buildOpenReq().putString(this.parameters.getRemoteHost())).putUInt32(this.parameters.getRemotePort())).putString(this.parameters.getLocalHost())).putUInt32(this.parameters.getLocalPort());
        }
    }

    public static class SocketFactoryWithCustomSocketImplFactory
    extends SocketFactory {
        private final SocketImplFactory socketImplFactory;

        public SocketFactoryWithCustomSocketImplFactory(SocketImplFactory socketImplFactory) {
            this.socketImplFactory = socketImplFactory;
        }

        @Override
        public Socket createSocket() throws IOException {
            return new SocketWithCustomSocketFactory(this.socketImplFactory);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return new SocketWithCustomSocketFactory(this.socketImplFactory, host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new UnsupportedOperationException("No support for binding sockets to a local address and port");
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return new SocketWithCustomSocketFactory(this.socketImplFactory, host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new UnsupportedOperationException("No support for binding sockets to a local address and port");
        }
    }

    public static class SocketWithCustomSocketFactory
    extends Socket {
        public SocketWithCustomSocketFactory(SocketImplFactory socketImplFactory, String host, int port) throws IOException {
            super(socketImplFactory.createSocketImpl());
            this.connect(host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port));
        }

        public SocketWithCustomSocketFactory(SocketImplFactory socketImplFactory) throws SocketException {
            super(socketImplFactory.createSocketImpl());
        }

        public SocketWithCustomSocketFactory(SocketImplFactory socketImplFactory, InetAddress host, int port) throws IOException {
            super(socketImplFactory.createSocketImpl());
            this.connect(new InetSocketAddress(host, port));
        }
    }
}

