/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.sentry;

import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.config.PropertiesProvider;
import io.sentry.config.PropertiesProviderFactory;
import io.sentry.protocol.User;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SentryUtil.class);

    public static void initSentry() {
        JFedVersionInfo versionInfo = new JFedVersionInfo();
        PropertiesProvider sentryPropertiesProvider = PropertiesProviderFactory.create();
        Sentry.init(sentryOptions -> {
            String serverName;
            sentryOptions.setDsn(sentryPropertiesProvider.getProperty("dsn"));
            String release = sentryPropertiesProvider.getProperty("release");
            if (release == null || release.equalsIgnoreCase("none") || release.startsWith("${")) {
                sentryOptions.setRelease(null);
                LOG.warn("Could not set Sentry release: " + release);
            } else {
                sentryOptions.setRelease(release);
                LOG.info("Sentry release is set to \"" + release + "\"");
            }
            String environment = sentryPropertiesProvider.getProperty("environment");
            if (environment == null || environment.equalsIgnoreCase("none") || environment.startsWith("${")) {
                if (versionInfo.getEnvironment() != JFedVersionInfo.Environment.UNKNOWN) {
                    environment = versionInfo.getEnvironment().name().toLowerCase();
                    sentryOptions.setEnvironment(environment);
                    LOG.warn("Falling back to auto detected Sentry environment: " + environment);
                } else {
                    sentryOptions.setEnvironment(null);
                    LOG.warn("Could not set Sentry environment: " + environment);
                }
            } else {
                sentryOptions.setEnvironment(environment);
                LOG.info("Sentry environment is set to \"" + environment + "\"");
            }
            String dist = sentryPropertiesProvider.getProperty("dist");
            if (dist == null) {
                if (sentryOptions.getDist() == null) {
                    sentryOptions.setDist(System.getProperty("os.arch"));
                }
            } else {
                sentryOptions.setDist(dist);
            }
            if ((serverName = sentryPropertiesProvider.getProperty("servername")) == null) {
                if (sentryOptions.getServerName() == null) {
                    try {
                        sentryOptions.setServerName(InetAddress.getLocalHost().getHostName());
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else {
                sentryOptions.setServerName(serverName);
            }
            if (versionInfo.getEnvironment() != JFedVersionInfo.Environment.PRODUCTION) {
                sentryOptions.setDebug(true);
                sentryOptions.setDiagnosticLevel(SentryLevel.DEBUG);
            } else {
                sentryOptions.setDebug(true);
                sentryOptions.setDiagnosticLevel(SentryLevel.ERROR);
            }
            sentryOptions.addInAppInclude("be.imec");
            sentryOptions.addInAppInclude("be.iminds");
        });
        SentryUtil.setVersionContext(versionInfo);
    }

    public static void setUserContext(@Nullable GeniUser geniUser) {
        if (geniUser != null) {
            User user = new User();
            user.setId(geniUser.getUserUrnString());
            user.setEmail(geniUser.getCertEmail());
            HashMap<String, String> otherUserDate = new HashMap<String, String>();
            otherUserDate.put("expire", geniUser.getCertExpire() != null ? RFC3339Util.dateToRFC3339String(geniUser.getCertExpire()) : null);
            otherUserDate.put("urn", geniUser.getUserUrnString());
            otherUserDate.put("cert", geniUser.getClientCertificateChain() != null ? KeyUtil.x509certificateChainToPem(geniUser.getClientCertificateChain()) : null);
            user.setOthers(otherUserDate);
            user.setUsername(geniUser.getUserUrn() != null ? geniUser.getUserUrn().getResourceName() : null);
            Sentry.setUser(user);
        } else {
            Sentry.setUser(null);
        }
    }

    private static void setVersionContext(@Nonnull JFedVersionInfo versionInfo) {
        if (versionInfo.getGitBranch().startsWith("${env.")) {
            Sentry.setTag("git.branch", versionInfo.getGitBranch());
            assert (versionInfo.getEnvironment() == JFedVersionInfo.Environment.DEVELOP) : "versionInfo.getEnvironment()=" + versionInfo.getEnvironment() + " != DEVELOP for versionInfo.getGitBranch()=" + versionInfo.getGitBranch() + " and versionInfo.getVersion()=" + versionInfo.getVersion();
        }
        if (versionInfo.getGitCommit().startsWith("${env.")) {
            Sentry.setTag("git.commit", versionInfo.getGitCommit());
            assert (versionInfo.getEnvironment() == JFedVersionInfo.Environment.DEVELOP) : "versionInfo.getEnvironment()=" + versionInfo.getEnvironment() + " != DEVELOP for versionInfo.getGitCommit()=" + versionInfo.getGitCommit() + " and versionInfo.getVersion()=" + versionInfo.getVersion();
        }
        if (versionInfo.getCIBuild().startsWith("${env.")) {
            Sentry.setTag("build", versionInfo.getCIBuild());
            assert (versionInfo.getEnvironment() == JFedVersionInfo.Environment.DEVELOP) : "versionInfo.getEnvironment()=" + versionInfo.getEnvironment() + " != DEVELOP for versionInfo.getCIBuild()=" + versionInfo.getCIBuild() + " and versionInfo.getVersion()=" + versionInfo.getVersion();
        }
        if (versionInfo.getVersion().startsWith("${")) {
            Sentry.setTag("jfed.version", versionInfo.getVersion());
            assert (versionInfo.getEnvironment() == JFedVersionInfo.Environment.DEVELOP) : "versionInfo.getEnvironment()=" + versionInfo.getEnvironment() + " != DEVELOP for versionInfo.getVersion()=" + versionInfo.getVersion();
        }
        Sentry.setExtra("environment_string", JFedVersionInfo.getEnvironmentString());
        Sentry.setTag("device", System.getProperty("os.arch"));
        Sentry.setTag("OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
        Sentry.setTag("java.vendor", System.getProperty("java.vendor"));
        Sentry.setTag("java.version", System.getProperty("java.version"));
        Sentry.setTag("runtime", "java " + System.getProperty("java.version"));
        Sentry.setTag("jfed_auto_detected_environment", "" + versionInfo.getEnvironment());
    }

    @Nonnull
    public static String createSentryPreferences(@Nonnull JFedPreferences jFedPreferences) {
        if (jFedPreferences.getPropertiesFile() != null) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(jFedPreferences.getPropertiesFile().toPath(), Charset.defaultCharset());
                StringBuilder preferencesString = new StringBuilder();
                for (String line : lines) {
                    preferencesString.append(line).append("\n");
                }
                return preferencesString.toString();
            }
            catch (IOException e) {
                return "Exception reading user preferences file in createSentryPreferences(): " + e.getMessage();
            }
        }
        return "No properties file. (User without home dir?)\n";
    }
}

