/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi.strategies;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi.strategies.StatementNameStrategy;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.StatementContext;

public final class NameStrategies {
    public static final StatementNameStrategy CHECK_EMPTY = new CheckEmptyStrategy();
    public static final StatementNameStrategy CHECK_RAW = new CheckRawStrategy();
    public static final StatementNameStrategy SQL_OBJECT = new SqlObjectStrategy();
    public static final StatementNameStrategy NAIVE_NAME = new NaiveNameStrategy();
    public static final StatementNameStrategy CONTEXT_CLASS = new ContextClassStrategy();
    public static final StatementNameStrategy CONTEXT_NAME = new ContextNameStrategy();
    private static final String EMPTY_SQL = "sql.empty";
    static final String UNKNOWN_SQL = "sql.unknown";
    public static final String STATEMENT_CLASS = "_metric_class";
    public static final String STATEMENT_GROUP = "_metric_group";
    public static final String STATEMENT_TYPE = "_metric_type";
    public static final String STATEMENT_NAME = "_metric_name";

    private static String forRawSql(String rawSql) {
        return MetricRegistry.name("sql", "raw", rawSql);
    }

    private NameStrategies() {
    }

    static final class ContextNameStrategy
    implements StatementNameStrategy {
        private static final Pattern SHORT_PATTERN = Pattern.compile("^(.*?)/(.*?)(-sql)?\\.st(g)?$");

        private ContextNameStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            Object groupObj = statementContext.getAttribute(NameStrategies.STATEMENT_GROUP);
            Object typeObj = statementContext.getAttribute(NameStrategies.STATEMENT_TYPE);
            Object nameObj = statementContext.getAttribute(NameStrategies.STATEMENT_NAME);
            if (groupObj == null || nameObj == null) {
                return null;
            }
            String group = (String)groupObj;
            String statementName = (String)nameObj;
            if (typeObj == null) {
                Matcher matcher = SHORT_PATTERN.matcher(group);
                if (matcher.matches()) {
                    String groupName = matcher.group(1);
                    String typeName = matcher.group(2);
                    return MetricRegistry.name(groupName, typeName, statementName);
                }
                return MetricRegistry.name(group, statementName, "");
            }
            String type = (String)typeObj;
            return MetricRegistry.name(group, type, statementName);
        }
    }

    static final class ContextClassStrategy
    implements StatementNameStrategy {
        private ContextClassStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            Object classObj = statementContext.getAttribute(NameStrategies.STATEMENT_CLASS);
            Object nameObj = statementContext.getAttribute(NameStrategies.STATEMENT_NAME);
            if (classObj == null || nameObj == null) {
                return null;
            }
            String className = (String)classObj;
            String statementName = (String)nameObj;
            int dotPos = className.lastIndexOf(46);
            if (dotPos == -1) {
                return null;
            }
            return MetricRegistry.name(className.substring(0, dotPos), className.substring(dotPos + 1), statementName);
        }
    }

    static final class SqlObjectStrategy
    implements StatementNameStrategy {
        private SqlObjectStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            Class<?> clazz = statementContext.getSqlObjectType();
            Method method = statementContext.getSqlObjectMethod();
            if (clazz != null) {
                String rawSql = statementContext.getRawSql();
                String group = clazz.getPackage().getName();
                String name = clazz.getSimpleName();
                String type = method == null ? rawSql : method.getName();
                return MetricRegistry.name(group, name, type);
            }
            return null;
        }
    }

    static final class NaiveNameStrategy
    implements StatementNameStrategy {
        private NaiveNameStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            int colon = rawSql.indexOf(58);
            if (colon == -1) {
                return NameStrategies.forRawSql(rawSql);
            }
            String group = rawSql.substring(0, colon);
            String name = rawSql.substring(colon + 1);
            return MetricRegistry.name(group, name);
        }
    }

    static final class CheckRawStrategy
    implements StatementNameStrategy {
        private CheckRawStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            if (ClasspathStatementLocator.looksLikeSql(rawSql)) {
                return NameStrategies.forRawSql(rawSql);
            }
            return null;
        }
    }

    static final class CheckEmptyStrategy
    implements StatementNameStrategy {
        private CheckEmptyStrategy() {
        }

        @Override
        public String getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            if (rawSql == null || rawSql.length() == 0) {
                return NameStrategies.EMPTY_SQL;
            }
            return null;
        }
    }
}

