/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

class SafeInstantDeserializer<T extends Temporal>
extends InstantDeserializer<T> {
    private static final BigDecimal MAX_INSTANT = new BigDecimal(Instant.MAX.getEpochSecond() + 1L);
    private static final BigDecimal MIN_INSTANT = new BigDecimal(Instant.MIN.getEpochSecond());

    SafeInstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<InstantDeserializer.FromIntegerArguments, T> fromMilliseconds, Function<InstantDeserializer.FromDecimalArguments, T> fromNanoseconds, @Nullable BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ) {
        super(supportedType, formatter, parsedToValue, fromMilliseconds, fromNanoseconds, adjust, replaceZeroOffsetAsZ);
    }

    @Override
    protected T _fromDecimal(DeserializationContext context, BigDecimal value) {
        if (value.compareTo(MAX_INSTANT) >= 0 || value.compareTo(MIN_INSTANT) < 0) {
            throw new IllegalArgumentException("Value is out of range of Instant");
        }
        return super._fromDecimal(context, value);
    }
}

