/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.module.paramnames.PackageVersion;
import io.dropwizard.jackson.SafeDurationDeserializer;
import io.dropwizard.jackson.SafeInstantDeserializer;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

class SafeJavaTimeModule
extends SimpleModule {
    private static final InstantDeserializer<Instant> INSTANT = new SafeInstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);
    private static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new SafeInstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
    private static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new SafeInstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant, false);

    SafeJavaTimeModule() {
        super(PackageVersion.VERSION);
        this.addDeserializer(Instant.class, INSTANT);
        this.addDeserializer(OffsetDateTime.class, OFFSET_DATE_TIME);
        this.addDeserializer(ZonedDateTime.class, ZONED_DATE_TIME);
        this.addDeserializer(Duration.class, new SafeDurationDeserializer());
    }
}

