/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.InstantArgument;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class GuavaOptionalInstantArgumentFactory
implements ArgumentFactory<com.google.common.base.Optional<Instant>> {
    private final Optional<Calendar> calendar;

    public GuavaOptionalInstantArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public GuavaOptionalInstantArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof com.google.common.base.Optional) {
            com.google.common.base.Optional optionalValue = (com.google.common.base.Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof Instant;
        }
        return false;
    }

    @Override
    public Argument build(Class<?> expectedType, com.google.common.base.Optional<Instant> value, StatementContext ctx) {
        return new InstantArgument(value.get(), this.calendar);
    }
}

