/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class JodaDateTimeMapper
implements ResultColumnMapper<DateTime> {
    private Optional<Calendar> calendar;

    public JodaDateTimeMapper() {
        this.calendar = Optional.empty();
    }

    public JodaDateTimeMapper(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    private Calendar cloneCalendar() {
        return (Calendar)this.calendar.get().clone();
    }

    @Override
    @Nullable
    public DateTime mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Timestamp timestamp;
        Timestamp timestamp2 = timestamp = this.calendar.isPresent() ? r.getTimestamp(columnNumber, this.cloneCalendar()) : r.getTimestamp(columnNumber);
        if (timestamp == null) {
            return null;
        }
        return new DateTime(timestamp.getTime());
    }

    @Override
    @Nullable
    public DateTime mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Timestamp timestamp;
        Timestamp timestamp2 = timestamp = this.calendar.isPresent() ? r.getTimestamp(columnLabel, this.cloneCalendar()) : r.getTimestamp(columnLabel);
        if (timestamp == null) {
            return null;
        }
        return new DateTime(timestamp.getTime());
    }
}

