/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;

@Singleton
public class OptionalParamConverterProvider
implements ParamConverterProvider {
    private final ServiceLocator locator;

    @Inject
    public OptionalParamConverterProvider(ServiceLocator locator) {
        this.locator = locator;
    }

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Optional.class.equals(rawType)) {
            ClassTypePair ctp;
            List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(genericType);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        return rawType.cast(Optional.ofNullable(value));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
            for (ParamConverterProvider provider : Providers.getProviders(this.locator, ParamConverterProvider.class)) {
                final ParamConverter<?> converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                if (converter == null) continue;
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        return rawType.cast(Optional.ofNullable(value).map(s2 -> converter.fromString(value)));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
        }
        return null;
    }
}

