/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationInfo
extends ScanResultObject
implements Comparable<AnnotationInfo> {
    private String name;
    private List<AnnotationParameterValue> annotationParamValues;
    private transient List<AnnotationParameterValue> annotationParamValuesWithDefaults;

    AnnotationInfo() {
    }

    AnnotationInfo(String name, List<AnnotationParameterValue> annotationParamValues) {
        this.name = name;
        this.annotationParamValues = annotationParamValues;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInherited() {
        return this.getClassInfo().isInherited;
    }

    public List<AnnotationParameterValue> getDefaultParameterValues() {
        return this.getClassInfo().getAnnotationDefaultParameterValues();
    }

    public List<AnnotationParameterValue> getParameterValues() {
        if (this.annotationParamValuesWithDefaults == null) {
            ClassInfo classInfo = this.getClassInfo();
            if (classInfo == null) {
                return this.annotationParamValues;
            }
            List<AnnotationParameterValue> defaultParamValues = classInfo.annotationDefaultParamValues;
            if (defaultParamValues == null && this.annotationParamValues == null) {
                return Collections.emptyList();
            }
            if (defaultParamValues == null) {
                return this.annotationParamValues;
            }
            if (this.annotationParamValues == null) {
                return defaultParamValues;
            }
            HashMap<String, Object> allParamValues = new HashMap<String, Object>();
            for (AnnotationParameterValue annotationParameterValue : defaultParamValues) {
                allParamValues.put(annotationParameterValue.getName(), annotationParameterValue.getValue());
            }
            for (AnnotationParameterValue annotationParameterValue : this.annotationParamValues) {
                allParamValues.put(annotationParameterValue.getName(), annotationParameterValue.getValue());
            }
            this.annotationParamValuesWithDefaults = new ArrayList<AnnotationParameterValue>();
            for (Map.Entry entry : allParamValues.entrySet()) {
                this.annotationParamValuesWithDefaults.add(new AnnotationParameterValue((String)entry.getKey(), entry.getValue()));
            }
            Collections.sort(this.annotationParamValuesWithDefaults);
        }
        return this.annotationParamValuesWithDefaults;
    }

    @Override
    protected String getClassName() {
        return this.name;
    }

    @Override
    public ClassInfo getClassInfo() {
        this.getClassName();
        return super.getClassInfo();
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.annotationParamValues != null) {
            for (AnnotationParameterValue a : this.annotationParamValues) {
                if (a == null) continue;
                a.setScanResult(scanResult);
            }
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNames) {
        classNames.add(this.name);
        if (this.annotationParamValues != null) {
            for (AnnotationParameterValue annotationParamValue : this.annotationParamValues) {
                annotationParamValue.getClassNamesFromTypeDescriptors(classNames);
            }
        }
    }

    @Override
    public int compareTo(AnnotationInfo o) {
        int diff = this.getName().compareTo(o.getName());
        if (diff != 0) {
            return diff;
        }
        if (this.annotationParamValues == null && o.annotationParamValues == null) {
            return 0;
        }
        if (this.annotationParamValues == null) {
            return -1;
        }
        if (o.annotationParamValues == null) {
            return 1;
        }
        int max = Math.max(this.annotationParamValues.size(), o.annotationParamValues.size());
        for (int i = 0; i < max; ++i) {
            if (i >= this.annotationParamValues.size()) {
                return -1;
            }
            if (i >= o.annotationParamValues.size()) {
                return 1;
            }
            int diff2 = this.annotationParamValues.get(i).compareTo(o.annotationParamValues.get(i));
            if (diff2 == 0) continue;
            return diff2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationInfo)) {
            return false;
        }
        AnnotationInfo o = (AnnotationInfo)obj;
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int h2 = this.getName().hashCode();
        if (this.annotationParamValues != null) {
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                AnnotationParameterValue e = this.annotationParamValues.get(i);
                h2 = h2 * 7 + e.getName().hashCode() * 3 + e.getValue().hashCode();
            }
        }
        return h2;
    }

    void toString(StringBuilder buf) {
        buf.append("@" + this.getName());
        List<AnnotationParameterValue> paramVals = this.getParameterValues();
        if (paramVals != null && !paramVals.isEmpty()) {
            buf.append('(');
            for (int i = 0; i < paramVals.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                AnnotationParameterValue annotationParamValue = paramVals.get(i);
                if (paramVals.size() > 1 || !"value".equals(annotationParamValue.getName())) {
                    annotationParamValue.toString(buf);
                    continue;
                }
                annotationParamValue.toStringParamValueOnly(buf);
            }
            buf.append(')');
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }
}

