/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.MethodInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MethodInfoList
extends ArrayList<MethodInfo> {
    static final MethodInfoList EMPTY_LIST = new MethodInfoList(){

        @Override
        public boolean add(MethodInfo e) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void add(int index, MethodInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public MethodInfo remove(int index) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(Collection<? extends MethodInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends MethodInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public MethodInfo set(int index, MethodInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }
    };

    MethodInfoList() {
    }

    MethodInfoList(int sizeHint) {
        super(sizeHint);
    }

    MethodInfoList(Collection<MethodInfo> methodInfoCollection) {
        super(methodInfoCollection);
    }

    public List<String> getNames() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> methodNames = new ArrayList<String>(this.size());
        for (MethodInfo mi : this) {
            methodNames.add(mi.getName());
        }
        return methodNames;
    }

    public List<String> getAsStrings() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> toStringVals = new ArrayList<String>(this.size());
        for (MethodInfo mi : this) {
            toStringVals.add(mi.toString());
        }
        return toStringVals;
    }

    public boolean containsName(String methodName) {
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public MethodInfoList get(String methodName) {
        boolean hasMethodWithName = false;
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            hasMethodWithName = true;
            break;
        }
        if (!hasMethodWithName) {
            return EMPTY_LIST;
        }
        MethodInfoList matchingMethods = new MethodInfoList(2);
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            matchingMethods.add(mi);
        }
        return matchingMethods;
    }

    public MethodInfo getSingleMethod(String methodName) {
        int numMethodsWithName = 0;
        MethodInfo lastFoundMethod = null;
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            ++numMethodsWithName;
            lastFoundMethod = mi;
        }
        if (numMethodsWithName == 0) {
            return null;
        }
        if (numMethodsWithName == 1) {
            return lastFoundMethod;
        }
        throw new IllegalArgumentException("There are multiple methods named \"" + methodName + "\" in class " + ((MethodInfo)this.iterator().next()).getName());
    }

    public MethodInfoList filter(MethodInfoFilter filter) {
        MethodInfoList methodInfoFiltered = new MethodInfoList();
        for (MethodInfo resource : this) {
            if (!filter.accept(resource)) continue;
            methodInfoFiltered.add(resource);
        }
        return methodInfoFiltered;
    }

    @FunctionalInterface
    public static interface MethodInfoFilter {
        public boolean accept(MethodInfo var1);
    }
}

