/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.yaml;

import java.beans.IntrospectionException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import liquibase.change.ConstraintsConfig;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.LiquibaseSerializer;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.GenericProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public abstract class YamlSerializer
implements LiquibaseSerializer {
    protected Yaml yaml = this.createYaml();

    protected Yaml createYaml() {
        if (this.isJson()) {
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setPrettyFlow(true);
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
            dumperOptions.setWidth(Integer.MAX_VALUE);
            return new Yaml(this.getLiquibaseRepresenter(), dumperOptions);
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(this.getLiquibaseRepresenter(), dumperOptions);
    }

    protected LiquibaseRepresenter getLiquibaseRepresenter() {
        return new LiquibaseRepresenter();
    }

    protected boolean isJson() {
        return "json".equals(this.getValidFileExtensions()[0]);
    }

    @Override
    public String[] getValidFileExtensions() {
        return new String[]{"yaml", "yml"};
    }

    @Override
    public String serialize(LiquibaseSerializable object, boolean pretty) {
        if (this.isJson()) {
            String out = this.yaml.dumpAs(this.toMap(object), Tag.MAP, DumperOptions.FlowStyle.FLOW);
            return this.removeClassTypeMarksFromSerializedJson(out);
        }
        return this.yaml.dumpAsMap(this.toMap(object));
    }

    protected Object toMap(LiquibaseSerializable object) {
        Comparator<String> comparator = this.getComparator(object);
        TreeMap objectMap = new TreeMap(comparator);
        for (String field : object.getSerializableFields()) {
            Object value = object.getSerializableFieldValue(field);
            if (value == null) continue;
            if (value instanceof DataType) {
                value = ((Map)this.toMap((DataType)value)).values().iterator().next();
            }
            if (value instanceof Column.AutoIncrementInformation) {
                value = ((Map)this.toMap((Column.AutoIncrementInformation)value)).values().iterator().next();
            }
            if (value instanceof ConstraintsConfig) {
                value = ((Map)this.toMap((ConstraintsConfig)value)).values().iterator().next();
            }
            if (value instanceof LiquibaseSerializable) {
                value = this.toMap((LiquibaseSerializable)value);
            }
            if (value instanceof Collection) {
                ArrayList<Object> valueAsList = new ArrayList<Object>((Collection)value);
                if (valueAsList.isEmpty()) continue;
                for (int i = 0; i < valueAsList.size(); ++i) {
                    if (!(valueAsList.get(i) instanceof LiquibaseSerializable)) continue;
                    valueAsList.set(i, this.toMap((LiquibaseSerializable)valueAsList.get(i)));
                }
                value = valueAsList;
            }
            if (value instanceof Map) {
                if (((Map)value).isEmpty()) continue;
                for (Object key : ((Map)value).keySet()) {
                    ArrayList<Object> valueAsList;
                    Object mapValue = ((Map)value).get(key);
                    if (mapValue instanceof LiquibaseSerializable) {
                        ((Map)value).put(key, this.toMap((LiquibaseSerializable)mapValue));
                        continue;
                    }
                    if (!(mapValue instanceof Collection) || (valueAsList = new ArrayList<Object>((Collection)mapValue)).isEmpty()) continue;
                    for (int i = 0; i < valueAsList.size(); ++i) {
                        if (!(valueAsList.get(i) instanceof LiquibaseSerializable)) continue;
                        valueAsList.set(i, this.toMap((LiquibaseSerializable)valueAsList.get(i)));
                    }
                    ((Map)value).put(key, valueAsList);
                }
            }
            objectMap.put(field, value);
        }
        HashMap containerMap = new HashMap();
        containerMap.put(object.getSerializedObjectName(), objectMap);
        return containerMap;
    }

    protected Comparator<String> getComparator(LiquibaseSerializable object) {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
    }

    private String removeClassTypeMarksFromSerializedJson(String json) {
        json = json.replaceAll("!!int \"(\\d+)\"", "$1");
        json = json.replaceAll("!!bool \"(\\w+)\"", "$1");
        json = json.replaceAll("!!timestamp \"([^\"]*)\"", "$1");
        json = json.replaceAll("!!float \"([^\"]*)\"", "$1");
        if ((json = json.replaceAll("!!liquibase.[^\\s]+ (\"\\w+\")", "$1")).contains("!!")) {
            throw new IllegalStateException(String.format("Serialize failed. Illegal char on %s position: %s", json.indexOf("!!"), json));
        }
        return json;
    }

    public static class LiquibaseRepresenter
    extends Representer {
        public LiquibaseRepresenter() {
            this.init();
        }

        protected void init() {
            this.multiRepresenters.put(DatabaseFunction.class, new AsStringRepresenter());
            this.multiRepresenters.put(SequenceNextValueFunction.class, new AsStringRepresenter());
            this.multiRepresenters.put(SequenceCurrentValueFunction.class, new AsStringRepresenter());
        }

        @Override
        protected Tag getTag(Class<?> clazz, Tag defaultTag) {
            return super.getTag(clazz, defaultTag);
        }

        @Override
        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            return super.representJavaBean(properties, javaBean);
        }

        @Override
        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        @Override
        public Node represent(Object data) {
            return super.represent(data);
        }

        @Override
        protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
            LiquibaseSerializable serialzableType;
            HashSet<Property> returnSet;
            block5: {
                returnSet = new HashSet<Property>();
                serialzableType = null;
                try {
                    if (type.equals(ChangeSet.class)) {
                        serialzableType = new ChangeSet("x", "y", false, false, null, null, null, null);
                        break block5;
                    }
                    if (LiquibaseSerializable.class.isAssignableFrom(type)) {
                        serialzableType = (LiquibaseSerializable)type.newInstance();
                        break block5;
                    }
                    return super.getProperties(type);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new UnexpectedLiquibaseException(e);
                }
            }
            for (String property : serialzableType.getSerializableFields()) {
                LiquibaseSerializable.SerializationType fieldType = serialzableType.getSerializableFieldType(property);
                returnSet.add(new LiquibaseProperty(property, String.class, (Type)((Object)String.class)));
            }
            return returnSet;
        }

        private class AsStringRepresenter
        implements Represent {
            private AsStringRepresenter() {
            }

            @Override
            public Node representData(Object data) {
                return LiquibaseRepresenter.this.representScalar(Tag.STR, data.toString());
            }
        }

        private static class LiquibaseProperty
        extends GenericProperty {
            private LiquibaseProperty(String name, Class<?> aClass, Type aType) {
                super(name, aClass, aType);
            }

            @Override
            public void set(Object object, Object value) throws Exception {
            }

            @Override
            public Object get(Object object) {
                return ((LiquibaseSerializable)object).getSerializableFieldValue(this.getName());
            }
        }
    }
}

