/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthProblemException
extends OAuthException {
    public static final String OAUTH_PROBLEM = "oauth_problem";
    public static final String HTTP_REQUEST = "HTTP request";
    public static final String HTTP_RESPONSE = "HTTP response";
    public static final String HTTP_STATUS_CODE = "HTTP status";
    public static final String HTTP_LOCATION = "Location";
    public static final String SIGNATURE_BASE_STRING = "oauth_signature base string";
    public static final String URL = "URL";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private static final long serialVersionUID = 1L;

    public OAuthProblemException() {
    }

    public OAuthProblemException(String problem) {
        super(problem);
        if (problem != null) {
            this.parameters.put(OAUTH_PROBLEM, problem);
        }
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        msg = this.getProblem();
        if (msg != null) {
            return msg;
        }
        Object response = this.getParameters().get(HTTP_RESPONSE);
        if (response != null) {
            msg = response.toString();
            int eol = msg.indexOf("\n");
            if (eol < 0) {
                eol = msg.indexOf("\r");
            }
            if (eol >= 0) {
                msg = msg.substring(0, eol);
            }
            if ((msg = msg.trim()).length() > 0) {
                return msg;
            }
        }
        if ((response = Integer.valueOf(this.getHttpStatusCode())) != null) {
            return "HTTP status " + response;
        }
        return null;
    }

    public void setParameter(String name, Object value) {
        this.getParameters().put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getProblem() {
        return (String)this.getParameters().get(OAUTH_PROBLEM);
    }

    public int getHttpStatusCode() {
        Object code = this.getParameters().get(HTTP_STATUS_CODE);
        if (code == null) {
            return 200;
        }
        if (code instanceof Number) {
            return ((Number)code).intValue();
        }
        return Integer.parseInt(code.toString());
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder(super.toString());
        try {
            String eol = System.getProperty("line.separator", "\n");
            Map<String, Object> parameters = this.getParameters();
            for (String key : new String[]{"oauth_problem_advice", URL, SIGNATURE_BASE_STRING}) {
                Object value = parameters.get(key);
                if (value == null) continue;
                s2.append(eol + key + ": " + value);
            }
            Object msg = parameters.get(HTTP_REQUEST);
            if (msg != null) {
                s2.append(eol + ">>>>>>>> " + HTTP_REQUEST + ":" + eol + msg);
            }
            if ((msg = parameters.get(HTTP_RESPONSE)) != null) {
                s2.append(eol + "<<<<<<<< " + HTTP_RESPONSE + ":" + eol + msg);
            } else {
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    String key;
                    key = parameter.getKey();
                    if ("oauth_problem_advice".equals(key) || URL.equals(key) || SIGNATURE_BASE_STRING.equals(key) || HTTP_REQUEST.equals(key) || HTTP_RESPONSE.equals(key)) continue;
                    s2.append(eol + key + ": " + parameter.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s2.toString();
    }
}

