/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignatureDSA;
import net.schmizz.sshj.signature.Signature;

public class SignatureDSA
extends AbstractSignatureDSA {
    public SignatureDSA() {
        super("SHA1withDSA", KeyType.DSA.toString());
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r = new byte[rLen];
        System.arraycopy(sig, rIndex, r, 0, r.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s2 = new byte[sLen];
        System.arraycopy(sig, sIndex, s2, 0, s2.length);
        byte[] result = new byte[40];
        int r_copylen = Math.min(r.length, 20);
        int s_copylen = Math.min(s2.length, 20);
        System.arraycopy(r, r.length - r_copylen, result, 20 - r_copylen, r_copylen);
        System.arraycopy(s2, s2.length - s_copylen, result, 40 - s_copylen, s_copylen);
        return result;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, "ssh-dss");
            BigInteger r = new BigInteger(1, Arrays.copyOfRange(sigBlob, 0, 20));
            BigInteger s2 = new BigInteger(1, Arrays.copyOfRange(sigBlob, 20, 40));
            return this.signature.verify(this.encodeAsnSignature(r, s2));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureDSA();
        }

        @Override
        public String getName() {
            return KeyType.DSA.toString();
        }
    }
}

