/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.data.Index;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ExtendedByTypesComparator;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrayElementComparisonStrategy;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.RecursiveFieldByFieldComparator;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractObjectArrayAssert<SELF extends AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT>
extends AbstractAssert<SELF, ELEMENT[]>
implements IndexedObjectEnumerableAssert<AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT>,
ArraySortedAssert<AbstractObjectArrayAssert<SELF, ELEMENT>, ELEMENT> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();
    @VisibleForTesting
    Iterables iterables = Iterables.instance();
    private TypeComparators comparatorsByType = TypeComparators.defaultTypeComparators();
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new TreeMap();
    private TypeComparators comparatorsForElementPropertyOrFieldTypes = TypeComparators.defaultTypeComparators();

    public AbstractObjectArrayAssert(ELEMENT[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF as(Description description) {
        return (SELF)((AbstractObjectArrayAssert)super.as(description));
    }

    @Override
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractObjectArrayAssert)super.as(description, args));
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsOnly(ELEMENT ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsOnlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsOnlyNulls() {
        this.arrays.assertContainsOnlyNulls(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    public void hasOnlyOneElementSatisfying(Consumer<ELEMENT> elementAssertions) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, 1);
        elementAssertions.accept(((Object[])this.actual)[0]);
    }

    @Override
    public SELF hasSameElementsAs(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnlyElementsOf((Iterable)iterable);
    }

    @Override
    public SELF containsOnlyOnce(ELEMENT ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactly(ELEMENT ... values) {
        this.arrays.assertContainsExactly(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrder(ELEMENT ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrderElementsOf(Iterable<? extends ELEMENT> values) {
        return (SELF)this.containsExactlyInAnyOrder((Object[])IterableUtil.toArray(values));
    }

    @Override
    public SELF containsExactlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsSequence(ELEMENT ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(ELEMENT ... sequence) {
        this.arrays.assertDoesNotContainSequence(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertDoesNotContainSequence(this.info, (Object[])this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(ELEMENT ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, subsequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(ELEMENT ... subsequence) {
        this.arrays.assertDoesNotContainSubsequence(this.info, (Object[])this.actual, subsequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertDoesNotContainSubsequence(this.info, (Object[])this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfTypes(Class<?> ... types) {
        this.arrays.assertHasOnlyElementsOfTypes(this.info, (Object[])this.actual, types);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        this.arrays.assertDoesNotContainAnyElementsOf(this.info, (Object[])this.actual, iterable);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF startsWith(ELEMENT ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT[] sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT first, ELEMENT ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, first, sequence);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(Iterable<? extends ELEMENT> values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(ELEMENT ... values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, java.util.Arrays.asList(values));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF are(Condition<? super ELEMENT> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areNot(Condition<? super ELEMENT> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF have(Condition<? super ELEMENT> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doNotHave(Condition<? super ELEMENT> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtLeastOne(Condition<? super ELEMENT> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areAtMost(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF areExactly(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveAtLeastOne(Condition<? super ELEMENT> condition) {
        return (SELF)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public SELF haveAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveAtMost(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF haveExactly(int times, Condition<? super ELEMENT> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasAtLeastOneElementOfType(Class<?> type) {
        this.arrays.assertHasAtLeastOneElementOfType(this.info, (Object[])this.actual, type);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfType(Class<?> type) {
        this.arrays.assertHasOnlyElementsOfType(this.info, (Object[])this.actual, type);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveAnyElementsOfTypes(Class<?> ... unexpectedTypes) {
        this.arrays.assertDoesNotHaveAnyElementsOfTypes(this.info, (Object[])this.actual, unexpectedTypes);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super ELEMENT> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsAll(Iterable<? extends ELEMENT> iterable) {
        this.arrays.assertContainsAll(this.info, (Object[])this.actual, iterable);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super ELEMENT> elementComparator) {
        this.arrays = new ObjectArrays(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new ObjectArrayElementComparisonStrategy<ELEMENT>(elementComparator));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    private SELF usingExtendedByTypesElementComparator(Comparator<Object> elementComparator) {
        return (SELF)this.usingElementComparator((Comparator)new ExtendedByTypesComparator(elementComparator, this.comparatorsByType));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForElementFieldsWithNames(Comparator<C> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForElementFieldsWithType(Comparator<C> comparator, Class<C> type) {
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public <C> SELF usingComparatorForType(Comparator<C> comparator, Class<C> type) {
        if (this.arrays.getComparator() == null) {
            this.usingElementComparator((Comparator)new ExtendedByTypesComparator(this.comparatorsByType));
        }
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        this.comparatorsByType.put(type, comparator);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    @CheckReturnValue
    public SELF usingElementComparatorOnFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    @CheckReturnValue
    public SELF usingElementComparatorIgnoringFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(String fieldOrProperty) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstance(Lists.newArrayList(values)).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extracting(String fieldOrProperty, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstance(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), Extractors.byName(propertiesOrFields));
        String extractedDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstance(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <U> AbstractListAssert<?, List<? extends U>, U, ObjectAssert<U>> extracting(Extractor<? super ELEMENT, U> extractor) {
        List<U> values = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), extractor);
        return this.newListAssertInstance(values);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extracting(ThrowingExtractor<? super ELEMENT, V, EXCEPTION> extractor) {
        List values = FieldsOrPropertiesExtractor.extract(Lists.newArrayList((Object[])this.actual), extractor);
        return this.newListAssertInstance(values);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(Function<ELEMENT, ?> ... extractors) {
        Function<Object, Tuple> tupleExtractor = objectToExtractValueFrom -> new Tuple(Stream.of(extractors).map(extractor -> extractor.apply(objectToExtractValueFrom)).toArray());
        List tuples = java.util.Arrays.stream((Object[])this.actual).map(tupleExtractor).collect(Collectors.toList());
        return this.newListAssertInstance(tuples).as(this.info.description());
    }

    @CheckReturnValue
    public <V, C extends Collection<V>> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(Extractor<? super ELEMENT, C> extractor) {
        return this.doFlatExtracting(extractor);
    }

    @CheckReturnValue
    public <V, C extends Collection<V>, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(ThrowingExtractor<? super ELEMENT, C, EXCEPTION> extractor) {
        return this.doFlatExtracting(extractor);
    }

    private <V, C extends Collection<V>> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> doFlatExtracting(Extractor<? super ELEMENT, C> extractor) {
        List<Collection> extractedValues = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), extractor);
        ArrayList result = Lists.newArrayList();
        for (Collection e : extractedValues) {
            result.addAll(e);
        }
        return this.newListAssertInstance(result);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String propertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), Extractors.byName(propertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return this.newListAssertInstance(extractedValues);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extractingResultOf(String method) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstance(Lists.newArrayList(values)).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extractingResultOf(String method, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstance(Lists.newArrayList(values)).as(description, new Object[0]);
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractObjectArrayAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractObjectArrayAssert)super.inBinary());
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> filteredOn(String propertyOrFieldName, Object expectedValue) {
        Iterable<Object> filteredIterable = Filters.filter((Object[])this.actual).with(propertyOrFieldName, expectedValue).get();
        return this.newListAssertInstance(Lists.newArrayList(filteredIterable));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> filteredOnNull(String propertyOrFieldName) {
        Iterable<Object> filteredIterable = Filters.filter((Object[])this.actual).with(propertyOrFieldName, null).get();
        return this.newListAssertInstance(Lists.newArrayList(filteredIterable));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters<Object> filter = Filters.filter((Object[])this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return this.newListAssertInstance(Lists.newArrayList(filter.get()));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> filteredOn(Condition<? super ELEMENT> condition) {
        Iterable<? super ELEMENT> filteredIterable = Filters.filter((Object[])this.actual).being(condition).get();
        return this.newListAssertInstance(Lists.newArrayList(filteredIterable));
    }

    public AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> filteredOn(Predicate<? super ELEMENT> predicate) {
        Preconditions.checkArgument(predicate != null, "The filter predicate should not be null", new Object[0]);
        List filtered = java.util.Arrays.stream((Object[])this.actual).filter(predicate).collect(Collectors.toList());
        return this.newListAssertInstance(filtered);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAllMatch(this.info, Lists.newArrayList((Object[])this.actual), predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate, String predicateDescription) {
        this.iterables.assertAllMatch(this.info, Lists.newArrayList((Object[])this.actual), predicate, new PredicateDescription(predicateDescription));
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF allSatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAllSatisfy(this.info, Lists.newArrayList((Object[])this.actual), requirements);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF anyMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAnyMatch(this.info, Lists.newArrayList((Object[])this.actual), predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    public <OTHER_ELEMENT> SELF zipSatisfy(OTHER_ELEMENT[] other, BiConsumer<? super ELEMENT, OTHER_ELEMENT> zipRequirements) {
        this.iterables.assertZipSatisfy(this.info, Lists.newArrayList((Object[])this.actual), Lists.newArrayList(other), zipRequirements);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF anySatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAnySatisfy(this.info, Lists.newArrayList((Object[])this.actual), requirements);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsAnyOf(ELEMENT ... values) {
        this.arrays.assertContainsAnyOf(this.info, (Object[])this.actual, values);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public SELF containsAnyElementsOf(Iterable<ELEMENT> iterable) {
        return (SELF)this.containsAnyOf((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF noneMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertNoneMatch(this.info, Lists.newArrayList((Object[])this.actual), predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    protected <E> AbstractListAssert<?, List<? extends E>, E, ObjectAssert<E>> newListAssertInstance(List<? extends E> newActual) {
        return new ListAssert<E>(newActual);
    }
}

