/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.matcher;

import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public class MethodSortMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final Sort sort;

    public MethodSortMatcher(Sort sort) {
        this.sort = sort;
    }

    @Override
    public boolean matches(T target) {
        return this.sort.isSort((MethodDescription)target);
    }

    public String toString() {
        return this.sort.getDescription();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSortMatcher)) {
            return false;
        }
        MethodSortMatcher other = (MethodSortMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Sort this$sort = this.sort;
        Sort other$sort = other.sort;
        return !(this$sort == null ? other$sort != null : !((Object)((Object)this$sort)).equals((Object)other$sort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodSortMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Sort $sort = this.sort;
        result = result * 59 + ($sort == null ? 43 : ((Object)((Object)$sort)).hashCode());
        return result;
    }

    public static enum Sort {
        METHOD("isMethod()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isMethod();
            }
        }
        ,
        CONSTRUCTOR("isConstructor()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isConstructor();
            }
        }
        ,
        TYPE_INITIALIZER("isTypeInitializer()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isTypeInitializer();
            }
        }
        ,
        VIRTUAL("isVirtual()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isVirtual();
            }
        }
        ,
        DEFAULT_METHOD("isDefaultMethod()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isDefaultMethod();
            }
        };

        private final String description;

        private Sort(String description) {
            this.description = description;
        }

        protected abstract boolean isSort(MethodDescription var1);

        protected String getDescription() {
            return this.description;
        }

        public String toString() {
            return "MethodSortMatcher.Sort." + this.name();
        }
    }
}

