/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

abstract class MemberUtils {
    private static final int ACCESS_TEST = 7;

    MemberUtils() {
    }

    static void setAccessibleWorkaround(AccessibleObject o) {
        if (o == null || o.isAccessible()) {
            return;
        }
        Member m3 = (Member)((Object)o);
        if (Modifier.isPublic(m3.getModifiers()) && MemberUtils.isPackageAccess(m3.getDeclaringClass().getModifiers())) {
            try {
                o.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static boolean isPackageAccess(int modifiers) {
        return (modifiers & 7) == 0;
    }

    static boolean isAccessible(Member m3) {
        return m3 != null && Modifier.isPublic(m3.getModifiers()) && !m3.isSynthetic();
    }
}

