/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.inmemory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.util.concurrent.MoreExecutors;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class InMemoryConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(InMemoryConnector.class.getName());
    private final URI baseUri;
    private final ApplicationHandler appHandler;

    private InMemoryConnector(URI baseUri, ApplicationHandler appHandler) {
        this.baseUri = baseUri;
        this.appHandler = appHandler;
    }

    @Override
    public ClientResponse apply(final ClientRequest clientRequest) {
        MapPropertiesDelegate propertiesDelegate = new MapPropertiesDelegate();
        final ContainerRequest containerRequest = new ContainerRequest(this.baseUri, clientRequest.getUri(), clientRequest.getMethod(), null, propertiesDelegate);
        containerRequest.getHeaders().putAll(clientRequest.getStringHeaders());
        final ByteArrayOutputStream clientOutput = new ByteArrayOutputStream();
        if (clientRequest.getEntity() != null) {
            clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                @Override
                public OutputStream getOutputStream(int contentLength) throws IOException {
                    MultivaluedMap<String, Object> clientHeaders = clientRequest.getHeaders();
                    if (contentLength != -1 && !clientHeaders.containsKey("Content-Length")) {
                        containerRequest.getHeaders().putSingle("Content-Length", String.valueOf(contentLength));
                    }
                    return clientOutput;
                }
            });
            clientRequest.enableBuffering();
            try {
                clientRequest.writeEntity();
            }
            catch (IOException e) {
                String msg = "Error while writing entity to the output stream.";
                LOGGER.log(Level.SEVERE, "Error while writing entity to the output stream.", e);
                throw new ProcessingException("Error while writing entity to the output stream.", e);
            }
        }
        containerRequest.setEntityStream(new ByteArrayInputStream(clientOutput.toByteArray()));
        boolean followRedirects = ClientProperties.getValue(clientRequest.getConfiguration().getProperties(), "jersey.config.client.followRedirects", true);
        InMemoryResponseWriter inMemoryResponseWriter = new InMemoryResponseWriter();
        containerRequest.setWriter(inMemoryResponseWriter);
        containerRequest.setSecurityContext(new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return null;
            }

            @Override
            public boolean isUserInRole(String role) {
                return false;
            }

            @Override
            public boolean isSecure() {
                return false;
            }

            @Override
            public String getAuthenticationScheme() {
                return null;
            }
        });
        this.appHandler.handle(containerRequest);
        return this.tryFollowRedirects(followRedirects, this.createClientResponse(clientRequest, inMemoryResponseWriter), new ClientRequest(clientRequest));
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(InMemoryConnector.this.apply(request));
                }
                catch (ProcessingException ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    @Override
    public void close() {
    }

    private ClientResponse createClientResponse(ClientRequest clientRequest, InMemoryResponseWriter responseWriter) {
        ClientResponse clientResponse = new ClientResponse(responseWriter.getStatusInfo(), clientRequest);
        clientResponse.getHeaders().putAll(responseWriter.getHeaders());
        clientResponse.setEntityStream(new ByteArrayInputStream(responseWriter.getEntity()));
        return clientResponse;
    }

    private ClientResponse tryFollowRedirects(boolean followRedirects, ClientResponse response, ClientRequest request) {
        if (!followRedirects) {
            return response;
        }
        block3: while (true) {
            switch (response.getStatus()) {
                case 302: 
                case 303: 
                case 307: {
                    request = new ClientRequest(request);
                    request.setUri(response.getLocation());
                    if (response.getStatus() == 303) {
                        request.setMethod("GET");
                    }
                    response = this.apply(request);
                    continue block3;
                }
            }
            break;
        }
        return response;
    }

    @Override
    public String getName() {
        return "Jersey InMemory Connector";
    }

    public static class InMemoryResponseWriter
    implements ContainerResponseWriter {
        private MultivaluedMap<String, String> headers;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private boolean committed;
        private Response.StatusType statusInfo;

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) {
            ArrayList<String> length = Lists.newArrayList();
            length.add(String.valueOf(contentLength));
            responseContext.getHeaders().put("Content-Length", length);
            this.headers = responseContext.getStringHeaders();
            this.statusInfo = responseContext.getStatusInfo();
            return this.baos;
        }

        @Override
        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            LOGGER.warning("Asynchronous server side invocations are not supported by InMemoryContainer.");
            return false;
        }

        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("Async server side invocations are not supported by InMemoryContainer.");
        }

        @Override
        public void commit() {
            this.committed = true;
        }

        @Override
        public void failure(Throwable error) {
            throw new ProcessingException("Server-side request processing failed with an error.", error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        public byte[] getEntity() {
            if (!this.committed) {
                throw new IllegalStateException("Response is not committed yet.");
            }
            return this.baos.toByteArray();
        }

        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        public Response.StatusType getStatusInfo() {
            return this.statusInfo;
        }
    }

    static class Provider
    implements ConnectorProvider {
        private final URI baseUri;
        private final ApplicationHandler appHandler;

        Provider(URI baseUri, ApplicationHandler appHandler) {
            this.baseUri = baseUri;
            this.appHandler = appHandler;
        }

        @Override
        public Connector getConnector(Client client, Configuration config) {
            return new InMemoryConnector(this.baseUri, this.appHandler);
        }
    }
}

