/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.Currency;

public class CurrencyValidatorForMonetaryAmount
implements ConstraintValidator<Currency, MonetaryAmount> {
    private List<CurrencyUnit> acceptedCurrencies;

    @Override
    public void initialize(Currency currency) {
        ArrayList<CurrencyUnit> acceptedCurrencies = new ArrayList<CurrencyUnit>();
        for (String currencyCode : currency.value()) {
            acceptedCurrencies.add(Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
        }
        this.acceptedCurrencies = Collections.unmodifiableList(acceptedCurrencies);
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.acceptedCurrencies.contains(value.getCurrency());
    }
}

