/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.sspi;

import com.sun.jna.LastErrorException;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.sql.SQLException;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.sspi.NTDSAPIWrapper;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class SSPIClient {
    public static String SSPI_DEFAULT_SPN_SERVICE_CLASS = "POSTGRES";
    private final Logger logger;
    private final PGStream pgStream;
    private final String spnServiceClass;
    private final boolean enableNegotiate;
    private IWindowsCredentialsHandle clientCredentials;
    private WindowsSecurityContextImpl sspiContext;
    private String targetName;

    public SSPIClient(PGStream pgStream, String spnServiceClass, boolean enableNegotiate, Logger logger2) {
        this.logger = logger2;
        this.pgStream = pgStream;
        String realServiceClass = spnServiceClass;
        if (spnServiceClass != null && spnServiceClass.isEmpty()) {
            spnServiceClass = null;
        }
        if (spnServiceClass == null) {
            spnServiceClass = SSPI_DEFAULT_SPN_SERVICE_CLASS;
        }
        this.spnServiceClass = spnServiceClass;
        this.enableNegotiate = enableNegotiate;
    }

    public boolean isSSPISupported() {
        try {
            if (!Platform.isWindows()) {
                this.logger.debug("SSPI not supported: non-Windows host");
                return false;
            }
            Class.forName("waffle.windows.auth.impl.WindowsSecurityContextImpl");
            return true;
        }
        catch (NoClassDefFoundError ex) {
            if (this.logger.logDebug()) {
                this.logger.debug("SSPI unavailable (no Waffle/JNA libraries?)", ex);
            }
            return false;
        }
        catch (ClassNotFoundException ex) {
            if (this.logger.logDebug()) {
                this.logger.debug("SSPI unavailable (no Waffle/JNA libraries?)", ex);
            }
            return false;
        }
    }

    private String makeSPN() throws PSQLException {
        HostSpec hs = this.pgStream.getHostSpec();
        try {
            return NTDSAPIWrapper.instance.DsMakeSpn(this.spnServiceClass, hs.getHost(), null, (short)hs.getPort(), null);
        }
        catch (LastErrorException ex) {
            throw new PSQLException("SSPI setup failed to determine SPN", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
        }
    }

    public void startSSPI() throws SQLException, IOException {
        String securityPackage = this.enableNegotiate ? "negotiate" : "kerberos";
        this.logger.debug("Beginning SSPI/Kerberos negotiation with SSPI package: " + securityPackage);
        try {
            try {
                this.clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)securityPackage);
                this.clientCredentials.initialize();
            }
            catch (Win32Exception ex) {
                throw new PSQLException("Could not obtain local Windows credentials for SSPI", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
            }
            try {
                this.targetName = this.makeSPN();
                if (this.logger.logDebug()) {
                    this.logger.debug("SSPI target name: " + this.targetName);
                }
                this.sspiContext = new WindowsSecurityContextImpl();
                this.sspiContext.setPrincipalName(this.targetName);
                this.sspiContext.setCredentialsHandle(this.clientCredentials.getHandle());
                this.sspiContext.setSecurityPackage(securityPackage);
                this.sspiContext.initialize(null, null, this.targetName);
            }
            catch (Win32Exception ex) {
                throw new PSQLException("Could not initialize SSPI security context", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
            }
            this.sendSSPIResponse(this.sspiContext.getToken());
            this.logger.debug("Sent first SSPI negotiation message");
        }
        catch (NoClassDefFoundError ex) {
            throw new PSQLException("SSPI cannot be used, Waffle or its dependencies are missing from the classpath", PSQLState.NOT_IMPLEMENTED, (Throwable)ex);
        }
    }

    public void continueSSPI(int msgLength) throws SQLException, IOException {
        if (this.sspiContext == null) {
            throw new IllegalStateException("Cannot continue SSPI authentication that we didn't begin");
        }
        this.logger.debug("Continuing SSPI negotiation");
        byte[] receivedToken = this.pgStream.Receive(msgLength);
        Sspi.SecBufferDesc continueToken = new Sspi.SecBufferDesc(2, receivedToken);
        this.sspiContext.initialize(this.sspiContext.getHandle(), continueToken, this.targetName);
        byte[] responseToken = this.sspiContext.getToken();
        if (responseToken.length > 0) {
            this.sendSSPIResponse(responseToken);
            this.logger.debug("Sent SSPI negotiation continuation message");
        } else {
            this.logger.debug("SSPI authentication complete, no reply required");
        }
    }

    private void sendSSPIResponse(byte[] outToken) throws IOException {
        this.pgStream.SendChar(112);
        this.pgStream.SendInteger4(4 + outToken.length);
        this.pgStream.Send(outToken);
        this.pgStream.flush();
    }

    public void dispose() {
        if (this.sspiContext != null) {
            this.sspiContext.dispose();
            this.sspiContext = null;
        }
        if (this.clientCredentials != null) {
            this.clientCredentials.dispose();
            this.clientCredentials = null;
        }
    }
}

