/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.error;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;

public class RenderException
extends RuntimeException
implements Renderable {
    private static final long serialVersionUID = 5155772408981115672L;
    public static final String KEY_PAGECONTEXT = "renderable.error";
    public boolean isNullTag = false;
    public boolean isEmptyStack = false;
    public String expectedTag = null;
    public String closingTag = null;
    public Exception exception = null;

    public static RenderException nullTag() {
        RenderException rex = new RenderException();
        rex.isNullTag = true;
        return rex;
    }

    public static RenderException unexpectedTag(String expected, String actual) {
        RenderException rex = new RenderException();
        rex.expectedTag = expected;
        rex.closingTag = actual;
        return rex;
    }

    public static RenderException emptyStack() {
        RenderException rex = new RenderException();
        rex.isEmptyStack = true;
        return rex;
    }

    public static RenderException caught(Exception ex) {
        RenderException rex = new RenderException();
        rex.exception = ex;
        return rex;
    }

    public void renderOn(HtmlCanvas html) throws IOException {
        Renderable errorComponent;
        html.div(HtmlAttributesFactory.style("color:red"));
        if (this.isEmptyStack) {
            html.write("[Render Error] unexpected close()");
            return;
        }
        if (this.expectedTag != null) {
            html.write(String.format("[Render Error] expected [%s] actual [%s]", this.expectedTag, this.closingTag));
        }
        if (this.exception != null) {
            html.write(String.format("[Render Error] general exception [%s]", this.exception.getMessage()));
        }
        if ((errorComponent = (Renderable)html.getPageContext().getObject(KEY_PAGECONTEXT, new Object[0])) != null) {
            html.write(" in ").write(errorComponent.getClass().getName());
        } else {
            html.a(HtmlAttributesFactory.href("?inspect")).write(" Inspect details")._a();
            this.renderStackTraceOn(html);
        }
        html._div();
    }

    public void renderStackTraceOn(HtmlCanvas html) throws IOException {
        if (null == this.exception) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter buffer = new PrintWriter(sw);
        this.exception.printStackTrace(buffer);
        html.pre().write(sw.toString(), true)._pre();
        html.hr();
    }

    public String toString() {
        return super.toString() + "{expected=" + this.expectedTag + ",actual=" + this.closingTag + ",exception=" + this.exception + ",empty=" + this.isEmptyStack + ",null=" + this.isNullTag + "}";
    }
}

