/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.ext.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.PageContext;
import org.rendersnake.Renderable;
import org.rendersnake.ext.servlet.PostHandler;
import org.rendersnake.ext.servlet.RequestHeadersMap;
import org.rendersnake.ext.servlet.RequestParametersMap;
import org.rendersnake.ext.servlet.SessionAttributesMap;
import org.rendersnake.ext.spring.HtmlCanvasFactory;

@Singleton
public class GuiceComponentServlet
extends HttpServlet {
    private static final long serialVersionUID = -5260542693799682553L;
    private static final Logger LOG = Logger.getLogger("org.rendersnake.ext.guice");
    @Inject
    private Injector injector;
    private Map<String, Renderable> dispatchMap = new HashMap<String, Renderable>();
    private Map<String, PostHandler> handlerMap = new HashMap<String, PostHandler>();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getPathInfo();
        Renderable component = this.dispatchMap.get(uri);
        if (component == null) {
            response.sendError(404);
        } else {
            HtmlCanvas canvas = HtmlCanvasFactory.createCanvas(request, response, response.getWriter());
            PageContext context = canvas.getPageContext();
            String q = request.getQueryString();
            context.withObject("http.request.path", request.getPathTranslated());
            context.withObject("http.request.uri.query", request.getRequestURI() + (q == null ? "" : "?" + q));
            context.withObject("http.session", new SessionAttributesMap(request));
            context.withObject("http.request.parameters", new RequestParametersMap(request));
            context.withObject("http.request.headers", new RequestHeadersMap(request));
            canvas.render(component);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getPathInfo();
        PostHandler handler = this.handlerMap.get(uri);
        if (handler == null) {
            resp.sendError(404);
        } else {
            handler.handlePost(req, resp);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        for (Key<?> key : this.injector.getBindings().keySet()) {
            Named annotation;
            Type type = key.getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class klass = (Class)type;
            if (Renderable.class.isAssignableFrom(klass)) {
                Renderable p = (Renderable)this.injector.getInstance(klass);
                annotation = klass.getAnnotation(Named.class);
                if (annotation != null) {
                    this.dispatchMap.put(annotation.value(), p);
                    LOG.info("Binding component:" + klass + " to:" + annotation);
                } else {
                    LOG.severe("Missing @Named annotation in component:" + klass);
                }
            }
            if (!PostHandler.class.isAssignableFrom(klass)) continue;
            PostHandler h2 = (PostHandler)this.injector.getInstance(klass);
            annotation = klass.getAnnotation(Named.class);
            if (annotation != null) {
                this.handlerMap.put(annotation.value(), h2);
                LOG.info("Binding component:" + klass + " to:" + annotation);
                continue;
            }
            LOG.severe("Missing @Named annotation in component:" + klass);
        }
        super.init(config);
    }
}

