/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.rendersnake.internal.ContextMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleContextMap
implements Serializable,
ContextMap {
    private static final long serialVersionUID = -6319488346145394221L;
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();

    public SimpleContextMap() {
    }

    public SimpleContextMap(Map<?, ?> attributesMap) {
        this.attributes = attributesMap;
    }

    @Override
    public Object getObject(String key, Object ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        return value;
    }

    @Override
    public Boolean getBoolean(String key, Boolean ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)((Object)value));
        }
        return (Boolean)value;
    }

    @Override
    public Float getFloat(String key, Float ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)((Object)value)));
        }
        return (Float)value;
    }

    @Override
    public Integer getInteger(String key, Integer ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        if (value instanceof String) {
            return Integer.parseInt((String)((Object)value));
        }
        return (Integer)value;
    }

    @Override
    public Long getLong(String key, Long ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        if (value instanceof String) {
            return Long.parseLong((String)((Object)value));
        }
        return (Long)value;
    }

    @Override
    public String getString(String key, String ... optional) {
        Serializable value = this.attributes.get(key);
        if (value == null) {
            return optional.length == 0 ? null : optional[0];
        }
        return (String)((Object)value);
    }

    @Override
    public SimpleContextMap withString(String key, String value) {
        this.attributes.put(key, (Serializable)((Object)value));
        return this;
    }

    @Override
    public SimpleContextMap withBoolean(String key, Boolean value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SimpleContextMap withLong(String key, Long value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SimpleContextMap withFloat(String key, Float value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SimpleContextMap withInteger(String key, Integer value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SimpleContextMap withObject(String key, Object value) {
        this.attributes.put(key, (Serializable)value);
        return this;
    }

    @Override
    public Object clear(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<String, Serializable> each : this.attributes.entrySet()) {
            map.put(each.getKey(), each.getValue());
        }
        return map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes.toString();
    }
}

