/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.HtmlEscapeHandler;

public class StringEscapeUtils
implements HtmlEscapeHandler {
    private static final Logger LOG = Logger.getLogger("org.rendersnake.internal");

    private StringEscapeUtils() {
    }

    public static void init() {
        try {
            HtmlEscapeHandler soleInstance;
            Class.forName("org.apache.commons.lang3.StringEscapeUtils");
            HtmlCanvas.HTML_ESCAPE_HANDLER = soleInstance = (HtmlEscapeHandler)Class.forName("org.rendersnake.ext.apache.CommonsHtmlEscapeHandler").newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Unable to use org.apache.commons.lang.StringEscapeUtils, make sure to initialize the HtmlCanvas.HTML_ESCAPE_HANDLER static field.");
        }
        catch (InstantiationException e) {
            LOG.log(Level.SEVERE, "Unable to install org.rendersnake.ext.apache.CommonsHtmlEscapeHandler", e);
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.SEVERE, "Unable to install org.rendersnake.ext.apache.CommonsHtmlEscapeHandler", e);
        }
    }

    public void escapeHtml(Writer out, String text) throws IOException {
        this.escapeXml(out, text);
    }

    public void escapeXml(Writer out, String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char v = c;
            if (v < ' ' || v > '\u007f' || v == '&' || v == '\'' || v == '<' || v == '>' || v == '\"') {
                out.append('&').append('#').append(Integer.toString(v, 10)).append(';');
                continue;
            }
            out.append(c);
        }
    }

    public void escapeEcmascript(Writer out, String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char v = c;
            if (v == '\\' || v == '/' || v == '\"' || v == '\'') {
                out.append('&').append('#').append(Integer.toString(v, 10)).append(';');
                continue;
            }
            out.append(c);
        }
    }

    public static void escapeISOCharacters(Writer out, String input) throws IOException {
        for (int i = 0; i < input.length(); ++i) {
            char each = input.charAt(i);
            char v = each;
            if (v < ' ' || v > '\u007f') {
                out.append('&').append('#').append(Integer.toString(v, 10)).append(';');
                continue;
            }
            out.append(each);
        }
    }
}

