/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.tools;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.PageContext;
import org.rendersnake.Renderable;
import org.rendersnake.error.RenderException;
import org.rendersnake.ext.servlet.HtmlServletCanvas;
import org.rendersnake.internal.CharactersWriteable;
import org.rendersnake.tools.Inspector;
import org.rendersnake.tools.LoggingPageContext;

public class DebugHtmlCanvas
extends HtmlServletCanvas {
    private boolean insideBody = false;
    public boolean enabled = true;
    public int renderCount = 0;

    public DebugHtmlCanvas(HttpServletRequest request, HttpServletResponse response, Writer out) {
        super(request, response, out);
    }

    public HtmlCanvas render(Renderable component) throws IOException {
        if (null == component) {
            return this;
        }
        if (!(component instanceof RenderException)) {
            this.getPageContext().withObject("renderable.error", component);
        }
        if (this.enabled) {
            ++this.renderCount;
            if (this.insideBody) {
                super.render(new Inspector(component));
            } else {
                super.render(component);
            }
        } else {
            super.render(component);
        }
        return this;
    }

    public HtmlCanvas body() throws IOException {
        super.body();
        this.insideBody = true;
        return this.renderInspectorCss();
    }

    public HtmlCanvas body(CharactersWriteable attrs) throws IOException {
        super.body(attrs);
        this.insideBody = true;
        return this.renderInspectorCss();
    }

    public HtmlCanvas _body() throws IOException {
        super._body();
        this.insideBody = false;
        return this;
    }

    private HtmlCanvas renderInspectorCss() throws IOException {
        Inspector.renderCssOn(this);
        return this;
    }

    protected PageContext createPageContext() {
        return new LoggingPageContext();
    }
}

