/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.rrd4j.core.jrrd.CDPStatusBlock;
import org.rrd4j.core.jrrd.ConsolidationFunctionType;
import org.rrd4j.core.jrrd.DataChunk;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.RRDatabase;
import org.rrd4j.core.jrrd.UnivalArray;

public class Archive {
    final RRDatabase db;
    final long headerOffset;
    private final long headerSize;
    long dataOffset;
    private final ConsolidationFunctionType type;
    final int rowCount;
    final int pdpCount;
    final double xff;
    List<CDPStatusBlock> cdpStatusBlocks;
    int currentRow;
    private double[][] values;

    Archive(RRDatabase db) throws IOException {
        this.db = db;
        RRDFile file = db.rrdFile;
        this.headerOffset = file.getFilePointer();
        this.type = ConsolidationFunctionType.valueOf(file.readString(20).toUpperCase());
        file.align(file.getBits() / 8);
        this.rowCount = file.readLong();
        this.pdpCount = file.readLong();
        UnivalArray par = file.getUnivalArray(10);
        this.xff = par.getDouble(rra_par_en.RRA_cdp_xff_val);
        this.headerSize = file.getFilePointer() - this.headerOffset;
    }

    public ConsolidationFunctionType getType() {
        return this.type;
    }

    void loadCDPStatusBlocks(RRDFile file, int numBlocks) throws IOException {
        this.cdpStatusBlocks = new ArrayList<CDPStatusBlock>();
        for (int i = 0; i < numBlocks; ++i) {
            this.cdpStatusBlocks.add(new CDPStatusBlock(file));
        }
    }

    public CDPStatusBlock getCDPStatusBlock(int index) {
        return this.cdpStatusBlocks.get(index);
    }

    public Iterator<CDPStatusBlock> getCDPStatusBlocks() {
        return this.cdpStatusBlocks.iterator();
    }

    void loadCurrentRow(RRDFile file) throws IOException {
        this.currentRow = file.readLong();
    }

    void loadData(RRDFile file, int dsCount) throws IOException {
        this.dataOffset = file.getFilePointer();
        file.skipBytes(8 * this.rowCount * dsCount);
    }

    void loadData(DataChunk chunk) throws IOException {
        long rowIndexPointer = chunk.startOffset < 0 ? (long)(this.currentRow + 1) : (long)(this.currentRow + chunk.startOffset + 1);
        if (rowIndexPointer < (long)this.rowCount) {
            this.db.rrdFile.seek(this.dataOffset + (long)chunk.dsCount * rowIndexPointer * 8L);
        } else {
            this.db.rrdFile.seekToEndOfFile();
        }
        double[][] data = chunk.data;
        int row = 0;
        int i = chunk.startOffset;
        while (i < this.rowCount - chunk.endOffset) {
            if (i < 0) {
                Arrays.fill(data[row], Double.NaN);
            } else if (i >= this.rowCount) {
                Arrays.fill(data[row], Double.NaN);
            } else {
                if (rowIndexPointer >= (long)this.rowCount) {
                    this.db.rrdFile.seek(this.dataOffset + (long)chunk.dsCount * (rowIndexPointer -= (long)this.rowCount) * 8L);
                }
                for (int ii = 0; ii < chunk.dsCount; ++ii) {
                    data[row][ii] = this.db.rrdFile.readDouble();
                }
                ++rowIndexPointer;
            }
            ++i;
            ++row;
        }
    }

    void printInfo(PrintStream s2, NumberFormat numberFormat, int index) {
        StringBuilder sb = new StringBuilder("rra[");
        sb.append(index);
        s2.print(sb);
        s2.print("].cf = \"");
        s2.print((Object)this.type);
        s2.println("\"");
        s2.print(sb);
        s2.print("].rows = ");
        s2.println(this.rowCount);
        s2.print(sb);
        s2.print("].pdp_per_row = ");
        s2.println(this.pdpCount);
        s2.print(sb);
        s2.print("].xff = ");
        s2.println(this.xff);
        sb.append("].cdp_prep[");
        int cdpIndex = 0;
        for (CDPStatusBlock cdp : this.cdpStatusBlocks) {
            s2.print(sb);
            s2.print(cdpIndex);
            s2.print("].value = ");
            double value = cdp.value;
            s2.println(Double.isNaN(value) ? "NaN" : numberFormat.format(value));
            s2.print(sb);
            s2.print(cdpIndex++);
            s2.print("].unknown_datapoints = ");
            s2.println(cdp.unknownDatapoints);
        }
    }

    void toXml(PrintStream s2) {
        try {
            s2.println("\t<rra>");
            s2.print("\t\t<cf> ");
            s2.print((Object)this.type);
            s2.println(" </cf>");
            s2.print("\t\t<pdp_per_row> ");
            s2.print(this.pdpCount);
            s2.print(" </pdp_per_row> <!-- ");
            s2.print(this.db.header.pdpStep * this.pdpCount);
            s2.println(" seconds -->");
            s2.print("\t\t<xff> ");
            s2.print(this.xff);
            s2.println(" </xff>");
            s2.println();
            s2.println("\t\t<cdp_prep>");
            for (int i = 0; i < this.cdpStatusBlocks.size(); ++i) {
                this.cdpStatusBlocks.get(i).toXml(s2);
            }
            s2.println("\t\t</cdp_prep>");
            s2.println("\t\t<database>");
            long timer = -(this.rowCount - 1);
            int counter = 0;
            int row = this.currentRow;
            this.db.rrdFile.seek(this.dataOffset + (long)((row + 1) * this.db.header.dsCount * 8));
            long lastUpdate = this.db.lastUpdate.getTime() / 1000L;
            int pdpStep = this.db.header.pdpStep;
            DecimalFormat numberFormat = new DecimalFormat("0.0000000000E0", DecimalFormatSymbols.getInstance(Locale.US));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            while (counter++ < this.rowCount) {
                if (++row == this.rowCount) {
                    row = 0;
                    this.db.rrdFile.seek(this.dataOffset);
                }
                long now = lastUpdate - lastUpdate % (long)(this.pdpCount * pdpStep) + timer * (long)this.pdpCount * (long)pdpStep;
                ++timer;
                s2.print("\t\t\t<!-- ");
                s2.print(dateFormat.format(new Date(now * 1000L)));
                s2.print(" / ");
                s2.print(now);
                s2.print(" --> ");
                s2.println("<row>");
                for (int col = 0; col < this.db.header.dsCount; ++col) {
                    s2.print("<v> ");
                    double value = this.db.rrdFile.readDouble();
                    if (Double.isNaN(value)) {
                        s2.print("NaN");
                    } else {
                        s2.print(numberFormat.format(value));
                    }
                    s2.print(" </v>");
                }
                s2.println("</row>");
            }
            s2.println("\t\t</database>");
            s2.println("\t</rra>");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public double[][] getValues() throws IOException {
        if (this.values != null) {
            return this.values;
        }
        this.values = new double[this.db.header.dsCount][this.rowCount];
        int row = this.currentRow;
        this.db.rrdFile.seek(this.dataOffset + (long)((row + 1) * this.db.header.dsCount * 8));
        for (int counter = 0; counter < this.rowCount; ++counter) {
            if (++row == this.rowCount) {
                row = 0;
                this.db.rrdFile.seek(this.dataOffset);
            }
            for (int col = 0; col < this.db.header.dsCount; ++col) {
                double value;
                this.values[col][counter] = value = this.db.rrdFile.readDouble();
            }
        }
        return this.values;
    }

    public int getPdpCount() {
        return this.pdpCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public double getXff() {
        return this.xff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Archive: OFFSET=0x");
        sb.append(Long.toHexString(this.headerOffset)).append(", SIZE=0x").append(Long.toHexString(this.headerSize)).append(", type=").append((Object)this.type).append(", rowCount=").append(this.rowCount).append(", pdpCount=").append(this.pdpCount).append(", xff=").append(this.xff).append(", currentRow=").append(this.currentRow).append("]");
        for (CDPStatusBlock cdp : this.cdpStatusBlocks) {
            sb.append("\n\t\t");
            sb.append(cdp.toString());
        }
        return sb.toString();
    }

    private static enum rra_par_en {
        RRA_cdp_xff_val,
        RRA_hw_alpha;

    }
}

