/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import org.rrd4j.core.jrrd.DataSourceType;
import org.rrd4j.core.jrrd.PDPStatusBlock;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class DataSource {
    private final long offset;
    private final long size;
    private final String name;
    private final DataSourceType type;
    private final int minimumHeartbeat;
    private final double minimum;
    private final double maximum;
    private PDPStatusBlock pdpStatusBlock;

    DataSource(RRDFile file) throws IOException {
        this.offset = file.getFilePointer();
        this.name = file.readString(20);
        this.type = DataSourceType.valueOf(file.readString(20).toUpperCase());
        UnivalArray par = file.getUnivalArray(10);
        this.minimumHeartbeat = (int)par.getLong(ds_param_en.DS_mrhb_cnt);
        this.minimum = par.getDouble(ds_param_en.DS_min_val);
        this.maximum = par.getDouble(ds_param_en.DS_max_val);
        this.size = file.getFilePointer() - this.offset;
    }

    void loadPDPStatusBlock(RRDFile file) throws IOException {
        this.pdpStatusBlock = new PDPStatusBlock(file);
    }

    public PDPStatusBlock getPDPStatusBlock() {
        return this.pdpStatusBlock;
    }

    public int getMinimumHeartbeat() {
        return this.minimumHeartbeat;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public String getName() {
        return this.name;
    }

    void printInfo(PrintStream s2, NumberFormat numberFormat) {
        StringBuilder sb = new StringBuilder("ds[");
        sb.append(this.name);
        s2.print(sb);
        s2.print("].type = \"");
        s2.print((Object)this.type);
        s2.println("\"");
        s2.print(sb);
        s2.print("].minimal_heartbeat = ");
        s2.println(this.minimumHeartbeat);
        s2.print(sb);
        s2.print("].min = ");
        s2.println(Double.isNaN(this.minimum) ? "NaN" : numberFormat.format(this.minimum));
        s2.print(sb);
        s2.print("].max = ");
        s2.println(Double.isNaN(this.maximum) ? "NaN" : numberFormat.format(this.maximum));
        s2.print(sb);
        s2.print("].last_ds = ");
        s2.println(this.pdpStatusBlock.lastReading);
        s2.print(sb);
        s2.print("].value = ");
        double value = this.pdpStatusBlock.value;
        s2.println(Double.isNaN(value) ? "NaN" : numberFormat.format(value));
        s2.print(sb);
        s2.print("].unknown_sec = ");
        s2.println(this.pdpStatusBlock.unknownSeconds);
    }

    void toXml(PrintStream s2) {
        s2.println("\t<ds>");
        s2.print("\t\t<name> ");
        s2.print(this.name);
        s2.println(" </name>");
        s2.print("\t\t<type> ");
        s2.print((Object)this.type);
        s2.println(" </type>");
        s2.print("\t\t<minimal_heartbeat> ");
        s2.print(this.minimumHeartbeat);
        s2.println(" </minimal_heartbeat>");
        s2.print("\t\t<min> ");
        s2.print(this.minimum);
        s2.println(" </min>");
        s2.print("\t\t<max> ");
        s2.print(this.maximum);
        s2.println(" </max>");
        s2.println();
        s2.println("\t\t<!-- PDP Status -->");
        s2.print("\t\t<last_ds> ");
        s2.print(this.pdpStatusBlock.lastReading);
        s2.println(" </last_ds>");
        s2.print("\t\t<value> ");
        s2.print(this.pdpStatusBlock.value);
        s2.println(" </value>");
        s2.print("\t\t<unknown_sec> ");
        s2.print(this.pdpStatusBlock.unknownSeconds);
        s2.println(" </unknown_sec>");
        s2.println("\t</ds>");
        s2.println();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[DataSource: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", type=");
        sb.append(this.type.toString());
        sb.append(", minHeartbeat=");
        sb.append(this.minimumHeartbeat);
        sb.append(", min=");
        sb.append(this.minimum);
        sb.append(", max=");
        sb.append(this.maximum);
        sb.append("]");
        sb.append("\n\t\t");
        sb.append(this.pdpStatusBlock.toString());
        return sb.toString();
    }

    private static enum ds_param_en {
        DS_mrhb_cnt,
        DS_min_val,
        DS_max_val,
        DS_cde;

    }
}

