/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.logging;

import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.logging.FormattedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLog
extends FormattedLog {
    private final Logger logger;
    private final Level level;

    public SLF4JLog() {
        this(LoggerFactory.getLogger(DBI.class.getPackage().getName()));
    }

    public SLF4JLog(Logger logger2) {
        this(logger2, Level.TRACE);
    }

    public SLF4JLog(Logger logger2, Level level) {
        this.logger = logger2;
        this.level = level;
    }

    @Override
    protected boolean isEnabled() {
        return this.level.isEnabled(this.logger);
    }

    @Override
    protected void log(String msg) {
        this.level.log(this.logger, msg);
    }

    public static enum Level {
        TRACE{

            @Override
            boolean isEnabled(Logger logger2) {
                return logger2.isTraceEnabled();
            }

            @Override
            void log(Logger logger2, String msg) {
                logger2.trace(msg);
            }
        }
        ,
        DEBUG{

            @Override
            boolean isEnabled(Logger logger2) {
                return logger2.isDebugEnabled();
            }

            @Override
            void log(Logger logger2, String msg) {
                logger2.debug(msg);
            }
        }
        ,
        INFO{

            @Override
            boolean isEnabled(Logger logger2) {
                return logger2.isInfoEnabled();
            }

            @Override
            void log(Logger logger2, String msg) {
                logger2.info(msg);
            }
        }
        ,
        WARN{

            @Override
            boolean isEnabled(Logger logger2) {
                return logger2.isWarnEnabled();
            }

            @Override
            void log(Logger logger2, String msg) {
                logger2.warn(msg);
            }
        }
        ,
        ERROR{

            @Override
            boolean isEnabled(Logger logger2) {
                return logger2.isErrorEnabled();
            }

            @Override
            void log(Logger logger2, String msg) {
                logger2.error(msg);
            }
        };


        abstract boolean isEnabled(Logger var1);

        abstract void log(Logger var1, String var2);
    }
}

