/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterColumnMapperFactory {
    public Class<? extends ResultColumnMapperFactory>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            RegisterColumnMapperFactory ma = (RegisterColumnMapperFactory)annotation;
            final ResultColumnMapperFactory[] m3 = new ResultColumnMapperFactory[ma.value().length];
            try {
                Class<? extends ResultColumnMapperFactory>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m3[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result column mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultColumnMapperFactory factory : m3) {
                            q.registerColumnMapper(factory);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterColumnMapperFactory ma = (RegisterColumnMapperFactory)annotation;
            final ResultColumnMapperFactory[] m3 = new ResultColumnMapperFactory[ma.value().length];
            try {
                Class<? extends ResultColumnMapperFactory>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m3[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result column mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultColumnMapperFactory factory : m3) {
                            q.registerColumnMapper(factory);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined for parameter");
        }
    }
}

