/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterMapperFactory {
    public Class<? extends ResultSetMapperFactory>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            RegisterMapperFactory ma = (RegisterMapperFactory)annotation;
            final ResultSetMapperFactory[] m3 = new ResultSetMapperFactory[ma.value().length];
            try {
                Class<? extends ResultSetMapperFactory>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m3[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result set mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultSetMapperFactory factory : m3) {
                            q.registerMapper(factory);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterMapperFactory ma = (RegisterMapperFactory)annotation;
            final ResultSetMapperFactory[] m3 = new ResultSetMapperFactory[ma.value().length];
            try {
                Class<? extends ResultSetMapperFactory>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m3[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result set mapper", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultSetMapperFactory factory : m3) {
                            q.registerMapper(factory);
                        }
                    }
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined for parameter");
        }
    }
}

